/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ctype.h>
#include <config.h>
#include <gnome.h>
#include <libgnorba/gnorba.h>


#include <gda-server.h>
#include <gda-connection.h>

#include "gda-entries.h"

static GtkWidget*    browser;
static GtkWidget*    workarea;
static GtkWidget*    status_bar;
static CORBA_ORB     orb;



void
about_cmd(void)
{
  ;
}

GtkWidget*
create_gda_server_config()
{
  GtkWidget* table;
  GtkWidget* exe_server;
  GtkWidget* shlib_server;
  GtkWidget* entry;
  GtkWidget* label;
  GtkWidget* save;
  GtkWidget* frame;
  
  frame = gtk_frame_new(_("GDA Server Properties"));
  table = gtk_table_new(7,2, FALSE);
  gtk_table_set_col_spacings(GTK_TABLE(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 15);
  
  label = gtk_label_new(_("Type"));
  gtk_misc_set_alignment(GTK_MISC(label), 0.1, 1.0);
  exe_server = gtk_radio_button_new_with_label(NULL, _("Standalone Executable"));
  shlib_server = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(exe_server)),
						 _("Shared Library"));
  gtk_object_set_data(GTK_OBJECT(frame), "exe_server", exe_server);
  gtk_object_set_data(GTK_OBJECT(frame), "shlib_server",
		      shlib_server);
  
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 0, 1,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), exe_server,
		   1, 2, 0, 1,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), shlib_server,
		   1, 2, 1, 2,
		   GTK_FILL, 0, 0, 0);

  
  
  label = gtk_label_new(_("Repository ID"));
  entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry), "Repository ID");
  gtk_entry_set_editable(GTK_ENTRY(entry), 0);
  gtk_object_set_data(GTK_OBJECT(frame), "repository ID", entry);
		      
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 2, 3,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 2, 3,
		   GTK_FILL, 0, 0, 0);




  label = gtk_label_new(_("Description"));
  entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry), "Description");
  gtk_object_set_data(GTK_OBJECT(frame), "description", entry);
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 3, 4,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 3, 4,
		   GTK_FILL, 0, 0, 0);

  label = gtk_label_new(_("Location"));
  entry = gnome_file_entry_new("ServerLocationInfo",
			       _("GDA Server Location"));
  gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(entry))),
		     "Location");
  gtk_object_set_data(GTK_OBJECT(frame), "location", gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(entry)));
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 4, 5,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 4, 5,
		   GTK_FILL, 0, 0, 0);
  save = gtk_button_new_with_label(_("OK"));
  gtk_table_attach(GTK_TABLE(table), save,
		   0, 2, 5, 6,
		   GTK_FILL, 0, 0, 0);
  gtk_object_set_data(GTK_OBJECT(frame), "save", save);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_signal_connect(GTK_OBJECT(save), "clicked",
		     GTK_SIGNAL_FUNC(accept_provider_changes), frame);
  return frame;
}
  
GtkWidget*
create_gda_dsn_config()
{
  GtkWidget* table;
  GtkWidget* entry;
  GtkWidget* label;
  GtkWidget* save;
  GtkWidget* frame;
    
  frame = gtk_frame_new(_("GDA Data Source Properties"));
  table = gtk_table_new(6,2, FALSE);
  gtk_table_set_col_spacings(GTK_TABLE(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 15);
  
  label = gtk_label_new(_("Provider"));
  entry = gtk_entry_new();
  gtk_signal_connect(GTK_OBJECT(entry), "changed",
		     GTK_SIGNAL_FUNC(entry_edited), frame);
  
  gtk_object_set_data(GTK_OBJECT(frame), "provider", entry);

  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 0, 1,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 0, 1,
		   GTK_FILL, 0, 0, 0);
  
  label = gtk_label_new(_("Data Source Name(DSN)"));
  entry = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(frame), "DSN", entry);
  gtk_signal_connect(GTK_OBJECT(entry), "changed",
		     GTK_SIGNAL_FUNC(entry_edited), frame);
		      
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 1, 2,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 1, 2,
		   GTK_FILL, 0, 0, 0);



  label = gtk_label_new(_("Description"));
  entry = gtk_entry_new();
  gtk_object_set_data(GTK_OBJECT(frame), "description", entry);
  gtk_signal_connect(GTK_OBJECT(entry), "changed",
		     GTK_SIGNAL_FUNC(entry_edited), frame);
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 2, 3,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 2, 3,
		   GTK_FILL, 0, 0, 0);

  label = gtk_label_new(_("Driver Configuration"));
  entry = gtk_entry_new();
  
  gtk_object_set_data(GTK_OBJECT(frame), "configuration", entry);
  gtk_signal_connect(GTK_OBJECT(entry), "changed",
		     GTK_SIGNAL_FUNC(entry_edited), frame);
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 3, 4,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 3, 4,
		   GTK_FILL, 0, 0, 0);

  save = gtk_button_new_with_label(_("Accept"));
  gtk_table_attach(GTK_TABLE(table), save,
		   0, 2, 4, 5,
		   GTK_FILL, 0, 0, 0);

  gtk_object_set_data(GTK_OBJECT(frame), "save", save);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_signal_connect(GTK_OBJECT(save), "clicked",
		     GTK_SIGNAL_FUNC(accept_entry_changes), frame);
  return frame;
}

GtkWidget*
create_gda_servers()
{
  GtkWidget*      scrolledw;
  
  scrolledw = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledw),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  browser = gtk_ctree_new(1, 0);
  gdamgr_refresh_provider_tree(browser);

  gtk_widget_set_usize(scrolledw, 300, 200);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledw),
					browser);
  gtk_object_set_data(GTK_OBJECT(scrolledw), "ctree", browser);

  gtk_clist_columns_autosize(GTK_CLIST(browser));
  return scrolledw;
}

static GnomeUIInfo gda_manager_menu_new[] = {
  GNOMEUIINFO_MENU_NEW_ITEM("GDA Provider", "the server tip", new_provider_cmd, 0),
  GNOMEUIINFO_MENU_NEW_ITEM("GDA Data Source", "the datasource tip", new_datasource_cmd, 0),
  GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu_file[] = {
  GNOMEUIINFO_MENU_NEW_SUBTREE(gda_manager_menu_new), 
  GNOMEUIINFO_MENU_SAVE_ITEM(save_cmd, NULL),
  GNOMEUIINFO_MENU_EXIT_ITEM(quit_cmd, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu_edit [] = {
  GNOMEUIINFO_MENU_CUT_ITEM(delete_cmd, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu_help [] = {
  GNOMEUIINFO_MENU_ABOUT_ITEM(about_cmd, NULL), 
  GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu[] = {
  GNOMEUIINFO_MENU_FILE_TREE(gda_manager_menu_file),
  GNOMEUIINFO_MENU_EDIT_TREE(gda_manager_menu_edit),
  GNOMEUIINFO_MENU_HELP_TREE(gda_manager_menu_help),
  GNOMEUIINFO_END
};



int
main(int argc, char* argv[])
{
  CORBA_Environment ev;
  GtkWidget*        app;
  GtkWidget*        win;
  GnomeDockItem*    item;
  GtkWidget*        toolbar;
  GtkWidget*        paned;
  static gint       provider_property_page;
  static gint       dsn_property_page;
  static gint       config_property_page;
  
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  CORBA_exception_init(&ev);
  
  orb = gnome_CORBA_init_with_popt_table("gda", VERSION,
					 &argc, argv,
					 NULL, 0, NULL, 0, &ev);

  app = gnome_app_new("gda", _("GDA Administrator"));
  gtk_signal_connect(GTK_OBJECT(app), "delete_event",
		     GTK_SIGNAL_FUNC(quit_cmd), NULL);

  need_save = 0;
  gdamgr_build_gda_info();
  
  win = create_gda_servers();
  workarea = gtk_notebook_new();
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(workarea), FALSE);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(workarea), 0);
  gtk_container_set_border_width(GTK_CONTAINER(workarea), 0);

  gtk_object_set_data(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(win), "ctree")),
		      "notebook", workarea);
  
  provider_property_page = 1;
  dsn_property_page = 2;
  config_property_page = 3;
  gtk_object_set_data(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(win), "ctree")),
		      "provider-page", &provider_property_page);
  gtk_object_set_data(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(win), "ctree")),
		      "dsn-page", &dsn_property_page);
  gtk_object_set_data(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(win), "ctree")),
		      "config-page", &config_property_page);

  gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			   gtk_label_new("WORKAREA"),
			   gtk_label_new("WORKAREA LABEL")); 
  gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			   create_gda_server_config(),
			   gtk_label_new("GDA SERVER PROP"));
  gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			   create_gda_dsn_config(),
			   gtk_label_new("DSN PROP PAGE"));
  gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			   gtk_label_new("WORKAREA"),
			   gtk_label_new("CONFIGURATOR PAGE"));
  paned = gtk_hpaned_new();
  gtk_paned_pack1(GTK_PANED(paned),
		  win,
		  1, 1);

  gtk_paned_pack2(GTK_PANED(paned),
		  workarea,
		  1, 1);
  

  gnome_app_set_contents(GNOME_APP(app), paned);
  gnome_app_create_menus_with_data(GNOME_APP(app), gda_manager_menu,  win);

  item = gnome_app_get_dock_item_by_name (GNOME_APP (app), GNOME_APP_TOOLBAR_NAME);
  
  if (item)
    {
      toolbar = gnome_dock_item_get_child (item);
      gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
    }
  status_bar = gnome_appbar_new(TRUE, TRUE, FALSE);

  gnome_app_set_statusbar(GNOME_APP(app), status_bar);
  gtk_widget_show_all(app);
  gtk_main();
  exit(0);
}
