/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_server_h__
#define __gda_server_h__ 1
#include <libgnorba/gnorba.h>

typedef struct _Gda_Server
{
  GoadServerType type;
  gchar* name;
  gchar* comment;
  gchar* location;
  gchar* repo_id;
} Gda_Server;

#define GDA_SERVER_GOAD_TYPE(srv) ((srv) ? (srv)->type : 0)
#define GDA_SERVER_NAME(srv)      ((srv) ? (srv)->name : 0)
#define GDA_SERVER_COMMENT(srv)   ((srv) ? (srv)->comment : 0)
#define GDA_SERVER_LOCATION(srv)  ((srv) ? (srv)->location : 0)
#define GDA_SERVER_REPO_ID(srv)   ((srv) ? (srv)->repo_id : 0)

Gda_Server* gda_server_new                    (void);
Gda_Server* gda_server_copy                   (Gda_Server*);
void        gda_server_free                   (Gda_Server*);
GList*      gda_server_list                   (void);
GList*      gda_list_datasources              (void);
GList*      gda_list_datasources_for_provider (gchar* provider);

#endif
