/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gnome_db_browser_h__
#define __gnome_db_browser_h__ 1

#include <gnome.h>
#include <gda.h>
#include <gda-connection.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_BROWSER            (gnome_db_browser_get_type())
#define GNOME_DB_BROWSER(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_BROWSER, GnomeDbBrowser)
#define GNOME_DB_BROWSER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_BROWSER, GnomeDbBrowserClass)
#define GNOME_DB_IS_BROWSER(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_BROWSER)
#define GNOME_DB_IS_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_BROWSER))

typedef struct _GnomeDbBrowser      GnomeDbBrowser;
typedef struct _GnomeDbBrowserClass GnomeDbBrowserClass;

struct _GnomeDbBrowser
{
  GtkVBox         vbox;
  Gda_Connection* cnc;
  GtkWidget*      object_list;
  GtkWidget*      object_description;
  
  /* toggle buttons */
  GtkWidget*      tables_button;
  GtkWidget*      views_button;
  GtkWidget*      procs_button;
};

struct _GnomeDbBrowserClass
{
  GtkVBoxClass parent_class;
  /*
   * Signals
   */
  void         (*connection_changed)(GnomeDbBrowser *brw);
};

guint           gnome_db_browser_get_type (void);
GtkWidget*      gnome_db_browser_new (Gda_Connection *cnc);

Gda_Connection* gnome_db_browser_get_connection (GnomeDbBrowser *brw);
void            gnome_db_browser_set_connection (GnomeDbBrowser *brw, Gda_Connection *cnc);

void            gnome_db_browser_clear (GnomeDbBrowser *brw);
void            gnome_db_browser_refresh (GnomeDbBrowser *brw);

END_GNOME_DECLS

#endif
