#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <signal.h>

#include "gda-postgres-types.h"
#include "gda-postgres-connection.h"
#include "gda-postgres-command.h"
#include "gda.h"

static void
g_log_2_file(const gchar*       log_domain,
	     GLogLevelFlags     log_level,
	     const gchar*       message,
	     gpointer           out_stream)
{
  FILE* out = (FILE*) out_stream;
  fprintf(out, "%s[0x%x]: %s\n", log_domain, log_level, message);
}

int
main(int argc, char* argv[])
{
  CORBA_ORB                 orb;
  CORBA_Environment*        ev;
  CORBA_Object              connection_factory_obj;
  CORBA_Object              name_service;
  gpointer                  servant;
  PortableServer_POA        root_poa;
  PortableServer_POAManager pm;
  CORBA_char*               objref;
  extern volatile int       wait_for_debugger;
  FILE*                     logstream;
  struct sigaction          sa;
  int                       output_fd;

  sa.sa_handler = SIG_IGN;
  sigaction(SIGPIPE, &sa, 0);
  
  logstream = fopen("/tmp/gda-postgres-srv.log", "a");
  g_log_set_handler("GDA ODBC", 0xffffffff, g_log_2_file, logstream);

#if 0
  while (wait_for_debugger)
    {
      ;
    }
#endif
  
  ev = g_new0(CORBA_Environment,1);

  CORBA_exception_init(ev);

  orb = gnome_CORBA_init("gda-postgres-srv", "0.1", &argc, argv, GNORBA_INIT_SERVER_FUNC, ev);
  Exception(ev);
  root_poa = (PortableServer_POA)CORBA_ORB_resolve_initial_references(orb, "RootPOA", ev);
  Exception(ev);
  
  connection_factory_obj = connection_factory__create(root_poa, &servant, ev);
  
  Exception(ev);
  objref                 = CORBA_ORB_object_to_string(orb, connection_factory_obj, ev);
  Exception(ev);
  name_service = gnome_name_service_get();
  if (!CORBA_Object_is_nil(name_service, ev))
    {
      goad_server_register(name_service, connection_factory_obj, "gda-postgres", "object", ev);
      printf("%s\n", objref); fflush(stdout);
    }
  output_fd = fileno(logstream);
  setvbuf(stderr, 0, _IOLBF, 0);
  setvbuf(stdout, 0, _IOLBF, 0);
  dup2(output_fd, fileno(stdout));
  dup2(output_fd, fileno(stderr));
  close(output_fd);
  pm = PortableServer_POA__get_the_POAManager(root_poa, ev);
  Exception(ev);
  PortableServer_POAManager_activate(pm, ev);
  Exception(ev);
  fprintf(logstream, "gda-postres (logstream) starting up\n");
  fprintf(stderr, "gda-postgres: (stderr) starting up\n");
  CORBA_ORB_run(orb, ev);
  return 0;
}


