#include <ctype.h>
#include <config.h>
#include <gnome.h>
#include "libgnorba/gnorba.h"

#include <gda-server.h>
#include <gda-connection.h>


#define MDI_GUI 0

static GtkWidget*    create_gda_config_window();
static GtkWidget*    browser;
static GtkWidget*    workarea;
static GtkCTreeNode* selected_node;
static GtkWidget*    status_bar;
static CORBA_ORB     orb;
static GtkWidget*    gda_srv_properties;

struct ctree_node_info
{
  void            (*open)(struct ctree_node_info*);
  void            (*select)(struct ctree_node_info*);
  /* for the open function */
  gchar*          provider;
  gchar*          dsn;
  Gda_Connection* cnc;
  /* for the select function */
  Gda_Server*     server;
};

gint
gda_connect_dialog(gchar** dsn_name, gchar** user_name, gchar** password)
{
  static GtkWidget* dialog = 0;
  static GtkWidget* entry_dsn;
  static GtkWidget* entry_user;
  static GtkWidget* entry_pwd;
  gint              clicked;
  GtkWidget*        table;
  
  GtkWidget*        vbox;
  
  GtkWidget*        label;
  
  
  if (!dialog)
    {
      dialog = gnome_dialog_new(_("GDA Login"),
				_("Login"),
				_("Cancel"),
				NULL);
      gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
      vbox = gtk_vbox_new(5, TRUE);
      table = gtk_table_new(2, 4, FALSE);
      
      /* DSN Entry */
      label = gtk_label_new(_("Data Source Name"));
      gtk_misc_set_alignment(GTK_MISC(label), 0.1, 0.5);
      entry_dsn = gtk_entry_new();
      gtk_entry_set_text(GTK_ENTRY(entry_dsn), dsn_name[0]);
      printf("entry_dsn_text = '%s'\n", gtk_entry_get_text(GTK_ENTRY(entry_dsn)));
      
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		       GTK_FILL, 0, 0, 0);
      gtk_table_attach(GTK_TABLE(table), entry_dsn, 1, 2, 0, 1,
		       GTK_FILL, 0, 0, 0);
      
      /* User name */
      label = gtk_label_new(_("Username"));
      gtk_misc_set_alignment(GTK_MISC(label), 0.1, 0.5);
      entry_user = gtk_entry_new();
      gtk_entry_set_text(GTK_ENTRY(entry_user), "mla");
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
		       GTK_FILL, 0, 0, 0);
      gtk_table_attach(GTK_TABLE(table), entry_user, 1, 2, 1, 2,
		       GTK_FILL, 0, 0, 0);
      printf("entry_dsn_text = '%s'\n", gtk_entry_get_text(GTK_ENTRY(entry_dsn)));
      
      /* Password */
      label = gtk_label_new(_("Password"));
      gtk_misc_set_alignment(GTK_MISC(label), 0.1, 0.5);
      entry_pwd = gtk_entry_new();
      gtk_entry_set_visibility(GTK_ENTRY(entry_pwd), 0);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
		       GTK_FILL, 0, 0, 0);
      gtk_table_attach(GTK_TABLE(table), entry_pwd, 1, 2, 2, 3,
		       GTK_FILL, 0, 0, 0);
      
      gtk_widget_show_all(table);
      
      printf("entry_dsn_text = '%s'\n", gtk_entry_get_text(GTK_ENTRY(entry_dsn)));
      gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), table, TRUE, TRUE, GNOME_PAD);
      gnome_dialog_close_hides ( GNOME_DIALOG(dialog), 1);
    }
  else
    {
      gtk_entry_set_text(GTK_ENTRY(entry_dsn), dsn_name[0]);
      gtk_entry_set_text(GTK_ENTRY(entry_user), "mla");
      gtk_entry_set_text(GTK_ENTRY(entry_pwd), "");
    }      
  clicked = gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
  *dsn_name  = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry_dsn)));
  *user_name = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry_user)));
  *password  = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry_pwd)));
  return clicked;
}
  
static void
make_connection(gchar* provider, gchar* dsn, char* user, gchar* passwd)
{
  Gda_Connection* cnc;
  
  gnome_appbar_push(GNOME_APPBAR(status_bar), _("Connecting"));
  while( gtk_events_pending() )
    gtk_main_iteration();
  cnc = gda_connection_new(orb);

  gda_connection_set_provider(cnc, provider);
  gda_connection_open(cnc, dsn, user, passwd);
  
  gnome_appbar_pop(GNOME_APPBAR(status_bar));
  while( gtk_events_pending() )
    gtk_main_iteration();
}

static void
open_connection(struct ctree_node_info* info)
{

  gchar*               user_name;
  gchar*               password;
  gint                 clicked;
  gchar*               user_dsn = g_strdup(info->dsn);
  
  printf("                    provider_name = '%s'\n", user_dsn);
  clicked = gda_connect_dialog(&user_dsn, &user_name, &password);
  if (clicked == 0)
    {
      make_connection(info->provider, user_dsn, user_name, password);
    }
  else
    {
      gnome_appbar_clear_stack(GNOME_APPBAR(status_bar));
      gnome_appbar_set_status(GNOME_APPBAR(status_bar),
			      _("Cancelled"));
    }
  g_free(user_dsn);
}

static void
open_odbc_manager(struct ctree_node_info* data)
{
  printf("Opening ODBC configurator\n");
}

static void
open_cmd(void)
{
  struct ctree_node_info* info;
  
  printf("open_cmd called\n");
  printf("selected_node = %p\n", selected_node);
  info = gtk_ctree_node_get_row_data(GTK_CTREE(browser), selected_node);
  info->open(info);
}

static void
quit_cmd(void)
{
  gtk_main_quit();
}

static void
about_cmd(void)
{
  ;
}

void
selected_row_callback(GtkWidget* widget, GtkCTreeNode* node, gint column)
{
  struct ctree_node_info* info;
  
  selected_node = node;
  fprintf(stderr,"selected_row_callback called\n");
  info = gtk_ctree_node_get_row_data(GTK_CTREE(widget), node);
  if (info && info->select)
    info->select(info);
}

gint
mdi_destroy(GtkWidget* widget, gpointer data1, gpointer data2)
{
  printf("mdi_destroy called\n");
  return 0;
}


gint
mdi_child_changed(GtkWidget* widget, gpointer data1, gpointer data2)
{
  printf("mdi_child_changed called\n");
  return 0;
}

gint
mdi_app_created(GtkWidget* widget, gpointer data1, gpointer data2)
{
  printf("mdi_app_created called\n");
  return 0;
}

GtkWidget*
create_gda_server_config()
{
  GtkWidget* table;
  GtkWidget* exe_server;
  GtkWidget* shlib_server;
  GtkWidget* entry;
  GtkWidget* label;
  GtkWidget* save;
  
  gda_srv_properties = gtk_frame_new(_("GDA Server Properties"));
  table = gtk_table_new(7,2, FALSE);
  gtk_table_set_col_spacings(GTK_TABLE(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 15);
  
  label = gtk_label_new(_("Type"));
  gtk_misc_set_alignment(GTK_MISC(label), 0.1, 1.0);
  exe_server = gtk_radio_button_new_with_label(NULL, _("Standalone Executable"));
  shlib_server = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(exe_server)),
						 _("Shared Library"));
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "exe_server", exe_server);
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "shlib_server",
		      shlib_server);
  
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 0, 1,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), exe_server,
		   1, 2, 0, 1,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), shlib_server,
		   1, 2, 1, 2,
		   GTK_FILL, 0, 0, 0);

  
  
  label = gtk_label_new(_("Repository ID"));
  entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry), "Repository ID");
  gtk_entry_set_editable(GTK_ENTRY(entry), 0);
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "repository ID", entry);
		      
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 2, 3,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 2, 3,
		   GTK_FILL, 0, 0, 0);




  label = gtk_label_new(_("Description"));
  entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry), "Description");
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "description", entry);
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 3, 4,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 3, 4,
		   GTK_FILL, 0, 0, 0);

  label = gtk_label_new(_("Location"));
  entry = gnome_file_entry_new("ServerLocationInfo",
			       _("GDA Server Location"));
  gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(entry))),
		     "Location");
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "location", gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(entry)));
  gtk_table_attach(GTK_TABLE(table), label,
		   0, 1, 4, 5,
		   GTK_FILL, 0, 0, 0);
  gtk_table_attach(GTK_TABLE(table), entry,
		   1, 2, 4, 5,
		   GTK_FILL, 0, 0, 0);
  save = gtk_button_new_with_label(_("Save"));
  gtk_table_attach(GTK_TABLE(table), save,
		   0, 2, 5, 6,
		   GTK_FILL, 0, 0, 0);
  gtk_object_set_data(GTK_OBJECT(gda_srv_properties), "save", save);
  gtk_container_add(GTK_CONTAINER(gda_srv_properties), table);
  return gda_srv_properties;
}
  

void
switchto_gda_property_page(struct ctree_node_info* info)
{
  GtkWidget* widget;
  gtk_notebook_set_page(GTK_NOTEBOOK(workarea),
			1);
  if (info->server->type == GOAD_SERVER_SHLIB)
    widget = gtk_object_get_data(GTK_OBJECT(gda_srv_properties), "shlib_server");
  else
    widget = gtk_object_get_data(GTK_OBJECT(gda_srv_properties), "exe_server");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), 1);

  widget = gtk_object_get_data(GTK_OBJECT(gda_srv_properties), "repository ID");
  gtk_entry_set_text(GTK_ENTRY(widget), info->server->repo_id);

  widget = gtk_object_get_data(GTK_OBJECT(gda_srv_properties), "description");
  gtk_entry_set_text(GTK_ENTRY(widget), info->server->comment);

  widget = gtk_object_get_data(GTK_OBJECT(gda_srv_properties), "location");
  gtk_entry_set_text(GTK_ENTRY(widget), info->server->location);
  
  
  
}

GtkWidget*
create_gda_servers()
{
  Gda_Connection* cnc;
  GtkWidget*      scrolledw;
  GtkCTreeNode*   root_node;
  GtkCTreeNode*   server_node;
  GtkCTreeNode*   data_source_node;
  GtkWidget*      gda_servers_pixmap;
  gchar*          texts[1];
  GList*          gda_servers;
  GList*          current_server;
  GList*          data_sources;
  GList*          current_data_source;
  
  gda_servers_pixmap = gnome_pixmap_new_from_file("gda-servers.png");

  texts[0] = "C0";
  browser     = gtk_ctree_new(1, 0);

  scrolledw = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledw),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  texts[0] = _("GDA Servers");
  root_node = gtk_ctree_insert_node(GTK_CTREE(browser),
				    NULL, NULL,
				    texts, 5,
				    GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
				    GNOME_PIXMAP(gda_servers_pixmap)->mask,
				    GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
				    GNOME_PIXMAP(gda_servers_pixmap)->mask,
				    FALSE, FALSE);
  
  gda_servers = gda_connection_list_providers();
  current_server = gda_servers;
  server_node = 0;
  while (current_server)
    {
      struct ctree_node_info* info;
      Gda_Server* server = current_server->data;
      
      texts[0] = server->name;
      server_node = gtk_ctree_insert_node(GTK_CTREE(browser),
					  root_node, server_node,
					  texts, 5,
					  GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
					  GNOME_PIXMAP(gda_servers_pixmap)->mask,
					  GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
					  GNOME_PIXMAP(gda_servers_pixmap)->mask,
					  FALSE, FALSE);
      info = g_new0(struct ctree_node_info, 1);
      info->open   = open_odbc_manager;
      info->select = switchto_gda_property_page;
      info->provider = g_strdup(texts[0]);
      info->server = current_server->data;
      
      gtk_ctree_node_set_row_data(GTK_CTREE(browser),
				  server_node,
				  info);
      cnc = gda_connection_new(orb);
      gda_connection_set_provider(cnc, server->name);
      data_sources = gda_connection_list_datasources(cnc);
      gda_connection_free(cnc);
      current_data_source = data_sources;
      data_source_node = 0;

      while(current_data_source)
	{
	  struct ctree_node_info* info;
	  
	  texts[0] = current_data_source->data;
	  data_source_node = gtk_ctree_insert_node(GTK_CTREE(browser),
						   server_node, data_source_node,
						   texts, 5,
						   GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
						   GNOME_PIXMAP(gda_servers_pixmap)->mask,
						   GNOME_PIXMAP(gda_servers_pixmap)->pixmap,
						   GNOME_PIXMAP(gda_servers_pixmap)->mask,
						   FALSE, FALSE);
	  info = g_new0(struct ctree_node_info, 1);
	  info->open = open_connection;
	  info->provider = g_strdup(server->name);
	  info->dsn = g_strdup(texts[0]);
	  info->server = current_server->data;
	  gtk_ctree_node_set_row_data(GTK_CTREE(browser),
				      data_source_node,
				      info);
	  
	  current_data_source = g_list_next(current_data_source);
	}
      current_server = g_list_next(current_server);
    }
  g_list_free(gda_servers);

  
  
  gtk_widget_set_usize(scrolledw, 300, 200);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledw),
					browser);
  gtk_object_set_data(GTK_OBJECT(scrolledw), "ctree", browser);
  gtk_object_set_data(GTK_OBJECT(browser), "root_node", root_node);

  
  gtk_signal_connect(GTK_OBJECT(browser), "tree_select_row",
		     GTK_SIGNAL_FUNC(selected_row_callback), NULL); 
  gtk_clist_columns_autosize(GTK_CLIST(browser));
  return scrolledw;
}



static GnomeUIInfo gda_manager_menu_file[] = {
  GNOMEUIINFO_MENU_OPEN_ITEM(open_cmd, NULL), 
  GNOMEUIINFO_MENU_EXIT_ITEM(quit_cmd, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu_help [] = {
        GNOMEUIINFO_MENU_ABOUT_ITEM(about_cmd, NULL), 
	GNOMEUIINFO_END
};

static GnomeUIInfo gda_manager_menu[] = {
  GNOMEUIINFO_MENU_FILE_TREE(gda_manager_menu_file),
  GNOMEUIINFO_MENU_HELP_TREE(gda_manager_menu_help),
  GNOMEUIINFO_END
};



int
main(int argc, char* argv[])
{
  CORBA_Environment ev;
  GtkWidget*        app;
  GtkWidget*        win;
  GnomeDockItem*    item;
  GtkWidget*        toolbar;
  GtkWidget*        paned;
  
  
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  CORBA_exception_init(&ev);
  
  orb = gnome_CORBA_init_with_popt_table("gda", VERSION,
					 &argc, argv,
					 NULL, 0, NULL, 0, &ev);

#if !MDI_GUI
  app = gnome_app_new("gda", _("GDA Administrator"));
  gtk_signal_connect(GTK_OBJECT(app), "delete_event",
		     GTK_SIGNAL_FUNC(quit_cmd), NULL);
#else
  app = gnome_mdi_new("gda", _("GDA Administrator"));
  gtk_signal_connect(GTK_OBJECT(app), "destroy", 
		     GTK_SIGNAL_FUNC(mdi_destroy), NULL);
  gtk_signal_connect(GTK_OBJECT(app), "child_changed",
		     GTK_SIGNAL_FUNC(mdi_child_changed), NULL);
  gtk_signal_connect(GTK_OBJECT(app), "app_created",
		     GTK_SIGNAL_FUNC(mdi_app_created), NULL);
  gnome_mdi_set_child_list_path(GNOME_MDI(app),
				"datasources/<Seperator>");
  
#endif  

  win = create_gda_servers();
  workarea = gtk_notebook_new();
  gtk_notebook_set_show_border(GTK_NOTEBOOK(workarea), 0);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(workarea), 0);
  gtk_container_set_border_width(GTK_CONTAINER(workarea), 0);
  {
    GtkWidget* gda_prop_page = create_gda_server_config();
    
    gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			     gtk_label_new("WORKAREA"),
			     gtk_label_new("WORKAREA LABEL")); 
   gtk_notebook_append_page(GTK_NOTEBOOK(workarea),
			     gda_prop_page,
			     gtk_label_new("GDA PROP PAGE LABEL"));
  }

  paned = gtk_hpaned_new();
  gtk_paned_pack1(GTK_PANED(paned),
		  win,
		  1, 1);

  gtk_paned_pack2(GTK_PANED(paned),
		  workarea,
		  1, 1);
  

#if !MDI_GUI
  gnome_app_set_contents(GNOME_APP(app), paned);
  gnome_app_create_menus_with_data(GNOME_APP(app), gda_manager_menu,  win);
#else
  gnome_mdi_set_menubar_template(GNOME_MDI(app), gda_manager_menu);
  gnome_mdi_set_toolbar_template(GNOME_MDI(app), 0);
#endif				 

#if !MDI_GUI
  item = gnome_app_get_dock_item_by_name (GNOME_APP (app), GNOME_APP_TOOLBAR_NAME);
  
  if (item)
    {
      toolbar = gnome_dock_item_get_child (item);
      gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
    }
#endif      
  status_bar = gnome_appbar_new(TRUE, TRUE, FALSE);

#if !MDI_GUI
  gnome_app_set_statusbar(GNOME_APP(app), status_bar);
  gtk_widget_show_all(app);
#else
  gtk_widget_show_all(win);
  gtk_widget_show_all(workarea);
  gnome_mdi_register(GNOME_MDI(app), win);
  gnome_mdi_register(GNOME_MDI(app), workarea);
  gnome_mdi_open_toplevel(GNOME_MDI(app));

#endif  
  gtk_main();
  exit(0);
}
