/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include "gda-server.h"

/**
 * gda_server_new:
 *
 * Allocates memory for a new Gda_Server object and initializes struct 
 * members.
 *
 * Returns: a pointer to a new Gda_Server object.
 */

Gda_Server*
gda_server_new(void)
{
  Gda_Server* retval;

  retval = g_new0(Gda_Server, 1);
  return retval;
}

/**
 * gda_server_free:
 *
 * @server: the server to de-allocate.
 *
 * Frees the memory allocated with gda_server_new() and the memory
 * allocated to struct members.
 */

void
gda_server_free(Gda_Server* server)
{
  if (server->name)
    g_free(server->name);

  if (server->comment)
    g_free(server->comment);

  if (server->location)
    g_free(server->location);

  g_free(server);
}

	   
