/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"

/* function prototypes */
static void open_file_cb (GtkWidget *, gpointer );
static void save_file_cb (GtkWidget *, gpointer );

/* global variables */
extern gint l_openconns;
static gboolean l_isopen = FALSE;
static GtkWidget *l_tab = NULL;
static GtkWidget *l_toolbar = NULL;
static GtkWidget *l_editbox = NULL;
static gchar *l_filename = NULL;
static GnomeUIInfo edittoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("Create a new empty file"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing file"),
    open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save current file"),
    save_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save As..."), N_("Save file with another name"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE_AS, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Print"), N_("Print current file"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_PRINT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Cut"), N_("Cut selected text"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CUT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy selected text to clipboard"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_COPY, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste clipboard's contents"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_PASTE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    editor_close_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* private functions */
static void
open_file_cb (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gchar *tmp = ui_get_file_name("Open File");
      if (tmp != NULL)
        {
          ui_load_file_in_text(GTK_TEXT(l_editbox), tmp);
          if (l_filename != NULL) g_free((gpointer) l_filename);
          l_filename = tmp;
        }
    }
}

static void
save_file_cb (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      if (l_filename == NULL)
        {
          l_filename = ui_get_file_name("Save File");
          if (l_filename == NULL)
            return;
        }
      /* save the file */
      ui_save_text_to_file(GTK_TEXT(l_editbox), l_filename);
    }
}

/* close the editor window */
void
editor_close_window (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gint current = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
					               l_tab);
      /* free list items memory (see log_open_window() */
      gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()), current);
      l_openconns--;
      l_isopen = FALSE;
      /* free all used memory */
      if (l_filename != NULL)
        {
          g_free((gpointer) l_filename);
          l_filename = NULL;
        }
    }
}

/* open the editor window */
void
editor_open_window (GtkWidget *w, gpointer data)
{
  /* check if the window is already open */
  if (!l_isopen)
    {
      l_tab = gtk_table_new(4, 1, FALSE);
      gtk_widget_show(l_tab);
      gtk_notebook_append_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab,
                               gtk_label_new("Editor"));
      l_toolbar = ui_new_toolbar_in_table(l_tab, 0, 0, 1, 1);
      gnome_app_fill_toolbar(GTK_TOOLBAR(l_toolbar), edittoolbar, NULL);
      /* create editor window */
      l_editbox = ui_new_text_in_table(l_tab, 0, 1, 1, 4);
      l_isopen = TRUE;
      l_openconns++;
    }
  /* open given file, if so. If not given, just activate the editor */
  if (data != NULL)
    {
      ui_load_file_in_text(GTK_TEXT(l_editbox), (gchar *) data);
      l_filename = g_strdup((gchar *) data);
    }
  else l_filename = NULL;
  ui_set_notebook_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab);
}
