/** miscellaneous functions
       
    Copyright (C) 1995 by Ke Jin <kejin@empress.com> 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**/

#include	<iodbc-config.h>
#include        <odbc_inifile.h>

#include	<isql.h>
#include	<isqlext.h>

#include	<stdio.h>
#include        <string.h>
#include        <limits.h>

static int	
upper_strneq( 
	char*	s1,
	char*	s2,
	int	n )
{
	int	i;
	char	c1, c2;

	for(i=1;i<n;i++)
	{
		c1 = s1[i];
		c2 = s2[i];

		if( c1 >= 'a' && c1 <= 'z' )
		{
			c1 += ('A' - 'a');
		}
		else if( c1 == '\n' )
		{
			c1 = '\0';
		}

		if( c2 >= 'a' && c2 <= 'z' )
		{
			c2 += ('A' - 'a');
		}
		else if( c2 == '\n' )
		{
			c2 = '\0';
		}

		if( (c1 - c2) || !c1 || !c2 )
		{
			break;
		}
	}

	return (int)!(c1 - c2);
}

static char*			/* return new position in input str */
readtoken( 
	char* 	istr, 		/* old position in input buf */
	char* 	obuf )		/* token string ( if "\0", then finished ) */
{
	for(; *istr && *istr != '\n' ; istr ++ )
	{
		char c, nx;

		c = *(istr);

		if( c == ' ' || c == '\t' )
		{
			continue;
		}

		nx = *(istr + 1);

		*obuf = c;
		obuf ++;

		if( c == ';' || c == '=' )
		{
			istr ++;
			break;
		}

		if( nx == ' ' || nx == '\t' || nx == ';' || nx == '=' )
		{
			istr ++;
			break;
		}
	}

	*obuf = '\0'; 

	return istr;
}

#if	!defined(WINDOWS) && !defined(WIN32) && !defined(OS2)
# include	<pwd.h>
# define	UNIX_PWD
#endif

static char*
getinitfile(char* buf, int size)	
{
	int	i, j;
	char*	ptr;

	j = STRLEN("/odbc.ini") + 1;

	if( size < j )
	{
		return NULL;
	}

#if	!defined(UNIX_PWD)
	
	i = GetWindowsDirectory((LPSTR)buf, size );

	if( i == 0 || i > size - j )
	{
		return NULL;
	}

	sprintf( buf + i, "/odbc.ini");

	return buf;
#else
	ptr = (char*)getpwuid(getuid());	

	if( ptr == NULL )
	{
		return NULL;
	}

	ptr = ((struct passwd*)ptr)->pw_dir;

	if( ptr == NULL || *ptr == '\0' )
	{
		ptr = "/home";
	}

	if( size < STRLEN(ptr) + j )
	{
		return NULL;
	}

	sprintf( buf, "%s%s", ptr, "/.odbc.ini");
	/* i.e. searching ~/.odbc.ini */ 
#endif

	return buf;
}



int
_iodbcdm_get_datasources(char* data_source,
			 char* description,
			 int   first)
{
  FILE*	file;
  char	pathbuf[1024];
  char  buf[1024];
  char*	path;
  static unsigned long location;
  static int           in_data_source_section = 0;
#if 1
  static GList*        all_sections;
  ODBC_ini_section*    ds_section;
  ODBC_ini_section*    the_section;
  ODBC_ini_value_pair* entry;
  static GList*        the_ds_section_entry;
  GString*             ini_description;
  
#endif    
  path = getinitfile(pathbuf, sizeof(pathbuf));

  description[0] = '\0';
  data_source[0] = '\0';
    
  if (path == 0)
    return 0;


  file = fopen(path, "r");
  
  if (!file)
    return 0;

#if 1
  if (!first && !the_ds_section_entry)
    return 0;

  if (first)
    {
      all_sections = odbc_ini_parse(file, path);
      if (!all_sections)
	{
	  fclose(file);
	  return -1;
	}
      ds_section   = odbc_ini_find_section(all_sections, "ODBC Data Sources");
      the_ds_section_entry = ds_section->value_pairs;
    }
  else
    the_ds_section_entry = g_list_next(the_ds_section_entry);
  if (!the_ds_section_entry)
    return 0;
  entry = (ODBC_ini_value_pair*)the_ds_section_entry->data;
  strcpy(data_source, entry->name->str);
  
  the_section = odbc_ini_find_section(all_sections, data_source);
  if (!the_section)
    {
      return 1;
    }
  ini_description = odbc_ini_find_value(the_section, "Description");
  if (ini_description)
    strcpy(description, ini_description->str);
  return 1;
#else  
  
  if (!first)
    fseek(file, location, 0);

  for (;;)
    {
      char* str;

      str = fgets(buf, sizeof(buf), file);
      if (!str)
	return 0;
      
      if (*str == '[' )
	{
	  if (upper_strneq(str,"[ODBC data sources]", strlen("[ODBC data sources]")))
	    {
	      in_data_source_section = 1;
	      str = fgets(buf, sizeof(buf), file);
	      if (!str)
		return 0;
	    }
	  else
	    {
	      in_data_source_section = 0;
	    }
	}
      if (in_data_source_section)
	{
	  char* ptr;
	  str = readtoken(str, data_source);
	  str = readtoken(str, description);
	  str = readtoken(str, description);

	  if (!*data_source)
	    continue;
	  
	  ptr = strchr(description, ',');
	  if (ptr)
	    {
	      ptr++;
	      while (*ptr && isblank(*ptr))
		ptr++;
	      if (*ptr)
		memcpy(description, ptr, strlen(ptr)+1);
	    }
	  else
	    {
	      description[0] = '\0';
	    }
	  location = ftell(file);
	  fclose(file);
	  return 1;
	}
    }
  fclose(file);
  return -1;
#endif
}

	  
	      

char*	_iodbcdm_getkeyvalbydsn(
		char* 	dsn,		
		int   	dsnlen,	
		char*	keywd, 
		char*	value, 
		int	size )
/* read odbc init file to resolve the value of specified
 * key from named or defaulted dsn section 
 */
{
	char	buf[1024];
	char	dsntk[SQL_MAX_DSN_LENGTH + 3] = {'\0'  };
	char	token[1024];	/* large enough */
	FILE*	file;
	char	pathbuf[1024];
	char*	path;
	static GList*  all_sections = 0;
	ODBC_ini_section* the_section = 0;
	ODBC_ini_section* dsn_section = 0;
	GString* val = 0;
	
#define DSN_NOMATCH	0	
#define DSN_NAMED	1
#define DSN_DEFAULT	2

	int	dsnid = DSN_NOMATCH;
	int	defaultdsn = DSN_NOMATCH;

	if( dsn == NULL || *dsn == 0 )
	{
		dsn = "default";
		dsnlen = STRLEN(dsn);
	}

	if( dsnlen == SQL_NTS )
	{
		dsnlen = STRLEN(dsn);
	}

	if( dsnlen <= 0 || keywd == NULL || buf == 0 || size <= 0 )
	{
		return NULL;
	}

	if( dsnlen > sizeof(dsntk) - 2  )
	{
		return NULL;
	}

	value[0] = '\0';

	STRNCPY( dsntk, dsn, dsnlen );
	STRCAT( dsntk, "" );

	if (!all_sections)
	  {
	    
	    path = getinitfile(pathbuf, sizeof(pathbuf));
	    
	    if( path == NULL )
	      {
		return NULL;
	      }
	    
	    file = (FILE*)fopen(path, "r");
	    
	    if( file == NULL )
	      {
		return NULL;
	      }
	    
	    all_sections = odbc_ini_parse(file, path);
	    fclose(file);
	    if (!all_sections)
	      {
		goto bad;
	      }
	  }
	dsn_section  = odbc_ini_find_section(all_sections, "ODBC Data Sources");
	if (!dsn_section)
	{
		goto bad;
	}
	val = odbc_ini_find_value(dsn_section, dsntk);
	if (!val)
		goto bad;
	the_section = odbc_ini_find_section(all_sections, val->str);
	if (!the_section)
		goto bad;
	val = odbc_ini_find_value(the_section, keywd);
	
 bad:
	if (val)
	  {
		  strncpy(value, val->str, size);
		  return value;
	  }
	else
		return 0;
	
#if 0	
	for(;;)
	{
		char*	str;

		str = fgets(buf, sizeof(buf), file);

		if( str == NULL )
		{
			break;
		}

		if( *str == '[' )
		{
			if( upper_strneq(str, "[default]", STRLEN("[default]")) )
			{
				/* we only read first dsn default dsn
				 * section (as well as named dsn).
				 */
				if( defaultdsn == DSN_NOMATCH )
				{
					dsnid = DSN_DEFAULT;
					defaultdsn = DSN_DEFAULT;
				}
				else
				{
					dsnid = DSN_NOMATCH;
				}

				continue;
			}
			else if( upper_strneq( str, dsntk, dsnlen ) )
			{
				dsnid = DSN_NAMED;
			}
			else
			{
				dsnid = DSN_NOMATCH;
			}

			continue;
		}
		else if( dsnid == DSN_NOMATCH )
		{
			continue;
		}

		str = readtoken(str, token);

		if( upper_strneq( keywd, token, STRLEN(keywd)) )
		{
			str = readtoken(str, token);

			if( ! STREQ( token, "=") )
			/* something other than = */
			{
				continue;
			}

			str = readtoken(str, token);

			if( STRLEN(token) > size - 1)
			{
				break;
			}

			STRNCPY(value, token, size);
			/* copy the value(i.e. next token) to buf */

			if( dsnid != DSN_DEFAULT )
			{
				break;
			}
		}
	}

	fclose(file);
	return (*value)? value:NULL;
#endif
}

char*	_iodbcdm_getkeyvalinstr( 
		char*	cnstr, 
		int 	cnlen, 
		char* 	keywd,
		char*	value,
		int	size )
{
	char	token[1024] = { '\0' };
	int	flag = 0;

	if( cnstr == NULL || value == NULL
	 || keywd == NULL || size < 1 )
	{
		return NULL;
	}

	if( cnlen == SQL_NTS )
	{
		cnlen = STRLEN (cnstr);
	}

	if( cnlen <= 0 )
	{
		return NULL;
	}

	for(;;)
	{
		cnstr = readtoken(cnstr, token);

		if( *token == '\0' )
		{
			break;
		}

		if( STREQ( token, ";" ) )
		{
			flag = 0; 
			continue;
		}

		switch(flag)
		{
			case 0:
				if( upper_strneq(token, keywd, strlen(keywd)) )
				{
					flag = 1;
				}
				break;

			case 1:
				if( STREQ( token, "=" ) )
				{
					flag = 2;
				}
				break;

			case 2:
				if( size < strlen(token) + 1 )
				{
					return NULL;
				}

				STRNCPY( value, token, size );

				return value;

			default:
				break;
		}
	}

	return  NULL;
}

DWORD
GetPrivateProfileString(char *theSection,	// section name
	char *theKey,		// search key name
	char *theDefault,	// default value if not found
	char *theReturnBuffer,	// return value stored here
	size_t theReturnBufferLength,	// byte length of return buffer
	char *theIniFileName)		// pathname of ini file to search
{
	char buf[PATH_MAX+1];
	char* ptr = 0;
	FILE* aFile = 0;
	size_t aLength;
	char aLine[2048];
	char *aValue;
	char *aString;
	size_t aLineLength;
	size_t aReturnLength = 0;

	BOOL aSectionFound = FALSE;
	BOOL aKeyFound = FALSE;
	int j = 0;
	
	j = strlen(theIniFileName) + 1;
	ptr = (char*)getpwuid(getuid());	// get user info

	if( ptr == NULL)
	{
		if( PATH_MAX < j )
			theIniFileName[PATH_MAX] = '\0';

		sprintf(buf,"%s",theIniFileName);
	}
	ptr = ((struct passwd*)ptr)->pw_dir;	// get user home dir
	if( ptr == NULL || *ptr == '\0' )
		ptr = "/home";

	/* This doesn't make it so we find an ini file but allows normal
	 * processing to continue further on down. The likelihood is that
	 * the file won't be found and thus the default value will be
	 * returned.
	*/
	if( PATH_MAX < strlen(ptr) + j )
	{
		if( PATH_MAX < strlen(ptr) )
			ptr[PATH_MAX] = '\0';
		else
			theIniFileName[PATH_MAX-strlen(ptr)] = '\0';
	}

	sprintf( buf, "%s/%s",ptr,theIniFileName );

	  /* This code makes it so that a file in the users home dir
	   * overrides a the "default" file as passed in
	  */
	aFile = (FILE*)(buf ? fopen(buf, "r") : NULL);
	if(!aFile) {
		sprintf(buf,"%s",theIniFileName);
		aFile = (FILE*)(buf ? fopen(buf, "r") : NULL);
	}

		
	aLength = (theDefault == NULL) ? 0 : strlen(theDefault);

	if(theReturnBufferLength == 0 || theReturnBuffer == NULL)
	{
		if(aFile)
		{
			fclose(aFile);
		}
		return 0;
	}

	if(aFile == NULL)
	{
		// no ini file specified, return the default

		++aLength;	// room for NULL char
		aLength = theReturnBufferLength < aLength ?
			theReturnBufferLength : aLength;
		strncpy(theReturnBuffer, theDefault, aLength);
		theReturnBuffer[aLength - 1] = '\0';
		return aLength - 1;
	}


	while(fgets(aLine, sizeof(aLine), aFile) != NULL)
	{
		aLineLength = strlen(aLine);
		// strip final '\n'
		if(aLineLength > 0 && aLine[aLineLength - 1] == '\n')
		{
			aLine[aLineLength - 1] = '\0';
		}
		switch(*aLine)
		{
			case ' ': // blank line
			case ';': // comment line
				continue;
			break;
			
			case '[':	// section marker

				if( (aString = strchr(aLine, ']')) )
				{
					*aString = '\0';

					// accept as matched if NULL key or exact match

					if(!theSection || !strcmp(aLine + 1, theSection))
					{
						aSectionFound = TRUE;
					}
				}

			break;

			default:

				// try to match value keys if in proper section

				if(aSectionFound)
				{
					// try to match requested key
	
					if( (aString = aValue = strchr(aLine, '=')) )
					{
						*aValue = '\0';
						++aValue;

						// strip leading blanks in value field

						while(*aValue == ' ' && aValue < aLine + sizeof(aLine))
						{
							*aValue++ = '\0';
						}
						if(aValue >= aLine + sizeof(aLine))
						{
							aValue = "";
						}
					}
					else
					{
						aValue = "";
					}

					// strip trailing blanks from key

					if(aString)
					{
						while(--aString >= aLine && *aString == ' ')
						{
							*aString = '\0';
						}
					}

					// see if key is matched

					if(theKey == NULL || !strcmp(theKey, aLine))
					{
						// matched -- first, terminate value part

						aKeyFound = TRUE;
						aLength = strlen(aValue);

						// remove trailing blanks from aValue if any

						aString = aValue + aLength - 1;
						
						while(--aString > aValue && *aString == ' ')
						{
							*aString = '\0';
							--aLength;
						}

						// unquote value if quoted

						if(aLength >= 2 && aValue[0] == '"' &&
							aValue[aLength - 1] == '"')
						{
							// string quoted with double quotes

							aValue[aLength - 1] = '\0';
							++aValue;
							aLength -= 2;
						}
						else
						{
							// single quotes allowed also...

							if(aLength >= 2 && aValue[0] == '\'' &&
								aValue[aLength - 1] == '\'')
							{
								aValue[aLength - 1] = '\0';
								++aValue;
								aLength -= 2;
							}
						}

						// compute maximum length copyable

						aLineLength = (aLength <
							theReturnBufferLength - aReturnLength) ? aLength :
							theReturnBufferLength - aReturnLength;

						// do the copy to return buffer

						if(aLineLength)
						{
							strncpy(&theReturnBuffer[aReturnLength],
								aValue, aLineLength);
							aReturnLength += aLineLength;
							if(aReturnLength < theReturnBufferLength)
							{
								theReturnBuffer[aReturnLength] = '\0';
								++aReturnLength;
							}
						}
						if(aFile)
						{
							fclose(aFile);
							aFile = NULL;
						}

						return aReturnLength > 0 ? aReturnLength - 1 : 0;
					}
				}

			break;
		}
	}

	if(aFile)
	{
		fclose(aFile);
	}

	if(!aKeyFound) {	// key wasn't found return default
		++aLength;	// room for NULL char
		aLength = theReturnBufferLength < aLength ?
			theReturnBufferLength : aLength;
		strncpy(theReturnBuffer, theDefault, aLength);
		theReturnBuffer[aLength - 1] = '\0';
		aReturnLength = aLength - 1;
	}
	return aReturnLength > 0 ? aReturnLength - 1 : 0;
}
