/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_field_h__
#define __gda_field_h__ 1

#include <gda.h>

#if 0
typedef struct _Gda_Field
{
  glong         actual_size;
  glong         defined_size;
  gchar*        name;
  glong         scale;
  glong         precission;
  GDA_ValueType gdaType;
  glong         ctype;
  glong         nativeType;
  
  GDA_Value*    real_value;
  GDA_Value*    shadow_value;
  GDA_Value*    oroginal_value;
  gint          malloced;
  
}Gda_Field;
#endif

#define GDA_FIELD_ISNULL(f)         ((f)->realValue._d)
#define GDA_FIELD_TYPECODE(f)       ((f)->realValue._u._d)
#define GDA_FIELD_TINYINT(f)        ((f)->realValue._u.v._u.c)
#define GDA_FIELD_TYPECHAR(f)       ((f)->realValue._u.v._u.c1)
#define GDA_FIELD_BIGINT(f)         ((f)->realValue._u.v._u.ll)
#define GDA_FIELD_BSTR(f)           ((f)->realValue._u.v._u.s)
#define GDA_FIELD_BINARY(f)         ((f)->realValue._u.v._u.so._buffer)
#define GDA_FIELD_BOOLEAN(f)        ((f)->realValue._u.v._u.b)
#define GDA_FIELD_DATE(f)           ((f)->realValue._u.v._u.d)
#define GDA_FIELD_DBDATE(f)         ((f)->realValue._u.v._u.dbd)
#define GDA_FIELD_DBTIME(f)         ((f)->realValue._u.v._u.dbt)
#define GDA_FIELD_TIMESTAMP(f)      ((f)->realValue._u.v._u.dbtstamp)
#define GDA_FIELD_DEC(f)            ((f)->realValue._u.v._u.dec)
#define GDA_FIELD_DOUBLE(f)         ((f)->realValue._u.v._u.dp)
#define GDA_FIELD_INTEGER(f)        ((f)->realValue._u.v._u.i)
#define GDA_FIELD_VARBIN(f)         ((f)->realValue._u.v._u.lvb._buffer)
#define GDA_FIELD_FIXBIN(f)         ((f)->realValue._u.v._u.fb._buffer)
#define GDA_FIELD_LONGVARCHAR(f)    ((f)->realValue._u.v._u.lvc)
#define GDA_FIELD_SINGLE(f)         ((f)->realValue._u.v._u.f)
#define GDA_FIELD_SMALLINT(f)       ((f)->realValue._u.v._u.si)
#define GDA_FIELD_UBINGINT(f)       ((f)->realValue._u.v._u.ull)
#define GDA_FIELD_USMALLINT(f)      ((f)->realValue._u.v._u.us)



gchar*      gda_fieldtype_2_string   (gchar* bfr, gint length, GDA_Field* f);
gchar*      gda_stringify_value      (gchar* bfr, gint length, GDA_Field* f);


#endif
