/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"

/* global variables */
extern GtkWidget *wWorkArea;
gchar *glb_list_item_data_key = "list_item_data_key";

void
ui_fill_list (GtkList *wlist, GList *mlist)
{
  GList *node;
  /* check parameters */
  g_return_if_fail(wlist != NULL && mlist != NULL);
  /* clear the list and fill it */
  gtk_list_clear_items(wlist, 0, -1);
  for (node = g_list_first(mlist); node != NULL; node = g_list_next(node))
    {
      GtkWidget *w = gtk_list_item_new_with_label(node->data);
      gtk_container_add(GTK_CONTAINER(wlist), w);
      gtk_widget_show(w);
      /* associate label with list item */
      gtk_object_set_data(GTK_OBJECT(w), glb_list_item_data_key,
                          (gchar *) node->data);
    }
}

/* open file selection dialog and return selected file */
static void
filesel_button_clicked (GtkWidget *w, glong *selected)
{
  *selected = (glong) gtk_object_get_data(GTK_OBJECT(w), "button");
}

gchar *
ui_get_file_name (gchar *title)
{
  GtkWidget *filesel;
  glong *selected;
  gchar *res = NULL;
  /* initialize variables */
  selected = (glong *) g_malloc(sizeof(glong));
  *selected = 0;
  /* create dialog */
  filesel = gtk_file_selection_new(title);
  gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
		      "button", (gpointer) 1);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(filesel_button_clicked),
		     (gpointer) selected);
  gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
		      "button", (gpointer) 2);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
		     "clicked", GTK_SIGNAL_FUNC(filesel_button_clicked),
		     (gpointer) selected);
  gtk_widget_show(filesel);
  gtk_file_selection_show_fileop_buttons(GTK_FILE_SELECTION(filesel));
  /* wait for selection from user */
  while (!*selected)
    gtk_main_iteration_do(TRUE);
  if (*selected == 1) /* Ok-button */
    res = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));
  else res = NULL;
  /* free memory before exiting */
  gtk_widget_destroy(filesel);
  g_free((gpointer) selected);
  return (res);
}

GtkWidget *
ui_get_work_area (void)
{
  return (wWorkArea);
}

/* load a file into a text widget */
void
ui_load_file_in_text (GtkText *text, gchar *filename)
{
  FILE *file;
  /* check parameters */
  g_return_if_fail(text != NULL);
  g_return_if_fail(filename != NULL);
  /* open file */
  if ((file = fopen(filename, "r")))
    {
      gtk_editable_delete_text(GTK_EDITABLE(text), 0,
                               gtk_text_get_length(text));
      gtk_text_freeze(text);
      while (!feof(file))
	{
	  gchar buffer[1025];
	  memset(buffer, 0, sizeof(buffer));
	  fread(buffer, sizeof(buffer) - 1, 1, file);
	  if (ferror(file))
	    {
	      ui_show_error("Error reading file %s", filename);
	      break;
	    }
	  gtk_text_insert(text, NULL, NULL, NULL, buffer, strlen(buffer));
	}
      gtk_text_thaw(text);
      fclose(file);
    }
  else ui_show_error("Error opening file %s", filename);
}

/* create a GtkLabel widget and attach it to a table */
GtkWidget *
ui_new_label_in_table (GtkWidget *table, gchar *text, gint x1, gint y1,
                       gint x2, gint y2)
{
  GtkWidget *label;
  /* check pointers */
  g_return_val_if_fail(table != NULL, NULL);
  label = gtk_label_new(text);
  gtk_table_attach(GTK_TABLE(table), label, x1, x2, y1, y2, 
                   GTK_SHRINK | GTK_FILL,
                   GTK_SHRINK | GTK_FILL,
                   3, 3);
  gtk_widget_show(label);
}

GtkWidget *
ui_new_combo_in_table (GtkWidget *table, gint x1, gint y1, gint x2, gint y2)
{
  GtkWidget *combo;
  /* check parameters */
  g_return_val_if_fail(table != NULL, NULL);
  combo = gtk_combo_new();
  gtk_table_attach(GTK_TABLE(table), combo, x1, x2, y1, y2,
		   GTK_SHRINK | GTK_FILL,
		   GTK_SHRINK | GTK_FILL,
		   3, 3);
  gtk_widget_show(combo);
  return (combo);
}
 
GtkWidget *
ui_new_entry_in_table (GtkWidget *table, gchar *name, gchar *text, gint x1, gint y1,
                      gint x2, gint y2)
{
  GtkWidget *entry;
  /* check pointers */
  g_return_val_if_fail(table != NULL, NULL);
  entry = gtk_entry_new();
  gtk_widget_set_name(entry, name);
  if (text != NULL)
    gtk_entry_set_text(GTK_ENTRY(entry), text);
  gtk_table_attach(GTK_TABLE(table), entry, x1, x2, y1, y2, 
                   GTK_SHRINK | GTK_FILL,
                   GTK_SHRINK | GTK_FILL,
                   3, 3);
  gtk_widget_show(entry);
  return (entry);
}         

GtkWidget *
ui_new_text_in_table (GtkWidget *table, gint x1, gint y1, gint x2, gint y2)
{
  GtkWidget *text, *scroll_bar, *box;
  /* check parameters */
  g_return_val_if_fail(table != NULL, NULL);
  /* create vertical box */
  box = gtk_hbox_new(FALSE, 3);
  gtk_table_attach(GTK_TABLE(table), box, x1, x2, y1, y2,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_SHRINK,
                   3, 3);
  /* create text widget */
  text = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(text), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
  gtk_widget_set_sensitive(text, TRUE);
  gtk_box_pack_start(GTK_BOX(box), text, TRUE, TRUE, 0);
  gtk_widget_show(text);
  /* create scroll bar */
  scroll_bar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
  gtk_box_pack_start(GTK_BOX(box), scroll_bar, FALSE, FALSE, 0);
  gtk_widget_show(scroll_bar);
  gtk_widget_show(box);
  return (text);
}

GtkWidget *
ui_new_toolbar_in_table (GtkWidget *table, gint x1, gint y1, gint x2, gint y2)
{
  GtkWidget *toolbar;
  g_return_val_if_fail(table != NULL, NULL);
  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_table_attach(GTK_TABLE(table), toolbar, x1, x2, y1, y2,
                   GTK_SHRINK | GTK_FILL,
                   GTK_FILL,
                   3, 3);
  gtk_widget_show(toolbar);
  return (toolbar);
}

void
ui_show_error (const gchar *format, ...)
{
    GtkWidget *dialog;
    /* build the string */
    va_list args;
    char sz[256];
    /* build the message string */
    va_start(args, format);
    vsprintf(sz, format, args);
    va_end(args);
    /* create the dialog box */
    dialog = gnome_message_box_new(N_(sz), GNOME_MESSAGE_BOX_ERROR,
				           GNOME_STOCK_BUTTON_OK, NULL);
    gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}                    
