/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"

/* global variables */
static gboolean l_connecting = FALSE;
static Gda_Connection *l_database = NULL;
static GtkWidget *w_dbname, *w_login, *w_pwd, *w_host,
                 *w_port, *w_options, *w_combo;
static GtkWidget *w_dsnlist;

/* static function */
static void 
dialog_clicked_cb(GnomeDialog *dialog, gint button_number, 
                  gpointer data)
{
  register gint cnt;
  extern CORBA_ORB orb;
  switch (button_number)
    {
    case 0 : /* OK button */
      {
        gint cur_tab = gtk_notebook_current_page(GTK_NOTEBOOK(data));
	switch (cur_tab)
	  {
	  case 0 : /* 'new' tab */
	    {
	      Gda_Connection *db;
	      gchar *cur_driver, *drv_str, *dbname, *login, *pwd, 
	            *host, *port, *options;
	      /* get fields' values */
	      dbname = gtk_entry_get_text(GTK_ENTRY(w_dbname));
	      login = gtk_entry_get_text(GTK_ENTRY(w_login));
	      pwd = gtk_entry_get_text(GTK_ENTRY(w_pwd));
	      host = gtk_entry_get_text(GTK_ENTRY(w_host));
	      port = gtk_entry_get_text(GTK_ENTRY(w_port));
	      options = gtk_entry_get_text(GTK_ENTRY(w_options));
	      drv_str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_combo)->entry));
	      if (drv_str != NULL)
	        {
		  gint rc;
		  /* create driver connection */
		  db = gda_connection_new(orb);
		  db->provider = g_strdup(drv_str);
		  rc = gda_connection_open(db, dbname, login, pwd);
		  if (rc == 0)
		    {
		      /* close dialog */
		      l_connecting = FALSE;
		      db_new_connection(db);
		      gnome_dialog_close(dialog);
		    }
		  else ui_show_error("Could not open connection to database %s", 
		                     dbname);
		}
	     }
           case 1 : /* available connections tab */
             break;
	   }
         break;
      }
    case 1 : /* Cancel button */
      /* close dialog */
      l_connecting = FALSE;
      gnome_dialog_close(dialog);
      break;
    }
}

static GtkWidget *
create_new_connection_tab (GtkWidget *notebook)
{
  GtkWidget *tab;
  register gint cnt;
  GList *providers;
  /* check parameters */
  g_return_val_if_fail(notebook != NULL, NULL);
  /* create the table */
  tab = gtk_table_new(5, 4, FALSE);
  gtk_widget_show(tab);
  /* create widgets in the following order: */
  /* driver's combo */
  ui_new_label_in_table(tab, _("Provider:"), 0, 0, 1, 1);
  w_combo = ui_new_combo_in_table(tab, 1, 0, 3, 1);
  /* get list of providers from GDA library */
  providers = gda_connection_list_providers();
  if (providers == NULL)
    ui_show_error("No GDA servers available");
  while (providers != NULL)
    {
      Gda_Server *server = (GoadServer *) providers->data;
      GtkWidget *li = gtk_list_item_new_with_label(server->name);
      gtk_container_add(GTK_CONTAINER(GTK_COMBO(w_combo)->list), li);
      gtk_widget_show(li);
      providers = g_list_remove(providers, (gpointer) server);
      gda_server_free(server);
    }
  /* 1 - database name */
  ui_new_label_in_table(tab, _("Database:"), 0, 1, 1, 2);
  w_dbname = ui_new_entry_in_table(tab, "DBNAME", NULL, 1, 1, 2, 2);
  /* 2 - login */
  ui_new_label_in_table(tab, _("User:"), 0, 2, 1, 3);
  w_login = ui_new_entry_in_table(tab, "LOGIN", g_get_user_name(), 1, 2, 2, 3);
  /* 3 - password */
  ui_new_label_in_table(tab, _("Password:"), 2, 2, 3, 3);
  w_pwd = ui_new_entry_in_table(tab, "PASSWORD", NULL, 3, 2, 4, 3);
  gtk_entry_set_visibility(GTK_ENTRY(w_pwd), FALSE);
  /* 4 - host */
  ui_new_label_in_table(tab, _("Host:"), 0, 3, 1, 4);
  w_host = ui_new_entry_in_table(tab, "HOST", NULL, 1, 3, 2, 4);
  /* 5 - port */
  ui_new_label_in_table(tab, _("Port:"), 2, 3, 3, 4);
  w_port = ui_new_entry_in_table(tab, "PORT", NULL, 3, 3, 4, 4);
  /* 6 - options */
  ui_new_label_in_table(tab, _("Options:"), 0, 4, 1, 5);
  w_options = ui_new_entry_in_table(tab, "OPTIONS", NULL, 1, 4, 2, 5);
  return (tab);
}

static GtkWidget *
create_new_avail_tab (GtkWidget *notebook)
{
  GtkWidget *tab, *scrolled_window;
  gchar *titles[] =
  {
    _("Provider"), _("Database"), _("Login"), _("Password"),
    _("Host"), _("Port"), _("Options")
  };
  /* check parameters */
  g_return_val_if_fail(notebook != NULL, NULL);
  /* create the table */
  tab = gtk_table_new(2, 4, FALSE);
  gtk_widget_show(tab);
  /* create scrolled window */
  scrolled_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach(GTK_TABLE(tab), 
		   scrolled_window, 0, 2, 0, 4,
		   GTK_FILL | GTK_EXPAND,
		   GTK_SHRINK | GTK_EXPAND | GTK_FILL,
		   3, 3);
  gtk_widget_show(scrolled_window);
  /* create list widget */
  w_dsnlist = gtk_clist_new_with_titles(7, titles);
  gtk_container_add(GTK_CONTAINER(scrolled_window), w_dsnlist);
  gtk_widget_show(w_dsnlist);
  return (tab);
}

/* function definitions */
void 
db_open_connection (GtkWidget *w, gpointer data)
{
  register int cnt;
  GtkWidget *notebook, *driver_tab, *avail_tab, *label;
  static GtkWidget *dialog;
  /* if we are already connecting... */
  if (l_connecting)
    {
      gtk_widget_show(dialog);	/* FIXME: want to get focus!!! */
      gtk_widget_grab_focus(dialog);
      return;
    }
  l_connecting = TRUE;
  /* create dialog box */
  dialog = gnome_dialog_new("Open Connection", 
                            GNOME_STOCK_BUTTON_OK,
                            GNOME_STOCK_BUTTON_CANCEL,
                            NULL);
  gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
  /* create notebook */
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), notebook,
                     TRUE, TRUE, GNOME_PAD);
  gtk_signal_connect(GTK_OBJECT(dialog), "clicked",
                     GTK_SIGNAL_FUNC(dialog_clicked_cb), (gpointer) notebook);
  /* add database drivers connection screen */
  driver_tab = create_new_connection_tab(notebook);
  if (driver_tab != NULL)
    {
      /* create the tab's label */
      label = gtk_label_new("New Connection");
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), driver_tab,
			       label);
    }
  /* create available connections tab */
  avail_tab = create_new_avail_tab(notebook);
  if (avail_tab != NULL)
    {
      /* create the tab's field */
      label = gtk_label_new("Available");
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), avail_tab, label);
    }
  gtk_widget_show(notebook);
  /* finally show the dialog */
  gtk_widget_show(dialog);
}







