/* GNOME DB
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_MYSQL_TYPES_H__
#define __GDA_MYSQL_TYPES_H__

#include <glib.h>
#include <mysql/mysql.h>


typedef struct _Gda_MYSQL_Recordset
{
}Gda_MYSQL_Recordset;

typedef struct _Gda_MYSQL_Connection
{
  gchar* host;
  gchar* db;
  gchar* user;
  gchar* password;
  gchar* port;
  gchar* unix_socket;
  gchar* flags;
  MYSQL* mysql;
  
}Gda_MYSQL_Connection;

typedef struct _Gda_MYSQL_Command
{
  Gda_MYSQL_Connection* cnc;
  gchar*                cmd;
}Gda_MYSQL_Command;


typedef struct _Gda_MYSQL_Parameter
{
} Gda_MYSQL_Parameter;

typedef struct _Gda_MYSQL_Field
{
} Gda_MYSQL_Field;




typedef struct _Gda_MYSQL_Error
{
  gchar* description;
  gint   number;
  gchar* source;
  gchar* sqlstate;
  gchar* native;
}Gda_MYSQL_Error;

#endif
