#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include <mysql/mysql.h>
#include <glib.h>



#include "gda-mysql-connection.h"

void           initialize_schema_ops(void);

void
initialize_schema_ops(void)
{
  ;
}

Gda_MYSQL_Connection*
gda_mysql_connection_new()
{
  static int initialized = 0;
  
  Gda_MYSQL_Connection* c = g_new0(Gda_MYSQL_Connection, 1);

  if (!initialized)
    {
      initialize_schema_ops();
      initialized = 1;
    }
  return c;
}


void
gda_mysql_connection_free(Gda_MYSQL_Connection* c)
{
  if (c->host)
    g_free(c->host);
  if (c->db)
    g_free(c->db);
  if (c->port)
    g_free(c->port);
  if (c->unix_socket)
    g_free(c->unix_socket);
  if (c->flags)
    g_free(c->flags);
  if (c->mysql)
    {
      gda_mysql_connection_close(c);
      g_free(c->mysql);
    }
  if (c->user)
    g_free(c->user);
  if (c->password)
    g_free(c->password);
  g_free(c);
}


static gchar*
get_value(gchar* ptr)
{
  while (*ptr && *ptr != '=')
    ptr++;
  
  if (!*ptr)
    return 0;
  ptr++;
  if (!*ptr)
    return 0;
  
  while (*ptr && isspace(*ptr))
    ptr++;

  return g_strdup(ptr);
}


gint
gda_mysql_connection_open(Gda_MYSQL_Connection* cnc,
			  const gchar*          cnc_string,
			  const gchar*          user,
			  const gchar*          passwd)
{
  gchar* ptr_s;
  gchar* ptr_e;
  MYSQL* rc;
  int    err;
  
  ptr_s = cnc_string;
  while (ptr_s && *ptr_s)
    {
      ptr_e = strchr(ptr_s, ';');

      if (ptr_e)
	*ptr_e = '\0';
      if (strcasecmp(ptr_s, "HOST") == 0)
	cnc->host = get_value(ptr_s);
      else if (strncasecmp(ptr_s, "DATABASE", strlen("DATABASE")) == 0)
	cnc->db = get_value(ptr_s);
      else if (strcasecmp(ptr_s, "PORT") == 0)
	cnc->port = get_value(ptr_s);
      else if (strcasecmp(ptr_s, "UNIX_SOCKET") == 0)
	cnc->unix_socket = get_value(ptr_s);
      else if (strcasecmp(ptr_s, "FLAGS") == 0)
	cnc->flags = get_value(ptr_s);
      ptr_s = ptr_e;
      if (ptr_s)
	ptr_s++;
    }
  cnc->mysql = g_new0(MYSQL, 1);
  fprintf(stderr,"cnc->mysql = %p\n", cnc->mysql);
  fprintf(stderr,"** Calling mysql_real_connect\n");
  rc = mysql_real_connect(cnc->mysql, cnc->host,
			  cnc->user,
			  cnc->password,
			  cnc->port ? atoi(cnc->port) : 0,
			  cnc->unix_socket,
			  cnc->flags ? atoi(cnc->flags) : 0);

  fprintf(stderr,"cnc->mysql after connect = %p\n", cnc->mysql);
  
  if (!rc)
    {
      fprintf(stderr,"mysql errno  = %d\n",mysql_errno(cnc->mysql));
      fprintf(stderr,"mysql errmsg = '%s'\n",
	      mysql_error(cnc->mysql));
      return -1;
    }
  fprintf(stderr,"before mysql_select_db: cnc->db = '%s'\n", cnc->db);
  fprintf(stderr,"cnc->mysql = %p\n", cnc->mysql);
  fprintf(stderr,"*** Calling mysql_select_db\n");
  err = mysql_select_db(cnc->mysql, cnc->db);
  fprintf(stderr,"mysql_select_db returns %d\n", err);
  if (err != 0)
    {
      fprintf(stderr,"mysql errno  = %d\n",mysql_errno(cnc->mysql));
      fprintf(stderr,"mysql errmsg = '%s'\n",
	      mysql_error(cnc->mysql));
      return -1;
    }
  fprintf(stderr,"gda_mysql_connection_open: returning\n");
  return 0;
}

gint
gda_mysql_connection_close(Gda_MYSQL_Connection* c)
{
  fprintf(stderr,"Calling mysql_close\n");
  mysql_close(c->mysql);
  return 0;
}
  
