/* Evolution calendar - Data model for ETable
 *
 * Copyright (C) 2000 Ximian, Inc.
 * Copyright (C) 2000 Ximian, Inc.
 *
 * Authors: Rodrigo Moya <rodrigo@ximian.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef E_CAL_MODEL_CALENDAR_H
#define E_CAL_MODEL_CALENDAR_H

#include "e-cal-model.h"

G_BEGIN_DECLS

#define E_TYPE_CAL_MODEL_CALENDAR            (e_cal_model_calendar_get_type ())
#define E_CAL_MODEL_CALENDAR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_CAL_MODEL_CALENDAR, ECalModelCalendar))
#define E_CAL_MODEL_CALENDAR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_CAL_MODEL_CALENDAR, ECalModelCalendarClass))
#define E_IS_CAL_MODEL_CALENDAR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_CAL_MODEL_CALENDAR))
#define E_IS_CAL_MODEL_CALENDAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), E_TYPE_CAL_MODEL_CALENDAR))

typedef struct _ECalModelCalendarPrivate ECalModelCalendarPrivate;

typedef enum {
	/* If you add new items here or reorder them, you have to update the
	   .etspec files for the tables using this model */
	E_CAL_MODEL_CALENDAR_FIELD_DTEND = E_CAL_MODEL_FIELD_LAST,
	E_CAL_MODEL_CALENDAR_FIELD_LOCATION,
	E_CAL_MODEL_CALENDAR_FIELD_TRANSPARENCY,
	E_CAL_MODEL_CALENDAR_FIELD_LAST
} ECalModelCalendarField;

typedef struct {
	ECalModel model;
	ECalModelCalendarPrivate *priv;
} ECalModelCalendar;

typedef struct {
	ECalModelClass parent_class;
} ECalModelCalendarClass;

GType              e_cal_model_calendar_get_type (void);
ECalModelCalendar *e_cal_model_calendar_new (void);

G_END_DECLS

#endif
