#include <Xm/Xm.h>
#include "../plot_widgets/Curves.h"

#define NUM_POINTS  10
static float Points[NUM_POINTS] = {4, 5, 7, 8, 0, 3, 9, 6, 2, 1};

main(int argc, char *argv[])
{
    XtAppContext app_context;
    Widget toplevel, curveW;
    XmString s1, s2;
    CurveStruct curve;
    
    /* Initialize X and the X toolkit */
    toplevel = XtAppInitialize(&app_context, "CurvesTest", NULL,
	    0, &argc, argv, NULL, NULL, 0);    
    		
    /* Create a curve widget. */
    curveW = XtVaCreateManagedWidget("CurveWidget", curvesWidgetClass, toplevel, 
    	    XmNxAxisLabel, s1=XmStringCreateSimple("X Axis Label"),
    	    XmNyAxisLabel, s2=XmStringCreateSimple("Y Axis Label"),
    	    NULL);
    XmStringFree(s1);
    XmStringFree(s2);

    /* Set the contents */
    curve.variable_name = "Variable 1";
    curve.num_point = NUM_POINTS;
    curve.mark_num = BLANK_MARK;
    curve.line_num = PLAIN_LINE;
    curve.options = CURVE_NO_OPTIONS;
    curve.points = Points;
    CurvesSetContents(curveW, &curve, 1, CURVES_RESCALE, True); 
  
    /* Realize widgets and call XtMainLoop to continuously process events */
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_context);
}
