/*
 * Center.c - nicht, dass ich egozentrisch waere, aber hiermit
 *            ist alles ordnungsgemaess zentriert...
 * 
 * Version 1.01 vom 04.05.1994
 * Aktueller Stand dieses Moduls:
 *   04.05.1994	    die XmNstrictSpacing-Ressource hinzugefuegt und
 *		    mit Funktion versehen. Ausserdem noch den Geometry-
 *		    Manager() ueberarbeitet, der Anfragen der Kinder
 *		    entgegennimmt.
 * 
 * (c) 1993, 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * albrecht@igpm.rwth-aachen.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "CenterP.h"


/* --------------------------------------------------------------------
 * Resourcen-Liste...
 * Hier werden diejenigen Resourcen definiert, die von "aussen" - also 
 * fuer den Programmierer oder Anwender - benutzbar und veraenderbar sind.
 * 
 * Der Aufbau der einzelnen Eintraege ist immer wieder gleich:
 * Resourcen-Name	XmN... oder XtN
 * Resourcen-Klasse     XmC... oder XtC
 * Resourcen-Type       XmR... oder XtR (Datentyp der Variable in der
 *                      struct der jeweiligen Widgetinstanz)
 * Resourcen-Groesse	aktuelle Groesse dieses Datentyps
 * Resourcen-Offset     Lage der Variable innerhalb der struct der
 *			Widgetinstanz
 * Defaultwert-Type     Typ des Defaultwertes
 * Defaultwert		(normalerweise) Zeiger auf den Defaultwert
 */
#define offset(field) XtOffsetOf(XmCenterRec, field)
static XtResource resources[] = {
    { /* Kinder horizontal oder vertikal ausrichten */
	XmNorientation, XmCOrientation, XmROrientation, 
	sizeof(unsigned char), offset(center.orientation), 
	XmRImmediate, (XtPointer) XmHORIZONTAL
    }, 
    { /* Abstand (horizontal) zwischen den Kindern */
	XmNhorizontalSpacing, XmCSpacing, XmRDimension, 
	sizeof(Dimension), offset(center.horizSpacing), 
	XmRImmediate, (XtPointer) 8
    }, 
    { /* Abstand (vertikal) zwischen den Kindern */
	XmNverticalSpacing, XmCSpacing, XmRDimension, 
	sizeof(Dimension), offset(center.vertSpacing), 
	XmRImmediate, (XtPointer) 8
    }, 
    { /* Rand (horizontal) zwischen Kindern und Center-Widget */
	XmNhorizontalBorder, XmCHorizontalBorder, XmRDimension, 
	sizeof(Dimension), offset(center.horizBorder), 
	XmRImmediate, (XtPointer) 0
    }, 
    { /* dto. Rand (vertikal) */
	XmNverticalBorder, XmCVerticalBorder, XmRDimension, 
	sizeof(Dimension), offset(center.vertBorder), 
	XmRImmediate, (XtPointer) 0
    }, 
    {
	XmNstrictSpacing, XmCStrictSpacing, XmRBoolean, 
	sizeof(Boolean), offset(center.StrictSpacing), 
	XmRImmediate, (XtPointer) True
    }, 
    { /* Das hier ist so ein daemlicher Trick, um zu verhindern, dass
         dieses Widget die Standardbreite des Randes von 1 erbt --
	 das sieht naemlich so daneben aus! */
	XmNborderWidth, XmCBorderWidth, XmRDimension, 
	sizeof(Dimension), offset(core.border_width), 
	XmRImmediate, (XtPointer) 0
    }
}; /* resources[] */

/* --------------------------------------------------------------------
 * Nun kommen noch die Motif-Spezialitaeten... synthetische Ressourcen.
 * Darunter fallen alle Ressourcen, die in irgendeiner Weise Laengen
 * oder Positionen repraesentieren. Diese werden auf diese Weise
 * dimensionsbehaftet (Pixel, cm oder was auch immer...).
 */
XmSyntheticResource syn_resources[] = {
    {
	XmNhorizontalSpacing, sizeof(Dimension), 
	offset(center.horizSpacing), 
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }, 
    {
	XmNverticalSpacing, sizeof(Dimension), 
	offset(center.vertSpacing), 
	_XmFromVerticalPixels, _XmToVerticalPixels
    }, 
    {
	XmNhorizontalBorder, sizeof(Dimension), 
	offset(center.horizBorder), 
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }, 
    {
	XmNverticalBorder, sizeof(Dimension), 
	offset(center.vertBorder), 
	_XmFromVerticalPixels, _XmToVerticalPixels
    }
}; /* syn_resources[] */

/* --------------------------------------------------------------------
 * Funktions-Prototypen fuer die 'Methoden' des Center-Widgets
 */
static void             Initialize(Widget, XmCenterWidget, ArgList, Cardinal *);
static void             Resize();
static Boolean          SetValues(XmCenterWidget, XmCenterWidget, XmCenterWidget, 
			    ArgList, Cardinal *);
static XtGeometryResult QueryGeometry(XmCenterWidget, XtWidgetGeometry *, 
			    XtWidgetGeometry *); 
static XtGeometryResult GeometryManager(Widget, XtWidgetGeometry *, 
                            XtWidgetGeometry *);
static void             ChangeManaged(XmCenterWidget);
static void             ClassPartInit(WidgetClass);
static void             Redisplay(XmCenterWidget, XEvent *, Region);

/* --------------------------------------------------------------------
 * Klassendefinition fuer XmXmCenterWidgets. Da es sich dabei um Nach-
 * kommen der Motif-Widgetklasse XmManager handelt, tummeln sich hier
 * in der Klassenstruktur doch 'ne Menge Daten.
 */
XmCenterClassRec xmCenterClassRec = {
    { /*** core-Klasse ***/
    /* superclass                   */	(WidgetClass) &xmManagerClassRec, 
    /* class_name                   */	"XmCenter",
    /* widget_size                  */	sizeof(XmCenterRec),
    /* class_initialize   	    */	NULL,
    /* class_part_initialize	    */	(XtWidgetClassProc) ClassPartInit,
    /* class_inited       	    */	False, /* IMMER mit FALSE initialisieren !! */
    /* initialize	  	    */	(XtInitProc) Initialize,
    /* initialize_hook		    */	NULL,
    /* realize		  	    */	XtInheritRealize,
    /* actions		  	    */	NULL,
    /* num_actions	  	    */	0,
    /* resources	  	    */	resources,
    /* num_resources	  	    */	XtNumber(resources),
    /* xrm_class	  	    */	NULLQUARK,
    /* compress_motion	  	    */	True,
    /* compress_exposure  	    */	XtExposeCompressMultiple,
    /* compress_enterleave	    */	True,
    /* visible_interest	  	    */	False,
    /* destroy		  	    */	NULL,
    /* resize		  	    */	Resize,
    /* expose		  	    */	(XtExposeProc) Redisplay,
    /* set_values	  	    */	(XtSetValuesFunc) SetValues,
    /* set_values_hook		    */	NULL,
    /* set_values_almost	    */	XtInheritSetValuesAlmost,
    /* get_values_hook		    */	NULL,
    /* accept_focus	 	    */	NULL,
    /* version			    */	XtVersion,
    /* callback_private   	    */	NULL,
    /* tm_table		   	    */	XtInheritTranslations,
    /* query_geometry		    */  (XtGeometryHandler) QueryGeometry,
    /* display_accelerator	    */	XtInheritDisplayAccelerator,
    /* extension          	    */	NULL
    }, 
    { /*** composite-Klasse ***/
    /* geometry_manager		    */	(XtGeometryHandler) GeometryManager,
    /* change_managed		    */	(XtWidgetProc) ChangeManaged,
    /* insert_child		    */	XtInheritInsertChild,
    /* delete_child		    */	XtInheritDeleteChild,
    /* extension		    */	NULL
    }, 
    { /*** constraint-Klasse ***/
    /* resources		    */	NULL,
    /* num_resources		    */	0,
    /* constraint_size		    */	sizeof(XmManagerConstraintPart),
    /* initialize		    */	NULL,
    /* destroy			    */	NULL,
    /* set_values		    */	NULL,
    /* extension		    */	NULL
    }, 
    { /*** xmManager-Klasse ***/
    /* translations                 */	XtInheritTranslations,
    /* syn_resources                */	NULL,
    /* num_syn_resources            */	0,
    /* syn_constraint_resources     */	NULL,
    /* num_syn_constraint_resources */	0,
    /* parent_process		    */	XmInheritParentProcess,
    /* extension		    */	NULL
    }, 
    { /*** XmCenter-Klasse ***/
    /*				    */	0
    }
}; /* xmCenterClassRec */
WidgetClass xmCenterWidgetClass = (WidgetClass) &xmCenterClassRec;

/* --------------------------------------------------------------------
 * Leider muss ich mich an dieser Stelle auf's Glatteis begeben. Bis-
 * lang gibt's ja noch keine anstaendige Dokumentation, deshalb kann
 * ich nicht sagen, ob und wann man das hier braucht...
 */
static void ClassPartInit(WidgetClass wc)
{
    _XmFastSubclassInit(wc, XmMANAGER_BIT);
} /* ClassPartInit */

/* --------------------------------------------------------------------
 * Sobald ein Zipfelchen dieses Layout-Widgets sichtbar wird, koennte
 * es sein, dass dabei Gadgets sichtbar werden. Da aber Gadgets kein
 * eigenes Fenster auf dem X-Server besitzen, erhalten sie nicht auto-
 * matisch ExposeEvents. Vielmehr muessen wir selbst dafuer sorgen, 
 * dass die betroffenen Gadgets neu gezeichnet werden.
 * Leider kann ich immer noch nicht so ganz verstehen, warum man sich
 * in der OSF bezueglich der Parameter fuer Funktionsprototypen derart
 * uneinig ist...
 */
static void Redisplay(XmCenterWidget w, XEvent *event, Region region)
{
#if (XmREVISION > 1)
    _XmRedisplayGadgets((Widget) w, 
                        event, region);
#else
    _XmRedisplayGadgets((CompositeWidget) w, 
                        (XExposeEvent *) event, region);
#endif
} /* Redisplay */

/* --------------------------------------------------------------------
 * Ermittele die groessten Ausmasse in Hoehe und Breite der Kinder. Mit
 * dieser Volkszaehlung laesst sich dann ermitteln, wie gross das
 * Center-Widget sein muss und und und... Da wir hier ja in einem demo-
 * kratischen Land leben bleibt natuerlich der Datenschutzt bzgl. der
 * Kinder-Widgets gewahrt. D.h. es werden alle personenbezogenen Daten
 * nach Gebrauch sofort vom Stammdatenblatt abgetrennt und... (bla!)
 * 
 * Parameter:
 *   w		    Eine Instanz des Center-Widgets
 *   QueryChildren  Legt fest, ob via XtQueryGeometry die Kinder nach
 *                  ihren Wuenschen befragt werden, oder ob die Groesse
 *                  eines Kindes direkt aus dessen core.widht und
 *                  core.height ausgelesen wird.
 * 
 * Ergebnis:
 *   *maxWidth	    groesste Breite, die uns untergekommen ist
 *   *maxHeight	    dto. groesste Hoehe
 *   *mappedChilds  Anzahl sichtbarer Kinder
 */
static void ChildDimensions(XmCenterWidget w, 
                            int *maxWidth, int *maxHeight, 
			    int *mappedChilds, Boolean QueryChildren)
{
    Widget           Child;
    int              i;
    XtWidgetGeometry PreferredGeom;
    
    *maxWidth = 1; *maxHeight = 1; *mappedChilds = 0;
    for ( i = 0; i < w->composite.num_children; ++i ) {
	Child = w->composite.children[i];
	/* Nur sichtbare Kinder mit einbeziehen... Da wir zudem
	 * hoeflich sind, fragen wir "die Kleinen" nach ihren
	 * Wuenschen: "wie gross wollt ihr denn einmal werden?!"
	 */
	if ( XtIsManaged(Child) ) {
	    ++(*mappedChilds);
	    if ( QueryChildren )
		XtQueryGeometry(Child, NULL, &PreferredGeom);
	    else {
		PreferredGeom.width  = Child->core.width;
		PreferredGeom.height = Child->core.height;
	    }
	    if ( PreferredGeom.width > *maxWidth )
		*maxWidth = PreferredGeom.width;
	    if ( PreferredGeom.height > *maxHeight )
		*maxHeight = PreferredGeom.height;
	}
    }
} /* ChildDimensions */

/* --------------------------------------------------------------------
 * Naja... diese Routine scheint ja bereits zu einer Institution beim
 * Schreiben von Composite-Widgets geworden zu sein.
 * Hierin werden alle Kinder entsprechend der aktuellen Groesse dieses
 * Center-Widgets ausgerichtet. Dabei existieren momentan zwei unter-
 * schiedliche Anordnungs-Schemata (abhaengig von XmNstrictSpacing).
 * Ist besagte Ressourcenvariable = False, dann werden alle Kinder im
 * Abstand von Xmn(horiz/vert)Spacing angeordnet, ansonsten alle im
 * gleichen Abstand innerhalb von core.width-2*Rand (entsprechend
 * bei vertikaler Ausrichtung).
 */
static void DoLayout(XmCenterWidget w)
{
    int              NrOfManagedChildren;
    int              i;
    Widget           Child;
    XtWidgetGeometry IntendedGeom, PreferredGeom;
    int              MaxChildWidth, MaxChildHeight;
    int		     ChildNum;
    int		     x, y, width, height;
    int x1, y1;
    int		     hAvail, vAvail;
    Dimension	     BorderWidth;
    
/* Ermittele die Ausmasse des dicksten resp. hoechsten Kindes und die
 * die Anzahl von sichtbaren Kindern insgesamt. Ist keines sichtbar, 
 * koennen wir uns das sonst folgende Prozedere getrost sparen.
 */
    ChildDimensions(w, &MaxChildWidth, &MaxChildHeight, 
                       &NrOfManagedChildren, False);
    if ( !NrOfManagedChildren ) return;

/* Berechne die linke obere Ecke des imaginaeren Rechtecks, innerhalb
 * dessen die Kinder ausgerichtet werden. Dieses imaginaere Rechteck
 * hat dabei bei horizontaler Ausrichtung die Hoehe des hoechsten
 * Kindes, bei vertikaler Ausrichtung die des breitesten Kindes.
 */
    if ( w->center.orientation == XmHORIZONTAL ) {
	if ( !w->center.StrictSpacing && (NrOfManagedChildren > 1) )
	    x = w->center.horizBorder;
	else
	    x = (w->core.width -
	        (NrOfManagedChildren * 
	            (MaxChildWidth + w->center.horizSpacing)
	        - w->center.horizSpacing)) /2;
	y = (w->core.height - MaxChildHeight) / 2;
    } else {
	if ( !w->center.StrictSpacing && (NrOfManagedChildren > 1) )
	    y = w->center.vertBorder;
	else
	    y = (w->core.height -
	        (NrOfManagedChildren * 
	            (MaxChildHeight + w->center.vertSpacing)
	        - w->center.vertSpacing)) / 2;
	x = (w->core.width - MaxChildWidth) / 2;
    }
	    
/*
 * Nun koennen wir die Kinder an ihre Plaetze stellen.
 */
    ChildNum = 0;
    for ( i = 0; i < w->composite.num_children; ++i ) {
	Child = w->composite.children[i];
	/* Auch hier wieder nur die sichtbaren Kinder behandeln. */
	if ( XtIsManaged(Child) ) {
	    width = MaxChildWidth; height = MaxChildHeight;
	    XtVaGetValues(Child, XtNborderWidth, &BorderWidth, NULL);
	    XtResizeWidget(Child, width, height, BorderWidth);
	    XtMoveWidget(Child, x, y);
	    ++ChildNum;
	    if ( w->center.StrictSpacing ) {
		if ( w->center.orientation == XmHORIZONTAL )
		    x += MaxChildWidth + w->center.horizSpacing;
		else
		    y += MaxChildHeight + w->center.vertSpacing;
	    } else if ( NrOfManagedChildren > 1) {
		if ( w->center.orientation == XmHORIZONTAL )
		    x += (w->core.width - 2 * w->center.horizBorder
		           - MaxChildWidth) / (NrOfManagedChildren - 1);
		else
		    y += (w->core.height - 2 * w->center.vertBorder
		           - MaxChildHeight) / (NrOfManagedChildren - 1);
	    }
	}
    }
} /* DoLayout */

/* --------------------------------------------------------------------
 * Pappi fragt nach, wie gross wir denn sein wollen.
 * Die hier benutzte Vorgehensweise zur Ermittlung der Groesse:
 *   Sobald der Vater uns eine Breite (oder aber Hoehe) vorschlaegt, 
 *   die fuer uns eigentlich zu klein ist, meckern wir und schlagen
 *   die von uns benoetigte Breite (Hoehe) vor.
 * Soweit also zur Theorie... leider sieht es beispielsweise das
 * Motif Form-Widget ueberhaupt nicht ein, uns auch nur ein einziges
 * Mal nach unseren Wuenschen zu fragen! Damit es bei derart unum-
 * gaenglichen Widgets dann doch noch geht, muss ChangedManaged die
 * Kohlen wieder aus dem Feuer holen mit einer Sondertour.
 * 
 * Parameter:
 *   *Request	    Vom Vater vorgeschlagene Geometrie
 * 
 * Ergebnis:
 *   *Reply	    Unsere Antwort auf die vorgeschlagene Geometrie
 *   sowie XtGeometryYes oder XtGeometryAlmost, je nachdem, wie gut
 *   uns Pappis Vorschlag in den Kram passt.
 */
static XtGeometryResult QueryGeometry(XmCenterWidget w, 
                                      XtWidgetGeometry *Request, 
			              XtWidgetGeometry *Reply)
{
    XtGeometryResult result = XtGeometryYes;
    int              maxChildWidth, maxChildHeight;
    int              NrOfMappedChildren;
    int		     reqW, reqH;
    
/* Elternteil will nichts weiter aendern, also ist uns das
 * recht so.
 */
    Request->request_mode &= CWWidth | CWHeight;
    if ( Request->request_mode == 0 ) return result;
/* Finde heraus, wieviele Kinder sichtbar sind und wie gross damit die
 * ganze Chose werden muesste.
 */    
    ChildDimensions(w, &maxChildWidth, &maxChildHeight, 
                       &NrOfMappedChildren, True);
    
/* Ueberpruefe, ob uns das in der Breite passt, was Pappi moechte... */
    if ( Request->request_mode & CWWidth ) {
	reqW = 2*w->center.horizBorder;
	if ( NrOfMappedChildren > 0 ) {
	    if ( w->center.orientation == XmHORIZONTAL )
		reqW += (NrOfMappedChildren-1)*w->center.horizSpacing +
			NrOfMappedChildren*maxChildWidth;
	    else
		reqW += maxChildWidth;
	}
	if ( reqW < 1 ) reqW = 1; /* Nur so zur Sicherheit... */
	if ( Request->width < reqW ) {
/* Wenn Pappi uns etwas vorschlaegt, was im wahrsten Sinne des Wortes 
 * vorn und hinten nicht reicht, dann versuchen wir ihn entsprechend
 * zu korrigieren. ("Versuchen" deshalb, weil er diesen Vorschlag auch
 * voellig ignorieren kann.)
 */
	    result               = XtGeometryAlmost;
	    Reply->width         = reqW;
	    Reply->request_mode |= CWWidth;
	}
    }
/* Die ganze Chose nun noch vertikal */
    if ( Request->request_mode & CWHeight ) {
	reqH = 2*w->center.vertBorder;
	if ( NrOfMappedChildren > 0 ) {
	    if ( w->center.orientation == XmVERTICAL )
		reqH += (NrOfMappedChildren-1)*w->center.vertSpacing +
			NrOfMappedChildren*maxChildHeight;
	    else
		reqH += maxChildHeight;
	}
	if ( reqH < 1 ) reqH = 1;
	if ( Request->height < reqH ) {
	    result               = XtGeometryAlmost;
	    Reply->height        = reqH;
	    Reply->request_mode |= CWHeight;
	}
    }
    return result;
} /* QueryGeometry */

/* --------------------------------------------------------------------
 * Die Groesse des Center-Widgets hat sich veraendert und deshalb
 * mussen alle Kinder neu positioniert werden.
 * Letzten Endes laeuft hier alles auf ein ordinaeres DoLayout()
 * hinaus, um die Kinder umher zu schieben.
 * 
 * Parameter:
 *   w		    Die bereits hinlaenglich bekannte Instanz dieses
 *		    Widgets
 */
static void Resize(XmCenterWidget w)
{
    DoLayout(w);
} /* Resize */

/* --------------------------------------------------------------------
 * Ein Kind moechte sein Groesse veraendern und fragt deshalb hier bei
 * uns an.
 * Parameter:
 *   w		    Naja...
 *   *Request	    Vorschlag des Kindes
 * Ergebnis:
 *   *Reply	    Unsere Antwort darauf
 *   XtGeometryYes, da es uns bislang immer passt.
 */
static XtGeometryResult GeometryManager(Widget w, 
                                        XtWidgetGeometry *Request, 
				        XtWidgetGeometry *Reply)
{
    XtGeometryResult result = XtGeometryYes;
    int maxChildWidth, maxChildHeight, NrOfMappedChildren;
    
    /* Es ist den Kindern nicht erlaubt, ihre Position zu veraendern! */
    if ( ((Request->request_mode & CWX) && (Request->x != w->core.x)) ||
         ((Request->request_mode & CWY) && (Request->y != w->core.y)) )
	return XtGeometryNo;
    
    /* Ansonsten darf ein Kind hoechstens noch groesser als der bisherige
     * Rest werden. Dann werden alle anderen Kinder auf die gleiche
     * Groesse aufgeblasen...
     */
    ChildDimensions((XmCenterWidget) XtParent(w), 
                    &maxChildWidth, &maxChildHeight, 
		    &NrOfMappedChildren, True);
    if ( Request->request_mode & CWWidth ) 
	if ( Request->width > maxChildWidth )
	    maxChildWidth = Request->width;
	else
	    result = XtGeometryAlmost;
    if ( Request->request_mode & CWHeight )
	if ( Request->height > maxChildHeight )
	    maxChildHeight = Request->height;
	else
	    result = XtGeometryAlmost;
    
    /* Wenn es nicht nur bloss eine Anfrage war, dann muessen wir
     * hier die restlichen Kinder ebenfalls noch anordnen.
     */
    if ( !(Request->request_mode & XtCWQueryOnly) )
	DoLayout((XmCenterWidget) XtParent(w));
    
    if ( Reply ) {
	Reply->request_mode = CWWidth | CWHeight;
	Reply->width        = maxChildWidth;
	Reply->height       = maxChildHeight;
    }
    
    return result;
} /* GeometryManager */

/* --------------------------------------------------------------------
 * Diese 'Methode' wird immer dann aufgerufen, wenn ein oder mehrere
 * Kinder 'gemanaged' werden (bzw. das Gegenteil davon, was auch immer
 * das sei!).
 */
static void ChangeManaged(XmCenterWidget w)
{
    XtWidgetGeometry Request, Reply;
    XtGeometryResult result;
    Dimension        width, height;

/* Als allererste Aufgabe muessen wir Motif darauf hinweisen, dass sich
 * 'was tat, was evtl. den Fokus beruehren koennte...
 */
    _XmNavigChangeManaged((Widget) w);

/* Zuerst erfolgt ein Dummy-Aufruf an die eigene QueryGeometry()-Methode,
 * um so die erforderliche (minimale) Groesse des Center-Widgets zu
 * ermitteln.
 */
    Request.request_mode = CWWidth | CWHeight;
    Request.width        = 0;
    Request.height       = 0;
    QueryGeometry(w, &Request, &Reply);
    width = Reply.width; height = Reply.height;
/* Mit der Groesse laufen wir dann schnurstracks zu Pappi und fragen
 * ihn, ob er unsere neue Groesse denn auch mag...
 */
    result = XtMakeResizeRequest((Widget) w, width, height, 
                                            &width, &height);
    if ( result == XtGeometryAlmost )
	result = XtMakeResizeRequest((Widget) w, width, height, 
	                                         NULL, NULL);
/* Hat Pappi akzeptiert, dann nehmen wir die neue Groesse an. */
    if ( result == XtGeometryYes ) {
	w->core.width  = width;
	w->core.height = height;
    }
    DoLayout(w);
} /* ChangeManaged */

/* --------------------------------------------------------------------
 * Sobald irgendeine Resource veraendert wird, erfolgt der Aufruf
 * hierin als Benachrichtigung, einmal nach dem rechten zu sehen.
 * 
 * Parameter:
 *   sind mir zu kompliziert!
 * 
 Ergebnis:
 *   True, falls Widget neu gezeichnet werden soll.
 */
static Boolean SetValues(XmCenterWidget current, XmCenterWidget req, 
                         XmCenterWidget new, 
	                 ArgList args, Cardinal *NumArgs)
{
    /* Bestimmte Variablen lassen sich nur bei der (Er-) Zeugung
     * des Widget veraendern...
     */
    new->center.orientation = current->center.orientation;
    
    if ( (new->core.width           != current->core.width)	     ||
         (new->core.height          != current->core.height)	     ||
	 (new->core.border_width    != current->core.border_width)   ||
	 (new->center.horizSpacing  != current->center.horizSpacing) ||
	 (new->center.vertSpacing   != current->center.vertSpacing)  ||
	 (new->center.horizBorder   != current->center.horizBorder)  ||
	 (new->center.vertBorder    != current->center.vertBorder)   ||
	 (new->center.StrictSpacing != current->center.StrictSpacing)
	)
	DoLayout(new);
	
    if ( !XtIsRealized((Widget) current) ) return False;
    return False;
} /* SetValues */

/* --------------------------------------------------------------------
 * Alles initialisieren, sobald das Widget eingerichtet wird.
 */
static void Initialize(Widget request, XmCenterWidget new, 
                       ArgList args, Cardinal *ArgCount)
{
    if ( new->core.width == 0 )
	new->core.width = new->center.horizBorder*2 + INITIAL_WIDTH;
    if ( new->core.height == 0 )
	new->core.height = new->center.vertBorder*2 + INITIAL_HEIGHT;
	
    if ( (new->center.orientation != XmHORIZONTAL) &&
         (new->center.orientation != XmVERTICAL) )
	new->center.orientation = XmHORIZONTAL;
} /* Initialize */


/* Ende von Center.c */
