/*
 * CenterP.h - nicht, dass ich egozentrisch waere, aber hiermit
 *             ist alles ordnungsgemaess zentriert...
 * 
 * Letzte Modifikation: 02.05.1994    Revisionsstand: 1.00
 * 
 * (c) 1993, 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * albrecht@igpm.rwth-aachen.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */
#ifndef __CenterWidgetP_h
#define __CenterWidgetP_h

#include "Center.h"
#include <Xm/XmP.h>
#if (XmREVISION > 1)
#include <Xm/ManagerP.h>
#endif

#define INITIAL_WIDTH	5
#define INITIAL_HEIGHT	5

/*********************************************************************
 * Klassendefinition
 *********************************************************************/
/* Neue Datenfelder fuer den Klassenrecord der Center-Widgetklasse */
typedef struct _XmCenterClassPart {
    int Just_to_keep_the_compiler_happy; /* Der Name ist Programm */
} XmCenterClassPart;
/*
 * Nun folgt die vollstaendige Klassenstruktur, mit all' den Felder,
 * die bereits von den Vorfahren geerbt wurden.
 */
typedef struct _XmCenterClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmCenterClassPart   center_class;
} XmCenterClassRec;
extern XmCenterClassRec xmCenterClassRec;

/*********************************************************************
 * Instanzdefinition
 *********************************************************************/
typedef struct _XmCenterPart {
/* Resourcen ... hierauf darf von aussen zugegriffen werden! */
    unsigned char   orientation;	/* Ausrichtung aller Kinder */

    Dimension	    horizSpacing;
    Dimension	    vertSpacing;
    Boolean	    StrictSpacing;
    
    Dimension	    horizBorder;
    Dimension	    vertBorder;

/* Ab hier wird's privat! */
} XmCenterPart;

/*
 * vollstaengige Instanzenstruktur
 */
typedef struct _XmCenterRec {
    CorePart       core;
    CompositePart  composite;
    ConstraintPart constraint;
    XmManagerPart  manager;
    XmCenterPart   center;
} XmCenterRec;

#endif
/* Ende von CenterP.h */
