/* $Id: RulerP.h,v 1.1 1999/08/27 18:33:57 falk Exp $
 *
 * RulerP.h - Private definitions for Index Ruler widget
 * 
 */

#ifndef _RulerP_h
#define _RulerP_h

/***********************************************************************
 *
 * Ruler Widget Private Data
 *
 ***********************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/Xmu/Converters.h>
#include "Ruler.h"

/* New fields for the Ruler widget class record */
typedef struct {XtPointer extension;} RulerClassPart;

/* Full class record declaration */
typedef struct _RulerClassRec {
    CoreClassPart	core_class;
    RulerClassPart	ruler_class;
} RulerClassRec;

extern RulerClassRec rulerClassRec;



/****************************************************************
 *
 * instance record declaration
 *
 ****************************************************************/

/* New fields for the Ruler widget record */
typedef struct {
    /* resources */
    int		labelStep ;		/* want labels this many units apart */
    int		labelDiv ;		/* want this many labels/unit */
    XtLabelStyle labelStyle ;		/* fractions or decimal */
    int		markStep ;		/* want marks this many units apart */
    int		markDiv ;		/* want this many marks/unit */
    int		orientation ;		/* N/S/E/W */
    Pixel	foreground ;
    Pixel	pointerColor ;
    Boolean	showPointer ;		/* flag: show pointer */
    float	minValue ;		/* left/top-most value */
    float	scale ;			/* pixels/unit */
    float	value ;			/* current pointer position */
    int		iValue ;		/* same, in pixels */
    Cursor	cursor ;		/* normal cursor */
    XFontStruct	*font, *fracFont ;
    XtCallbackList callbacks ;
    XtPointer	userData ;

    /* private state */
    GC		foregroundGC ;
    GC		fracGC ;
    GC		pointerGC ;
    int		drag ;		/* cursor tracking */
    Region	clip ;		/* full region */
    Pixmap	indexPm ;	/* saved pixels under index */
    Boolean	indexSaved ;	/* pixels have been saved */

    /* Here is the info used to redraw the ruler: */

    int		length ;	/* length of working area of ruler */
    int		lStep ;		/* actual label step */
    int		lDiv ;		/* actual label divisions */
    int		mStep ;		/* actual mark step to use */
    int		mDiv ;		/* actual mark divisions */
    long	l0 ;		/* pixel value of base label */
    float	v0 ;		/* value of base label */
    int		txtWid ;
    Boolean	needs_layout ;
} RulerPart;


typedef struct _RulerRec {
    CorePart		core;
    RulerPart		ruler;
} RulerRec;


#endif /* _RulerP_h */
