/* $Id: ImageVT.c,v 1.1 1995/02/22 05:24:30 cwikla Exp $ */
/*
 * Copyright 1995 John L. Cwikla
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * Wolfram Research, Inc not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.    John L. Cwikla and Wolfram Research, Inc make no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and Wolfram Research, Inc disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * Wolfram Research, Inc be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 *  John L. Cwikla
 *  X Programmer
 *  Wolfram Research Inc.
 *
 *  cwikla@wri.com
*/


#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/ShellP.h>

#include "ImageV.h"

#include <stdio.h>

#define APPNAME "ImageViewTest"
#define APPCLASS "ImageViewTest"

static void QuitIt(_w, _nil, _event)
Widget _w;
caddr_t _nil;
XEvent *_event;
{
	int n;
	Arg warg[2];

	if (_event->type == ButtonPress)
		if (((XButtonEvent *)_event)->button == 3)
		{
			printf("Have a nice day. --JLC\n");
			exit(1);
		}
}

main(argc, argv)
int argc;
char *argv[];
{
	Widget imageViewWidget, toplevel;
	XtAppContext app;
	Display *theDisplay;
	int theScreenNumber;
	Arg warg[3];
	int n, i;
	unsigned int width, height;
	Pixmap pixmap, pixmap1bit;
	GC gc;
	int xhot, yhot;

	XtToolkitInitialize();
	app = XtCreateApplicationContext();

	theDisplay = XtOpenDisplay (app, NULL, APPNAME, APPCLASS, 
		NULL, 0, &argc, argv);

	if (!theDisplay)
	{
		printf("%s: can't open display, exiting...", APPNAME);
		return 1;
	}

	theScreenNumber = DefaultScreen(theDisplay);

	toplevel = XtAppCreateShell (APPNAME, APPCLASS,
		applicationShellWidgetClass, theDisplay, NULL, 0);


	if (XReadBitmapFile(theDisplay, RootWindow(theDisplay, theScreenNumber),
		"test.xbm", &width, &height, &pixmap1bit, &xhot, &yhot) != Success)
	{
		return 1;
	}

	gc = DefaultGC(theDisplay, theScreenNumber);

	if (DefaultDepth(theDisplay, theScreenNumber) != 1)
	{
		pixmap = XCreatePixmap(theDisplay, RootWindow(theDisplay, theScreenNumber),
			width, height, DefaultDepth(theDisplay, theScreenNumber));

		XCopyPlane(theDisplay, pixmap1bit, pixmap, gc, 0, 0, width, height, 0, 0, 1);
		XFreePixmap(theDisplay, pixmap1bit);
	}
	else
		pixmap = pixmap1bit;

	n = 0;
	XtSetArg(warg[n], XtNpixmap, pixmap); n++;
	XtSetArg(warg[n], XtNimageType, 1); n++;
	imageViewWidget = XtCreateManagedWidget("ImageView", imageViewWidgetClass, toplevel, warg, n);

	XtRealizeWidget(toplevel);

	XtAddEventHandler(imageViewWidget, ButtonPressMask, FALSE, QuitIt, NULL);

	printf("Press mouse button 3 to exit.\n");
	printf("Press mouse button 1 to select a new box.\n");

#if MOTIF
	printf("Use the <osfUp, osfDown, osfLeft, osfRight> keys to move <up, down, left, right>\n");
#else
	printf("Use the <h, j, k, l> keys to move <left, down, up, right>.\n");
#endif /* MOTIF */

	XtAppMainLoop(app);
}
