/* $Id: ImageV.c,v 1.1 1995/02/22 05:24:26 cwikla Exp $ */
/*
 * Copyright 1995 John L. Cwikla
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * Wolfram Research, Inc not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.    John L. Cwikla and Wolfram Research, Inc make no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and Wolfram Research, Inc disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * Wolfram Research, Inc be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 *  John L. Cwikla
 *  X Programmer
 *  Wolfram Research Inc.
 *
 *  cwikla@wri.com
*/

/*
** ImageView Widget
*/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#if MOTIF
#include <Xm/PrimitiveP.h>
#endif /* MOTIF */

#include "ImageVP.h"

/* For widget internals */
#if NeedFunctionProtoTypes
static void classInitialize(void);
static void initialize(ImageViewWidget _request, ImageViewWidget _new);
static void realize(ImageViewWidget _ivw, XtValueMask *_xvm, XSetWindowAttributes *_xswa);
static void resize(ImageViewWidget _ivw);
static void destroy(ImageViewWidget _ivw);
static void redisplay(ImageViewWidget _ivw, XEvent *_event, Region _region);
static Boolean setValues(ImageViewWidget _current, ImageViewWidget _request, ImageViewWidget _new);
static void drawImage(ImageViewWidget _ivw);
static void checkWindowSize(ImageViewWidget _ivw);
static Boolean cvtStringToImageType(Display *_display, XrmValuePtr _args, Cardinal *_numArgs, 
		XrmValuePtr _from, XrmValuePtr _to, XtPointer *_data);

#else
static void classInitailize();
static void initialize();
static void realize();
static void resize();
static void destroy();
static void redisplay();
static Boolean setValues();
static void drawImage();
static void checkWindowSize();
static Boolean cvtStringToImageType();
#endif /* NeedFunctionProtoTypes */

#if MOTIF
static char imageViewTranslations[] =
#if (XmREVISION >= 2)
"<Enter>:PrimitiveEnter()\n\
<Leave>:PrimitiveLeave()\n\
<FocusIn>:PrimitiveFocusIn()\n\
<FocusOut>:PrimitiveFocusOut()\n\
<Unmap>:PrimitiveUnmap()\n\
<Key>osfHelp:PrimitiveHelp()";
#else
"<FocusIn>:PrimitiveFocusIn()\n\
<FocusOut>:PrimitiveFocusOut()\n\
<Unmap>:PrimitiveUnmap()\n\
<Key>osfHelp:PrimitiveHelp()";
#endif /* XmREVISION */
#else
#define imageViewTranslations XtInheritTranslations
#endif /* MOTIF */

#define CORE(a) ((a)->core)
#define PRIM(a) ((a)->primitive)
#define IV(a) ((a)->image_view)
#define THE_GC(a) ((a)->image_view.gc)
#define WIDTH(a) ((a)->core.width)
#define HEIGHT(a) ((a)->core.height)
#define PIC(a) ((a)->image_view.picture)
#define PIC(a) ((a)->image_view.picture)
#define OWN_PIC(a) ((a)->image_view.internalPicture)
#define XIMAGE(a) ((a)->image_view.picture.ximage)
#define PIXMAP(a) ((a)->image_view.picture.pixmap)
#define IM_WIDTH(a) ((a)->image_view.imageWidth)
#define IM_HEIGHT(a) ((a)->image_view.imageHeight)
#define IN_MEM_SAVE(a) ((a)->image_view.internalMemorySave)
#define IM_TYPE(a) ((a)->image_view.picture.type)

#if MOTIF
#if (XmREVISION == 2)
extern XmPrimitiveClassExtRec _XmPrimClassExtRec;
#define LOCALPRIMITIVEEXTREC &_XmPrimClassExtRec
#else
#define LOCALPRIMITIVEEXTREC NULL
#endif
#endif /* MOTIF */

#define TheOffset(field) XtOffset(ImageViewWidget, image_view.field)

static XtResource imageViewResources[] = 
{
	{XtNsaveMemory, XtCSaveMemory, XtRBoolean, sizeof(Boolean),
		TheOffset(saveMemory), XtRImmediate, (XtPointer)FALSE},
	{XtNximage, XtCXImage, XtRPointer, sizeof(XImage *),
		TheOffset(picture.ximage), XtRImmediate, (XtPointer)NULL},
	{XtNpixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
		TheOffset(picture.pixmap), XtRImmediate, (XtPointer)0},
	{XtNimageType, XtCImageType, XtRImageType, sizeof(unsigned char),
		TheOffset(picture.type), XtRImmediate, (XtPointer)USE_UNSET},
};

#undef TheOffset

ImageViewClassRec imageViewClassRec = 
{
	{				/* CoreClassPart */
#if MOTIF
	(WidgetClass)&xmPrimitiveClassRec, /* superclass */
#else
		(WidgetClass)&widgetClassRec,	/* superclass */
#endif /* MOTIF */
		"ImageView",												/* class_name */
		sizeof(ImageViewRec),							 /* widget_size */
		NULL,													/* class_initialize */
		NULL,													/* class_part_initialize */
		FALSE,												 /* class_init */
		(XtInitProc)initialize,										/* initialize */
		NULL,													/* initialize_hook */
		(XtRealizeProc)realize,											 /* realize */
		NULL, /* imageViewActions,									 /* actions */
		0, /* XtNumber(imageViewActions),				 /* num_actions */
		imageViewResources,								 /* resources */
		XtNumber(imageViewResources),			 /* num_resources */
		NULLQUARK,										 /* xrm_class */
		TRUE,													/* compress_motion */
		XtExposeCompressMultiple |
		XtExposeGraphicsExposeMerged,													/* compress_exposure */
		TRUE,													/* compress_enterleave */
		TRUE,													/* visible_intress */
		(XtWidgetProc)destroy,											 /* destroy */
		(XtWidgetProc)resize,												/* resize */
		(XtExposeProc)redisplay,										 /* expose */
		(XtSetValuesFunc)setValues,										 /* set_values */
		NULL,													/* set_values_hook */
		XtInheritSetValuesAlmost,			/* set_values_almost */
		NULL,													/* get_values_hook */
		NULL,													/* accept_focus */
		XtVersion,										 /* version */
		NULL,													/* callback_private */
		imageViewTranslations,							/* tm_translations */
		NULL,
		NULL,
		NULL,
	},
#if MOTIF
	{
		XmInheritBorderHighlight,
		XmInheritBorderUnhighlight,
		XtInheritTranslations, 
		(XtActionProc)NULL,
		(XmSyntheticResource *)NULL,
		0,
		(XtPointer)LOCALPRIMITIVEEXTREC,
	},
#endif /* MOTIF */
	{ 
		0, /* empty */
	}
};

WidgetClass imageViewWidgetClass = (WidgetClass) &imageViewClassRec;

static void classInitialize()
{
	XtSetTypeConverter(XtRString, XtRImageType, cvtStringToImageType,
		(XtConvertArgList)NULL, 0,
		XtCacheAll, (XtDestructor)NULL);
}

static void initialize(_request, _new)
ImageViewWidget _request;
ImageViewWidget _new;
{
	Cardinal numParams = 0;

	OWN_PIC(_new).pixmap = 0;
	OWN_PIC(_new).type = USE_PIXMAP;

	IV(_new).wScale = 0.0;
	IV(_new).hScale = 0.0;

	if (IM_TYPE(_new) == USE_UNSET)
	{
		XtAppErrorMsg(XtWidgetToApplicationContext((Widget)_new),
			XtName(_new), "ximage", "NoneSpecified",
			"XtNimageType must be set to USE_PIXMAP or USE_XIMAGE", NULL, &numParams);
	}

	if (IM_TYPE(_new) == USE_XIMAGE)
	{
		if (XIMAGE(_new) == NULL)
		{
			XtAppErrorMsg(XtWidgetToApplicationContext((Widget)_new),
				XtName(_new), "ximage", "NoneSpecified",
				"XtNximage must be non-NULL", NULL, &numParams);
		}
		else
		{
			IM_WIDTH(_new) = XIMAGE(_new)->width;
			IM_HEIGHT(_new) = XIMAGE(_new)->height;
		}
	}
	else
	{
		if (PIXMAP(_new) == 0)
		{
			XtAppErrorMsg(XtWidgetToApplicationContext((Widget)_new),
				XtName(_new), "pixmap", "NoneSpecified",
				"XtNpixmap must be non-zero", NULL, &numParams);
		}
		else		
		{
			Window root;
			int x, y;
			unsigned int borderWidth, depth;
			XGetGeometry(XtDisplay(_new), PIXMAP(_new), &root, &x, &y, &IM_WIDTH(_new), 
				&IM_HEIGHT(_new), &borderWidth, &depth);
		}
		
	}

	if (WIDTH(_request) == 0)
	{
		WIDTH(_new) = IM_WIDTH(_new);
#if MOTIF
		WIDTH(_new) += 2 * PRIM(_new).shadow_thickness;
#endif /* MOTIF */
	}
	if (HEIGHT(_request) == 0)
	{
		HEIGHT(_new) = IM_HEIGHT(_new);
#if MOTIF
		HEIGHT(_new) += 2 * PRIM(_new).shadow_thickness;
#endif /* MOTIF */
	}

	THE_GC(_new) = XtGetGC((Widget)_new, 0, NULL);
}

/*
** NOT THREAD SAFE!!!!!
*/

static Boolean PixmapAllocError = False ;

static int pixmapErrorHandler(_dpy, _error)
Display *_dpy;
XErrorEvent *_error;
{
		PixmapAllocError = True;
}

Pixmap _createPixmap(_dpy, _drawable, _width, _height, _depth)
Display *_dpy;
Drawable _drawable;
unsigned int _width;
unsigned int _height;
unsigned int _depth;
{
	Pixmap thePixmap;
	Drawable root;
	int x, y;
	unsigned int rw, rh,bw,rd;
	XErrorHandler	 oldHandler = NULL;

	if (_width < 0)
		_width = 1;

	if (_height < 0)
		_height = 1;

	PixmapAllocError = False;
	/* install our error handler */
	oldHandler = XSetErrorHandler(pixmapErrorHandler);
	/* attempt to create pixmap */
	thePixmap = XCreatePixmap(_dpy, _drawable, _width, _height, _depth);
	XGetGeometry(_dpy, thePixmap, &root, &x, &y, &rw, &rh, &bw, &rd);
	/* wait to see if server allocated pixmap */
	XSync(_dpy, False);
	/* restore standard error handler */
	XSetErrorHandler(oldHandler);

	return	PixmapAllocError? (Pixmap)NULL : thePixmap;
}

static void realize(_ivw, _xvm, _xswa)
ImageViewWidget _ivw;
XtValueMask *_xvm;
XSetWindowAttributes *_xswa;
{
	XGCValues gcValues;
	XRectangle xrect;

/* Call the Realize procedure (XtInheritRealize) */

	(*imageViewWidgetClass->core_class.superclass->core_class.realize)((Widget)_ivw, _xvm, _xswa);


	checkWindowSize(_ivw);
}


static void resize(_ivw)
ImageViewWidget _ivw;
{
	if (XtIsRealized(_ivw))
	{
		checkWindowSize(_ivw);
		XClearArea(XtDisplay(_ivw), XtWindow(_ivw), 0, 0, 
			WIDTH(_ivw), HEIGHT(_ivw), FALSE);
	}
}

static void destroy(_ivw)
ImageViewWidget _ivw;
{
	if (OWN_PIC(_ivw).pixmap != 0)
		XFreePixmap(XtDisplay(_ivw), OWN_PIC(_ivw).pixmap);
	XtReleaseGC((Widget)_ivw, THE_GC(_ivw));
}


static void redisplay(_ivw, _event, _region)
ImageViewWidget _ivw; 
XEvent *_event; 
Region _region;
{
	drawImage(_ivw);
}

static Boolean setValues(_current, _request, _new)
ImageViewWidget _current; 
ImageViewWidget _request; 
ImageViewWidget _new;
{
	checkWindowSize(_new);
	return TRUE;
}

#if 1
#define PCOPY(dpy, pic, draw, _gc, a,b,c,d,e,f) \
	if ((pic).type == USE_XIMAGE) \
		XPutImage(dpy, draw, _gc, (pic).ximage, \
			(int)(a), (int)(b), (int)(c), (int)(d), (unsigned int)(e), (unsigned int)(f)); \
	else \
		XCopyArea(dpy, (pic).pixmap, draw, _gc, \
			(int)(a),(int)(b),(unsigned int)(e),(unsigned int)(f),(int)(c),(int)(d))

#else
#define PCOPY pcopy
void pcopy(_dpy, _pic, _draw, _gc, _srcX, _srcY, _destX, _destY, _width, _height)
Display *_dpy;
IVPicture _pic;
Drawable _draw;
GC _gc;
int _srcX, _srcY, _destX, _destY;
unsigned int _width, _height;
{
		if (_pic.type == USE_XIMAGE)
				XPutImage(_dpy, _draw, _gc, _pic.ximage,
						(int)(_srcX), (int)(_srcY), (int)(_destX), (int)(_destY), 
				(unsigned int)(_width), (unsigned int)(_height));
		else 
				XCopyArea(_dpy, _pic.pixmap, _draw, _gc,
						(int)_srcX,(int)_srcY,(unsigned int)_width,(unsigned int)_height,
				_destX, _destY);
}
#endif /* 0 */

static void drawImage(_ivw)
ImageViewWidget _ivw;
{
	unsigned int i, j;
	Dimension width, height;
	Position x, y;

#if MOTIF
	width = WIDTH(_ivw) - 2 * PRIM(_ivw).highlight_thickness;
	height = HEIGHT(_ivw) - 2 * PRIM(_ivw).highlight_thickness;
	y = x = PRIM(_ivw).highlight_thickness;
#else
	width = WIDTH(_ivw);
	height = HEIGHT(_ivw);
	y = x = 0;
#endif /* MOTIF */

	if (!width || !height)
		return;

	if ( (width == IM_WIDTH(_ivw)) && (height == IM_HEIGHT(_ivw)))
	{
		PCOPY(XtDisplay(_ivw), PIC(_ivw), XtWindow(_ivw), THE_GC(_ivw), 
			0, 0, x, y, IM_WIDTH(_ivw), IM_HEIGHT(_ivw));
		return;
	}

	if (width == IM_WIDTH(_ivw))
	{
		for(j=0;j<height;j++)
		{
			PCOPY(XtDisplay(_ivw), PIC(_ivw), XtWindow(_ivw), THE_GC(_ivw), 
				0, (int)(j*IV(_ivw).hScale), x, j+y, width, 1);
		}
		return;
	}

	if (height == IM_HEIGHT(_ivw))
	{
		for(i=0;i<width;i++)
		{
			PCOPY(XtDisplay(_ivw), PIC(_ivw), XtWindow(_ivw), THE_GC(_ivw), 
				(int)(i*IV(_ivw).wScale), 0, i+x, y, 1, height);
		}
		return;
	}

	if (!IN_MEM_SAVE(_ivw))
	{
		for(i=0;i<width;i++)
			PCOPY(XtDisplay(_ivw), PIC(_ivw), OWN_PIC(_ivw).pixmap, THE_GC(_ivw),
				(int)(i*IV(_ivw).wScale), 0, i, 0, 1, IM_HEIGHT(_ivw));

		height = (IM_HEIGHT(_ivw) > height) ? IM_HEIGHT(_ivw) : height;
		for(j=0;j<height;j++)
			PCOPY(XtDisplay(_ivw), OWN_PIC(_ivw), XtWindow(_ivw), THE_GC(_ivw),
				0, (int)(j * IV(_ivw).hScale), x, j+y, width, 1);
	}
	else
	{
		for(j=0;j<height;j++)
			for(i=0;i<width;i++)
			{
				PCOPY(XtDisplay(_ivw), PIC(_ivw), XtWindow(_ivw), THE_GC(_ivw),
					(int)(i*IV(_ivw).wScale), (int)(j*IV(_ivw).hScale), i+x, j+y, 1, 1);
			}
	}
}

static void checkWindowSize(_ivw)
ImageViewWidget _ivw;
{
	unsigned int height;

	IV(_ivw).wScale = (double)IM_WIDTH(_ivw)/(double)WIDTH(_ivw);
		IV(_ivw).hScale = (double)IM_HEIGHT(_ivw)/(double)HEIGHT(_ivw);

	if (OWN_PIC(_ivw).pixmap != 0)
		XFreePixmap(XtDisplay(_ivw), OWN_PIC(_ivw).pixmap);

	OWN_PIC(_ivw).pixmap = 0;

	if (!IV(_ivw).saveMemory && (IM_WIDTH(_ivw) != WIDTH(_ivw)) &&
			(IM_HEIGHT(_ivw) != HEIGHT(_ivw)))
	{
		height = (IM_HEIGHT(_ivw) > HEIGHT(_ivw)) ? IM_HEIGHT(_ivw) :	HEIGHT(_ivw);
		OWN_PIC(_ivw).type = USE_PIXMAP;
		OWN_PIC(_ivw).pixmap = _createPixmap(XtDisplay(_ivw), XtWindow(_ivw),
			WIDTH(_ivw), height, CORE(_ivw).depth);
	}

	if (OWN_PIC(_ivw).pixmap == 0)
		IN_MEM_SAVE(_ivw) = TRUE;
	else
		IN_MEM_SAVE(_ivw) = FALSE;
}

static void Lower(_st1, _st2, _length)
char *_st1;
char *_st2;
int _length;
{
	int i;
	char *ptr;

	for(ptr=_st1,i=0;(ptr!=NULL) && (i<_length);ptr++,i++)
		*(_st2+i) = tolower(*ptr);
}

static Boolean cvtStringToImageType(_display, _args, _numArgs, _from, _to, _data)
Display *_display;
XrmValuePtr _args;
Cardinal *_numArgs;
XrmValuePtr _from;
XrmValuePtr _to;
XtPointer *_data;
{
	char *lower;
	static unsigned char imageType;
	Boolean badConversion = FALSE;

	if (*_numArgs != 0)
	{
		XtErrorMsg("cvtStringToImageType", "wrongParamaters",
		"ImageView",
		"cvtStringToImageType needs no arguments.",
		(String *)NULL, (Cardinal *)NULL);
	}

	lower = XtNewString(_from->addr);
	Lower(_from->addr, lower, strlen(_from->addr));

	imageType = USE_UNSET;
	if (!strcmp(lower, "use_ximage"))
		imageType = USE_XIMAGE;
	else
	if (!strcmp(lower, "ximage"))
		imageType = USE_XIMAGE;
	else
	if (!strcmp(lower, "use_pixmap"))
		imageType = USE_PIXMAP;
	else
	if (!strcmp(lower, "pixmap"))
		imageType = USE_PIXMAP;
	else
		badConversion = TRUE;

	XtFree(lower);

	if (badConversion)
		XtDisplayStringConversionWarning(_display, _from->addr, XtRImageType);
	else
	{
		if (_to->addr == NULL)
			_to->addr = (caddr_t)&imageType;
		else
		if (_to->size < sizeof(unsigned char))
			badConversion = TRUE;
		else
			*(unsigned char *)_to->addr = imageType;
			_to->size = sizeof(unsigned char);
	}

	return !badConversion;
}

