static char rcsid[] = "$Id: pixmap.c,v 1.5 1999/08/26 17:20:51 falk Exp $" ;

/* This function converts a file name to a pixmap.  Pixmaps can
 * be cached as long as the display and colormap match.
 *
 * Requires libxpm
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/CharSet.h>

#include <X11/Xmu/Converters.h>
#include <X11/Xmu/CharSet.h>

#include <X11/xpm.h>

#include "pixmap.h"



static	PixmapInfo	*cache = NULL ;
static	PixmapInfo	*lastCache = NULL ;



static	Bool
cacheMatch(dpy, cmap, depth, name, info)
    Display	*dpy ;
    Colormap	cmap ;
    u_int	depth ;
    char	*name ;
    PixmapInfo	*info ;
{
    return info->dpy == dpy  &&
	   info->cmap == cmap &&
	   info->depth == depth &&
	   strcmp(info->name, name) == 0  ;
}



static	PixmapInfo *
findCache(dpy, cmap, depth, name)
    Display	*dpy ;
    Colormap	cmap ;
    u_int	depth ;
    char	*name ;
{
    PixmapInfo	*ptr ;

    if( lastCache != NULL  && cacheMatch(dpy,cmap,depth,name, lastCache) )
      return lastCache ;

    for(ptr = cache; ptr != NULL; ptr = ptr->next)
      if( cacheMatch(dpy,cmap,depth,name, ptr) )
	return lastCache = ptr ;

    return NULL ;
}


	/* try to read one pixmap */

static	Pixmap
getPixmap1(dpy, cmap, win, depth, name, atts, mask)
    Display	*dpy ;
    Colormap	cmap ;
    Window	win ;
    u_int	depth ;
    char	*name ;
    XpmAttributes *atts ;
    Pixmap	*mask ;
{
    Pixmap	rval ;

    atts->colormap = cmap ;
    atts->depth = depth ;
    atts->closeness = 65536 ;
    atts->valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness ;
    if( XpmReadFileToPixmap(dpy, win, name, &rval, mask, atts) != 0 )
      return None ;
    else
      return rval ;
}



	/* This function is the meat of this module.  Search the
	 * cache for a pixmap matching (dpy,cmap,depth,name).  If
	 * not found, create one, add to the cache and return.
	 */

PixmapInfo *
GetPixmap(dpy, cmap, win, depth, path, name)
    Display	*dpy ;
    Colormap	cmap ;
    Window	win ;
    u_int	depth ;
    char	*path ;
    char	*name ;
{
    Pixmap	pixmap, mask ;
    PixmapInfo	*rval ;
    XpmAttributes atts ;
    char	*ptmp, *ppart ;
    char	fullname[MAXPATHLEN] ;

    if( strcasecmp(name, "none") == 0 )
      return None ;

    if( (rval = findCache(dpy,cmap,depth, name)) != NULL )
    {
      ++rval->refcnt ;
      return rval ;
    }


    /* Nutz, try to load it from disk */

    if( path == NULL ) path = ".:bitmaps:Bitmaps:pixmaps:Pixmaps" ;

    ptmp = strdup(path) ;
    ppart = strtok(ptmp, ":") ;

    do {
      strncpy(fullname, ppart, sizeof(fullname)-1) ;
      strncat(fullname, "/", sizeof(fullname)-1) ;
      strncat(fullname, name, sizeof(fullname)-1) ;

      if( (pixmap = getPixmap1(dpy,cmap,win,depth, fullname, &atts, &mask))
      		!= None )
      {
	rval = (PixmapInfo *)malloc(sizeof(PixmapInfo)) ;
	rval->width = atts.width ;
	rval->height = atts.height ;
	rval->depth = atts.depth ;
	rval->pixmap = pixmap ;
	rval->mask = mask ;
	rval->dpy = dpy ;
	rval->cmap = cmap ;
	rval->name = strdup(name) ;
	rval->next = cache ; lastCache = cache = rval ;
	rval->refcnt = 1 ;
      }
    } while( pixmap == None && (ppart = strtok(NULL, ":")) != NULL ) ;

    free(ptmp) ;
    return rval ;
}



	/* Search the cache for a pixmap */

PixmapInfo *
GetPixmapInfo(dpy, pixmap)
    Display	*dpy ;
    Pixmap	pixmap ;
{
    PixmapInfo	*ptr ;
    Window	root ;
    int		x,y ;
    u_int	wid,hgt,bwid,depth ;

    if( lastCache != NULL  && 
	lastCache->dpy == dpy && lastCache->pixmap == pixmap )
    {
      ++lastCache->refcnt ;
      return lastCache ;
    }

    for(ptr = cache; ptr != NULL; ptr = ptr->next)
      if( ptr->dpy == dpy && ptr->pixmap == pixmap )
      {
	++ptr->refcnt ;
	return lastCache = ptr ;
      }

    /* Not found, get the details from the server */

    if( !XGetGeometry(dpy, pixmap, &root,&x,&y, &wid,&hgt,&bwid,&depth) )
      return NULL ;

    ptr = (PixmapInfo *)malloc(sizeof(PixmapInfo)) ;
    ptr->width = wid ;
    ptr->height = hgt ;
    ptr->depth = depth ;
    ptr->pixmap = pixmap ;
    ptr->mask = None ;
    ptr->dpy = dpy ;
    ptr->cmap = None ;
    ptr->name = NULL ;
    ptr->next = cache ; lastCache = cache = ptr ;
    ptr->refcnt = 1 ;

    return ptr ;
}





void
ReleasePixmap(info)
    PixmapInfo	*info ;
{
    Display	*dpy = info->dpy ;
    PixmapInfo	*ptr, *ptr0 ;

    if( info == NULL ) return ;

    if( --info->refcnt <= 0 )
    {
      for(ptr0 = NULL, ptr = cache; ptr != NULL; ptr0=ptr, ptr = ptr->next)
	if( ptr == info )
	{
	  if( ptr0 == NULL ) cache = ptr->next ;
	  else ptr0->next = ptr->next ;
	  if( ptr->pixmap != None ) XFreePixmap(dpy, ptr->pixmap) ;
	  if( ptr->mask != None ) XFreePixmap(dpy, ptr->mask) ;
	  if( ptr->name != NULL ) free(ptr->name) ;
	  free(ptr) ;
	  return ;
	}
    }
}






typedef	struct {String path1, path2 ;} Paths ;

static XtResource resources[] = {
  {XtNpixDir, XtCPixDir, XtRString, sizeof(String),
    XtOffsetOf(Paths, path1), XtRString, NULL},
  {XtNbitmapFilePath, XtCBitmapFilePath, XtRString, sizeof(String),
    XtOffsetOf(Paths, path2), XtRString,
    "/usr/include/X11/bitmaps:/usr/include/X11/pixmaps"} } ;




static	Boolean
cvtStringToPixmap(dpy, args, nargs, fromVal, toVal, data)
  Display	*dpy ;
  XrmValuePtr	args ;
  Cardinal	*nargs ;
  XrmValuePtr	fromVal ;
  XrmValuePtr	toVal ;
  XtPointer	*data ;
{
  Widget	w = (Widget)args[0].addr ;
  Window	win = XtWindow(w) ;
  Colormap	cmap = w->core.colormap ;
  u_int		depth = w->core.depth ;
  String	name = (String)fromVal->addr ;
  Paths		paths ;
  static Pixmap	rval ;
  PixmapInfo	*info ;

  if( name == NULL || strcasecmp(name, "None") == 0 ) {
    rval = XtUnspecifiedPixmap ;
    info = NULL ;
  }
  else
  {
    if( !XtIsRealized(w) )	/* not realized; make a guess */
      win = RootWindowOfScreen(XtScreen(w)) ;

    XtGetSubresources(w, (XtPointer)&paths, NULL,NULL,
      resources, XtNumber(resources), NULL,0 ) ;

    info = GetPixmap(dpy, cmap, win, depth, paths.path1, name) ;
    if( info == NULL && paths.path2 != NULL )
      info = GetPixmap(dpy, cmap, win, depth, paths.path2, name) ;


    if( info == NULL || (rval = info->pixmap) == None ) {
      XtStringConversionWarning(fromVal->addr, XtRPixmap) ;
      return False ;
    }
    else {
      /* this is a bit kludgy.  The widget will be calling GetPixmapInfo()
       * to get this pixmap (and to free it later).  That will bump the
       * reference count; so we pre-decrement it now.
       */
      --info->refcnt ;
    }
  }


  if( toVal->addr != NULL )
  {
    if( toVal->size < sizeof(Pixmap) ) {
      toVal->size = sizeof(Pixmap) ;
      return False ;
    }
    else
      *((Pixmap *)toVal->addr) = rval ;
  }
  else
    toVal->addr = (XtPointer) &rval ;
  toVal->size = sizeof(rval) ;

  *data = (XtPointer)info ;
  return True ;
}




void
RegisterCvtStringToPixmap()
{
  XtConvertArgRec args[] = {
    {XtWidgetBaseOffset, (XtPointer)0, sizeof(Widget)} } ;

  XtSetTypeConverter(XtRString, XtRPixmap, cvtStringToPixmap,
    args, XtNumber(args), XtCacheNone, NULL) ;
}
