/* $Id: XpmButtonP.h,v 1.3 1999/08/26 17:21:19 falk Exp $
 *
 * XpmButtonP.h - Private definitions of XpmButton widget
 */

#ifndef _XPMBUTTONP_H
#define _XPMBUTTONP_H

#include "pixmap.h"
#include "ButtonP.h"
#include "XpmButton.h"


typedef struct _XpmButtonClass {
    XtPointer	extension ;
} XpmButtonClassPart;

   /* Full class record declaration */
typedef struct _XpmButtonClassRec {
    CoreClassPart	core_class;
    ButtonClassPart	button_class;
    XpmButtonClassPart	xpmbutton_class;
} XpmButtonClassRec;

extern	XpmButtonClassRec	xpmbuttonClass;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

	/* background plus eight states of the button */

#define	BG		0
#define	UNSET		1
#define	HIGHLIT		2
#define	ARMED		3
#define	SET		4
#define	SETHIGHLIT	5
#define	SETARMED	6
#define	INSENSITIVE	7
#define	SETINSENSITIVE	8


    /* New fields for the XpmButton widget record */
typedef struct {
    /* resources */
    Pixmap	bgPixmap ;		/* background pixmap */
    Pixmap	unsetPixmap ;		/* when not set */
    Pixmap	hlPixmap ;		/* when highlit */
    Pixmap	armPixmap ;		/* when mouse button pressed */
    Pixmap	setPixmap ;		/* when set */
    Pixmap	setHlPixmap ;		/* when highlit and set */
    Pixmap	setArmPixmap ;		/* when mouse button pressed */
    Pixmap	insenPixmap ;		/* when widget insensitive */
    Pixmap	setInsenPixmap ;	/* when widget insensitive */
    Pixmap	shapeMask ;		/* shape bitmap */

    /* private state */
    PixmapInfo	*pixmaps[9] ;
    GC		gcs[9] ;
    GC		grey50 ;
    Dimension	pwid, phgt ;	/* max pixmap size */
    Boolean	shapeExt ;	/* shape extension available */
} XpmButtonPart;



   /* Full widget declaration */
typedef struct _XpmButtonRec {
    CorePart		core;
    ButtonPart		button;
    XpmButtonPart	xpmbutton;
} XpmButtonRec;

#endif /* _XPMBUTTONP_H */


