/*
 * $Id: XpmButton.h,v 1.3 1999/08/26 17:21:19 falk Exp $
 *
 * This is a "generic" xpmbutton widget
 */


#ifndef	XPMBUTTON_H
#define	XPMBUTTON_H

#include "Button.h"

/* XpmButton widget resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 pixDir		     PixDir		String		".:bitmaps:Bitmaps"
 pixmapName	     BGPixmap		Pixmap		XtUnspecifiedPixmap
 unsetPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 hlPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 armPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 setPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 setHlPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 setArmPixmap	     Pixmap		Pixmap		XtUnspecifiedPixmap
 insensitivePixmap   Pixmap		Pixmap		XtUnspecifiedPixmap
 setInsensitivePixmap Pixmap		Pixmap		XtUnspecifiedPixmap
 shapeMask	     ShapeMask		Pixmap		XtUnspecifiedPixmap

 	inherited from Button widget:
 set		     Set		Boolean		False
 switchType	     SwitchType		SwitchType	MomentaryOn
 foreground	     Foreground		Pixel		grey
 callback	     Callback		XtCallbackList	NULL
 beNiceToColormap    BeNiceToColormap	Boolean		False
 topShadowContrast   TopShadowContrast	int		20
 bottomShadowContrast BottomShadowContrast int		40

*/


/*
 * pixDir is the ':'-seperated path of places to search for pixmaps
 * pixmapName is the name of the background pixmap.
 * unsetPixmap is the name of the pixmap to display when widget is unset
 * armPixmap is the name of the pixmap to display when widget is "armed"
 * setPixmap is the name of the pixmap to display when widget is set
 * setArmPixmap is the pixmap when widget is set and armed
 * hlPixmap is the name of the pixmap to display when widget is highlit
 * setHlPixmap is the the pixmap to display when widget is highlit and set
 * shapeMask is the bitmap to be used for the overall shape mask of the widget.
 */

#ifndef	XtNpixDir
#define	XtNpixDir	"pixDir"
#define	XtCPixDir	"PixDir"
#endif

#ifndef	XtNpixmapName
#define	XtNpixmapName	"pixmapName"
#define	XtCPixmapName	"PixmapName"
#endif

#ifndef	XtNsetPixmap
#define	XtNunsetPixmap	"unsetPixmap"
#define	XtNhlPixmap	"hlPixmap"
#define	XtNarmPixmap	"armPixmap"
#define	XtNsetPixmap	"setPixmap"
#define	XtNsetHlPixmap	"setHlPixmap"
#define	XtNsetArmPixmap	"setArmPixmap"
#define	XtNinsensitivePixmap "insensitivePixmap"
#define	XtNsetInsensitivePixmap "setInsensitivePixmap"

#define	XtNshapeMask	"shapeMask"
#define	XtCShapeMask	"ShapeMask"

#endif


extern	WidgetClass	xpmButtonWidgetClass;

typedef	struct	_XpmButtonClassRec	*XpmButtonWidgetClass;
typedef	struct	_XpmButtonRec	*XpmButtonWidget;

#endif	/* XPMBUTTON_H */
