static char rcsid[] = "$Id: XpmButton.c,v 1.4 1999/08/26 17:21:44 falk Exp $";

/*
 * XpmButton.c - XpmButton widget
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/extensions/shape.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>

#include <X11/xpm.h>

#include "XpmButtonP.h"
#include "pixmap.h"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffsetOf(XpmButtonRec, xpmbutton.field)
static XtResource resources[] = {
  {XtNpixmapName, XtCPixmapName, XtRPixmap, sizeof(Pixmap),
      offset(bgPixmap), XtRImmediate, (XtPointer)None},
  {XtNunsetPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(unsetPixmap), XtRImmediate, (XtPointer)None},
  {XtNhlPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(hlPixmap), XtRImmediate, (XtPointer)None},
  {XtNarmPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(armPixmap), XtRImmediate, (XtPointer)None},
  {XtNsetPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(setPixmap), XtRImmediate, (XtPointer)None},
  {XtNsetHlPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(setHlPixmap), XtRImmediate, (XtPointer)None},
  {XtNsetArmPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(setArmPixmap), XtRImmediate, (XtPointer)None},
  {XtNinsensitivePixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(insenPixmap), XtRImmediate, (XtPointer)None},
  {XtNsetInsensitivePixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
      offset(setInsenPixmap), XtRImmediate, (XtPointer)None},
  {XtNshapeMask, XtCShapeMask, XtRBitmap, sizeof(Pixmap),
      offset(shapeMask), XtRImmediate, NULL},
};
#undef offset

	/* class methods */

static	void	XpmButtonClassInit();
static	void	XpmButtonInit(), XpmButtonRealize() ;
static	XtGeometryResult XpmButtonQueryGeometry() ;
static	void	XpmButtonExpose() ;
static	Boolean XpmButtonSet();
static	void	XpmButtonDestroy() ;
static	void	XpmButtonChangeState() ;

	/* converters */


	/* private */

static	void	xpmbuttonDraw() ;
static	void	xpmbuttonGetPixmapInfo() ;
static	void	xpmbuttonGetGcs() ;
static	void	xpmbuttonFreeGcs() ;
static	void	replaceGC() ;

static	PixmapInfo *xpmGetPixmap() ;
static	GC	xpmMakeGc() ;


#define SuperClass ((ButtonWidgetClass)&buttonClassRec)

XpmButtonClassRec xpmbuttonClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		*/
    "XpmButton",			/* class_name		*/
    sizeof(XpmButtonRec),		/* size			*/
    XpmButtonClassInit,			/* class_initialize	*/
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		*/
    XpmButtonInit,			/* initialize		*/
    NULL,				/* initialize_hook	*/
    XpmButtonRealize,			/* realize		*/
    NULL,				/* actions		*/
    0,					/* num_actions		*/
    resources,				/* resources		*/
    XtNumber(resources),		/* resource_count	*/
    NULLQUARK,				/* xrm_class		*/
    FALSE,				/* compress_motion	*/
    TRUE,				/* compress_exposure	*/
    TRUE,				/* compress_enterleave	*/
    FALSE,				/* visible_interest	*/
    XpmButtonDestroy,			/* destroy		*/
    XtInheritResize,			/* resize		*/
    XpmButtonExpose,			/* expose		*/
    XpmButtonSet,			/* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_values_hook	*/
    NULL,				/* accept_focus		*/
    XtVersion,				/* version		*/
    NULL,				/* callback_private	*/
    XtInheritTranslations,		/* tm_table		*/
    XpmButtonQueryGeometry,		/* query_geometry	*/
    XtInheritDisplayAccelerator,	/* display_accelerator	*/
    NULL				/* extension		*/
  },  /* CoreClass fields initialization */
  {
    XpmButtonChangeState,		/* change_state		*/
    NULL,				/* extension		*/
  },  /* ButtonClass fields initialization */
  {
    NULL,				/* extension		*/
  },  /* XpmButtonClass fields initialization */
};

  /* for public consumption */
WidgetClass xpmButtonWidgetClass = (WidgetClass) &xpmbuttonClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/


static	void
XpmButtonClassInit()
{
  SuperClass->core_class.class_initialize() ;
  RegisterCvtStringToPixmap() ;
}



/* ARGSUSED */
static void
XpmButtonInit(request, new, args, num_args)
    Widget	request, new;
    ArgList	args;
    Cardinal	*num_args;
{
    XpmButtonWidget bw = (XpmButtonWidget) new;
    int		i ;

    for(i=BG; i<=SETINSENSITIVE; ++i) {
      bw->xpmbutton.gcs[i] = NULL ;
      bw->xpmbutton.pixmaps[i] = NULL ;
    }
    bw->xpmbutton.grey50 = NULL ;
    bw->xpmbutton.pwid = bw->xpmbutton.phgt = 0 ;

    if( request->core.width == 0 || request->core.height == 0 )
    {
      xpmbuttonGetPixmapInfo(bw) ;
      if( request->core.width == 0 )
	new->core.width = bw->xpmbutton.pwid ;
      if( request->core.height == 0 )
	new->core.height = bw->xpmbutton.phgt ;
    }
}

static	void
XpmButtonRealize(w, valueMask, attributes)
    Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    XpmButtonWidget bw = (XpmButtonWidget)w ;
    int	evb, erb ;

    SuperClass->core_class.realize(w, valueMask, attributes);
    xpmbuttonGetGcs((XpmButtonWidget)w) ;

    bw->xpmbutton.shapeExt = XShapeQueryExtension(XtDisplay(w), &evb, &erb) ;

    if( bw->xpmbutton.shapeMask != None  &&  bw->xpmbutton.shapeExt )
      XShapeCombineMask(XtDisplay(w),XtWindow(w), ShapeBounding, 0,0,
	bw->xpmbutton.shapeMask, ShapeSet);

#ifdef	COMMENT
    if( bw->xpmbutton.bgPixmap != None &&
        bw->xpmbutton.bgPixmap != XtUnspecifiedPixmap )
      XSetWindowBackground(XtDisplay(w), XtWindow(w), bw->xpmbutton.bgPixmap) ;
#endif	/* COMMENT */
}


static	XtGeometryResult
XpmButtonQueryGeometry(w, intended, preferred)
    Widget	w ;
    XtWidgetGeometry *intended, *preferred;
{
    XpmButtonWidget bw = (XpmButtonWidget)w ;
    int iw = intended->width ;
    int ih = intended->height ;
    int	pw = bw->xpmbutton.pwid ;
    int	ph = bw->xpmbutton.phgt ;

    preferred->request_mode = CWWidth | CWHeight;
    preferred->width = pw ;
    preferred->height = ph ;

    /* Reject if intended is too small.  Reject if already that size.
     * Accept if intended matches preferred.  Say "almost" if intended
     * is too big.
     */

    if( ((intended->request_mode & CWWidth) && iw < pw)  ||
        ((intended->request_mode & CWHeight) && ih < ph) )
      return XtGeometryNo ;

    if( (!(intended->request_mode & CWWidth) || iw == w->core.width)  &&
        (!(intended->request_mode & CWHeight) || ih == w->core.height) )
      return XtGeometryNo ;

    if( (!(intended->request_mode & CWWidth) || iw == pw)  &&
        (!(intended->request_mode & CWHeight) || ih == ph) )
      return XtGeometryYes ;

    return XtGeometryAlmost ;
}


static	short
xpmChoose(bw, list)
    XpmButtonWidget bw ;
    short	*list ;
{
    while( *list != BG && (bw->xpmbutton.pixmaps[*list] == NULL ||
			   bw->xpmbutton.gcs[*list] == NULL) )
      ++list ;
    return *list ;
}


	/* given the state, choose which pixmap/gc combination to use */

static	int
xpmChooseGc(bw, state)
    XpmButtonWidget	bw ;
    unsigned int	state ;
{
    int	idx ;

    /* The following info is used to select pixmap & gc for the various
     * button states.  It is needed because the resources may not contain
     * pixmap specifications for all eight states.  Each list is a list
     * of pixmaps to display for the given state, in preference order.
     */
    static short unsetList[] = {UNSET, HIGHLIT, ARMED, INSENSITIVE, SET, BG} ;
    static short hlList[] = {HIGHLIT, UNSET, ARMED, SET, INSENSITIVE, BG} ;
    static short armList[] = {ARMED, HIGHLIT, UNSET, SET, INSENSITIVE, BG} ;
    static short setList[] = {SET, SETHIGHLIT, SETARMED, SETINSENSITIVE, BG} ;
    static short setHlList[] = {SETHIGHLIT, SET, SETARMED, SETINSENSITIVE, BG} ;
    static short setArmList[] = {SETARMED, SETHIGHLIT, SET, SETINSENSITIVE, BG};
    static short insenList[] = {INSENSITIVE, UNSET, HIGHLIT, ARMED, SET, BG} ;
    static short setInsList[] = {SETINSENSITIVE, SET, SETHIGHLIT, SETARMED, BG};

    switch( state ) {
      case Unset: idx = xpmChoose(bw, unsetList) ; break ;
      case Highlit: idx = xpmChoose(bw, hlList) ; break ;
      case Armed: idx = xpmChoose(bw, armList) ; break ;
      case Set: idx = xpmChoose(bw, setList) ; break ;
      case SetHighlit: idx = xpmChoose(bw, setHlList) ; break ;
      case SetArmed: idx = xpmChoose(bw, setArmList) ; break ;
      case Insensitive: idx = xpmChoose(bw, insenList) ; break ;
      case SetInsensitive: idx = xpmChoose(bw, setInsList) ; break ;
      default:
	state &= Set ;
	return xpmChooseGc(bw, state) ;		/* try again */
    }

    return idx ;
}

/* ARGSUSED */
static	void
XpmButtonExpose(w, event, region)
    Widget	w;
    XEvent	*event;
    Region	region;
{
    XpmButtonWidget bw = (XpmButtonWidget)w ;
    int		idx = xpmChooseGc(bw, bw->button.state) ;

    xpmbuttonDraw(bw, idx) ;
}


/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean
XpmButtonSet(current, request, new, args, num_args)
  Widget current, request, new;
  ArgList args;
  Cardinal *num_args;
{
  XpmButtonWidget oldbw = (XpmButtonWidget) current;
  XpmButtonWidget bw = (XpmButtonWidget) new;
  Boolean redisplay = False;

  if( oldbw->xpmbutton.bgPixmap != bw->xpmbutton.bgPixmap ) {
    replaceGC(bw, BG, bw->xpmbutton.bgPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.unsetPixmap != bw->xpmbutton.unsetPixmap ) {
    replaceGC(bw, UNSET, bw->xpmbutton.unsetPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.hlPixmap != bw->xpmbutton.hlPixmap ) {
    replaceGC(bw, HIGHLIT, bw->xpmbutton.hlPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.armPixmap != bw->xpmbutton.armPixmap ) {
    replaceGC(bw, ARMED, bw->xpmbutton.armPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.setPixmap != bw->xpmbutton.setPixmap ) {
    replaceGC(bw, SET, bw->xpmbutton.setPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.setHlPixmap != bw->xpmbutton.setHlPixmap ) {
    replaceGC(bw, SETHIGHLIT, bw->xpmbutton.setHlPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.setArmPixmap != bw->xpmbutton.setArmPixmap ) {
    replaceGC(bw, SETARMED, bw->xpmbutton.setArmPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.insenPixmap != bw->xpmbutton.insenPixmap ) {
    replaceGC(bw, INSENSITIVE, bw->xpmbutton.insenPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.setInsenPixmap != bw->xpmbutton.setInsenPixmap ){
    replaceGC(bw, SETINSENSITIVE, bw->xpmbutton.setInsenPixmap) ;
    redisplay = True ;
  }

  if( oldbw->xpmbutton.shapeMask != bw->xpmbutton.shapeMask  &&
      bw->xpmbutton.shapeExt )
    XShapeCombineMask(XtDisplay(new),XtWindow(new), ShapeBounding, 0,0,
	bw->xpmbutton.shapeMask, ShapeSet);

  return redisplay;
}


static	void
XpmButtonDestroy(w)
  Widget w;
{
  XpmButtonWidget bw = (XpmButtonWidget) w;
  xpmbuttonFreeGcs(bw) ;
}



static	void
XpmButtonChangeState(w,old,new)
  Widget	w ;
  unsigned int	old, new ;
{
  XpmButtonWidget bw = (XpmButtonWidget) w;
  int	oidx = xpmChooseGc(bw, old) ;
  int	nidx = xpmChooseGc(bw, new) ;

  if( nidx != oidx ) {
    XClearWindow(XtDisplay(w), XtWindow(w)) ;
    xpmbuttonDraw(bw, nidx) ;
  }
}





	/* Private utilities */


static	void
xpmbuttonDraw(bw, idx)
    XpmButtonWidget bw ;
    int		idx ;
{
    Widget	w = (Widget)bw ;
    Display *dpy = XtDisplay(w) ;
    Window win = XtWindow(w) ;

    if( bw->xpmbutton.pixmaps[BG] != NULL )
      XCopyArea(dpy,bw->xpmbutton.pixmaps[BG]->pixmap,win,
      	bw->xpmbutton.gcs[BG], 0,0, w->core.width, w->core.height, 0,0) ;

    if( idx != BG )
    {
      XCopyArea(dpy,bw->xpmbutton.pixmaps[idx]->pixmap,win,
        bw->xpmbutton.gcs[idx],
	0,0, bw->xpmbutton.pwid, bw->xpmbutton.phgt, 0,0) ;

      /* insensitive, special case */
      if( !XtIsSensitive(w) && idx != INSENSITIVE && idx != SETINSENSITIVE  &&
	  bw->xpmbutton.grey50 != NULL )
	XFillRectangle(dpy, win, bw->xpmbutton.grey50,
	  0,0, bw->core.width, bw->core.height) ;
    }
}

static	PixmapInfo *
xpmGetPixmap(bw, pixmap, getmax)
    XpmButtonWidget bw;
    Pixmap	pixmap ;
    Bool	getmax ;
{
    Widget	w = (Widget)bw ;
    Display	*dpy = XtDisplay(w) ;
    PixmapInfo	*rval ;

    if( pixmap == None || pixmap == XtUnspecifiedPixmap ) return NULL ;

    rval = GetPixmapInfo(dpy, pixmap) ;

    if( getmax && rval != NULL )
    {
      if( rval->width > bw->xpmbutton.pwid )
	bw->xpmbutton.pwid = rval->width ;
      if( rval->height > bw->xpmbutton.phgt )
	bw->xpmbutton.phgt = rval->height ;
    }

    return rval ;
}



static	GC
xpmMakeGc(bw, info)
    XpmButtonWidget bw;
    PixmapInfo	*info ;
{
    Widget	w = (Widget)bw ;
    XGCValues	values ;
    u_long	vmask, dcmask ;

    if( info == NULL ) return NULL ;

    vmask = 0 ;
    dcmask = GCForeground | GCBackground | GCLineWidth | GCLineStyle |
	GCCapStyle | GCJoinStyle | GCFont | GCDashOffset | GCDashList |
	GCArcMode ;

    if( info->mask != None )
    {
      values.clip_mask = info->mask ;
      vmask = GCClipMask ;
    }

    return XtAllocateGC(w, bw->core.depth, vmask, &values, 0L, dcmask) ;
}



	/* learn what we can about the pixmaps right now */

static	void
xpmbuttonGetPixmapInfo(bw)
    XpmButtonWidget bw;
{
    if( bw->xpmbutton.pixmaps[BG] == NULL )
      bw->xpmbutton.pixmaps[BG] =
        xpmGetPixmap(bw, bw->xpmbutton.bgPixmap, False) ;

    if( bw->xpmbutton.pixmaps[UNSET] == NULL )
      bw->xpmbutton.pixmaps[UNSET] =
	  xpmGetPixmap(bw, bw->xpmbutton.unsetPixmap, True);
    if( bw->xpmbutton.pixmaps[HIGHLIT] == NULL )
      bw->xpmbutton.pixmaps[HIGHLIT] =
	  xpmGetPixmap(bw, bw->xpmbutton.hlPixmap, True) ;
    if( bw->xpmbutton.pixmaps[ARMED] == NULL )
      bw->xpmbutton.pixmaps[ARMED] =
	  xpmGetPixmap(bw, bw->xpmbutton.armPixmap, True) ;
    if( bw->xpmbutton.pixmaps[SET] == NULL )
      bw->xpmbutton.pixmaps[SET] =
	  xpmGetPixmap(bw, bw->xpmbutton.setPixmap, True) ;
    if( bw->xpmbutton.pixmaps[SETHIGHLIT] == NULL )
      bw->xpmbutton.pixmaps[SETHIGHLIT] =
	  xpmGetPixmap(bw, bw->xpmbutton.setHlPixmap, True);
    if( bw->xpmbutton.pixmaps[SETARMED] == NULL )
      bw->xpmbutton.pixmaps[SETARMED] =
	  xpmGetPixmap(bw, bw->xpmbutton.setArmPixmap, True) ;
    if( bw->xpmbutton.pixmaps[INSENSITIVE] == NULL )
      bw->xpmbutton.pixmaps[INSENSITIVE] =
	  xpmGetPixmap(bw, bw->xpmbutton.insenPixmap, True) ;
    if( bw->xpmbutton.pixmaps[SETINSENSITIVE] == NULL )
      bw->xpmbutton.pixmaps[SETINSENSITIVE] =
	  xpmGetPixmap(bw, bw->xpmbutton.setInsenPixmap, True) ;
}




static	void
xpmbuttonGetGcs(bw)
    XpmButtonWidget bw;
{
    Widget	w = (Widget)bw ;
    XGCValues	values ;
    u_long	vmask, dcmask ;
    int		i ;
    Pixmap	pm50 ;

    xpmbuttonGetPixmapInfo(bw) ;

    for(i=BG; i<=SETINSENSITIVE; ++i)
      if( bw->xpmbutton.pixmaps[i] != NULL )
	bw->xpmbutton.gcs[i] = xpmMakeGc(bw, bw->xpmbutton.pixmaps[i]) ;

    if( bw->xpmbutton.pixmaps[INSENSITIVE] == NULL ||
        bw->xpmbutton.pixmaps[SETINSENSITIVE] == NULL )
    {
	pm50 = XmuCreateStippledPixmap(XtScreen(w), 1L, 0L, 1) ;
	values.fill_style = FillStippled ;
	values.foreground = w->core.background_pixel ;
	values.stipple = pm50 ;
	vmask = GCForeground|GCStipple|GCFillStyle ;
	dcmask = GCFont|GCSubwindowMode|GCGraphicsExposures|GCDashOffset|
		GCDashList|GCArcMode ;
	bw->xpmbutton.grey50 =
		XtAllocateGC(w, w->core.depth, vmask, &values, 0L, dcmask) ;
    }
}


static	void
xpmbuttonFreeGcs(bw)
    XpmButtonWidget	bw;
{
    Widget	w = (Widget)bw ;
    int		i ;

    for(i=BG; i<=SETINSENSITIVE; ++i)
      if( bw->xpmbutton.gcs[i] != NULL ) {
	XtReleaseGC(w, bw->xpmbutton.gcs[i]) ;
	bw->xpmbutton.gcs[i] = NULL ;
      }

    for(i=BG; i<=SETINSENSITIVE; ++i)
      if( bw->xpmbutton.pixmaps[i] != NULL ) {
	ReleasePixmap(bw->xpmbutton.pixmaps[i]) ;
	bw->xpmbutton.pixmaps[i] = NULL ;
      }

    if( bw->xpmbutton.grey50 != NULL ) {
      XtReleaseGC(w, bw->xpmbutton.gcs[i]) ;
      bw->xpmbutton.gcs[i] = NULL ;
    }
}


static	void
replaceGC(bw, which, pixmap)
    XpmButtonWidget	bw ;
    int			which ;
    Pixmap		pixmap ;
{
    Widget	w = (Widget)bw ;
    XtReleaseGC(w, bw->xpmbutton.gcs[which]) ;
    ReleasePixmap(bw->xpmbutton.pixmaps[which]) ;
    bw->xpmbutton.pixmaps[which] = xpmGetPixmap(bw, pixmap, which != BG);
    bw->xpmbutton.gcs[which] = xpmMakeGc(bw, bw->xpmbutton.pixmaps[which]) ;
}
