/*
 * $Id: AdjRowCol.h,v 1.6 1995/03/21 13:43:12 gerd Exp $
 */

/* Copyright (C) 1995 Gerd Rausch
   Please send comments and suggestions to:
   <gerd@alf.gun.de>

AdjRowCol is free software; you can redistribute it and/or modify it under
the terms of the GNU Library General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AdjRowCol is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU Library General Public
License along with this software; see the file COPYING.LIB.  If not,
write to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
02139, USA.  */

/***************************************************************
 * Adjustable RowColumn widget (SubClass of CompositeClass)
 *
 ***************************************************************/

/* RESOURCES:
   Name			Class			RepType		Default Value
   ----			-----			-------		-------------
   threeDimensional     ThreeDimensional	Boolean		True
   orientation		Orientation		Orientation	horizontal
   columns		Columns			int		0
   rowsAdjustable	Adjustable		Boolean		True
   colsAdjustable	Adjustable		Boolean		True
   foreground		Foreground		Pixel		Black
   shadowThickness	ShadowThickness		Dimension	1
   topShadowColor	TopShadowColor		Pixel		gray80
   bottomShadowColor	BottomShadowColor	Pixel		gray60
   gripThickness	GripThickness		Dimension	2
   gripBorder		GripBorder		Dimension	2
   gripHorizCursor	Cursor			Cursor		sb_v_double_arrow
   gripVertCursor	Cursor			Cursor		sb_h_double_arrow
   gripCrossCursor	Cursor			Cursor		fleur
   */

#ifndef _AdjRowCol_h
#define _AdjRowCol_h
#ifdef __cplusplus 
extern "C" {
#endif

/* New Fields */
#define XtNthreeDimensional "threeDimensional"
#define XtNcolumns "columns"
#define XtNrowsAdjustable "rowsAdjustable"
#define XtNcolsAdjustable "colsAdjustable"
#define XtNgripThickness "gripThickness"
#define XtNgripBorder "gripBorder"
#define XtNgripHorizCursor "gripHorizCursor"
#define XtNgripVertCursor "gripVertCursor"
#define XtNgripCrossCursor "gripCrossCursor"
#ifndef USE_MOTIF
#define XtNshadowThickness "shadowThickness"
#define XtNtopShadowColor "topShadowColor"
#define XtNbottomShadowColor "bottomShadowColor"
#endif

#define XtCThreeDimensional "ThreeDimensional"
#define XtCColumns "Columns"
#define XtCAdjustable "Adjustable"
#define XtCGripThickness "GripThickness"
#define XtCGripBorder "GripBorder"
#ifndef USE_MOTIF
#define XtCShadowThickness "ShadowThickness"
#define XtCTopShadowColor "TopShadowColor"
#define XtCBottomShadowColor "BottomShadowColor"
#endif

#ifdef USE_MOTIF
#define XmNrowsAdjustable XtNrowsAdjustable
#define XmNcolsAdjustable XtNcolsAdjustable
#define XmNgripThickness XtNgripThickness
#define XmNgripBorder XtNgripBorder
#define XmNgripHorizCursor XtNgripHorizCursor
#define XmNgripVertCursor XtNgripVertCursor
#define XmNgripCrossCursor XtNgripCrossCursor

#define XmCAdjustable XtCAdjustable
#define XMCGripThickness XtCGripThickness
#define XmCGripBorder XtCGripBorder
#endif /* USE_MOTIF */

#ifdef USE_MOTIF
#define xmAdjRowColWidgetClass adjRowColWidgetClass
#define _XmAdjRowColClassRec _AdjRowColClassRec
#define XmAdjRowColWidgetClass AdjRowColWidgetClass
#define _XmAdjRowColRec _AdjRowColRec
#define XmAdjRowColWidget _AdjRowColWidget
#endif /* USE_MOTIF */

extern WidgetClass adjRowColWidgetClass;
typedef struct _AdjRowColClassRec *AdjRowColWidgetClass;
typedef struct _AdjRowColRec *AdjRowColWidget;

#ifdef __cplusplus
}
#endif

#endif /* _AdjRowCol_h */
