#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Soundex coding routine
 *
 * Debug levels:
 *
 * 1 - status messages
 */

#include "sos.h"

#define SOS_APP_CONF "/etc/sos.app.conf"


void usage(void);
void sighandler(int signo);
void cleanup(void);
void naim(int retcode);
void die(int retcode, char *fmt, ...);
void warn(char *fmt, ...);
int run(void);


char *program;
struct termios ttysave;
sos_config_t config;


int
main(int argc, char **argv, char **envp)
{
  SOS_ENTRY("hello","main", NULL);
  int tmpvar, getopterr = 0;
  extern char *optarg;
  extern int optind;

  sos_initProcTitle(argc, &argv, &envp, &program);
  open_soslog(program, 0);
  config = sos_config_read(SOS_ENV_GWD("SOS_APP_CONF_ENV",SOS_APP_CONF));
  sos_debug_set_config(config, "debug");
  sos_error_create(atoi(SOS_GWD("error_queue","64")));

  sos_tty_get(0, &ttysave);

  while ((tmpvar = getopt(argc,argv, "d")) != -1)
    switch(tmpvar)
      {
      case 'd':
	open_soslog(program, 1);
	sos_debug_info(stderr, 0);
	sos_fun_upbug();
        break;
      case '?':
        getopterr++;
      }

  if (getopterr)
    {
      usage();
      exit(1);
    }

  for(tmpvar=SIGHUP;tmpvar<=SIGUSR2;tmpvar++)
    sos_signal(tmpvar, sighandler);

  sos_debug_printf_and(1, "Initializtion complete");

  if (run() < 0)
    {
      sos_error_printf("Failed after initialization\n");
      die(2,"Run failed\n");
    }

  sos_debug_printf_and(1, "Ready for shutdown");
  naim(0);
}


/*
 * Print information on how to use the program
 */
void usage(void)
{
  SOS_ENTRY("hello", "usage", NULL);
  fprintf(stderr,"%s: [-d]\n",program);
  SOS_RETURN( );
}


/*
 * Generic signal handler
 */
void sighandler(int signo)
{
  struct termios tmptty;

  switch (signo)
    {
    case SIGQUIT:
    case SIGILL:
    case SIGTRAP:
    case SIGABRT:
#ifndef __linux__
    case SIGEMT:
    case SIGSYS:
#endif
    case SIGFPE:
    case SIGBUS:
    case SIGSEGV:
    case SIGWINCH:
      warn("Received signal %d\n",signo);
      cleanup();
      sos_signal(SIGABRT, SIG_DFL);
      abort();			/* Cause core dump */
    case SIGTSTP:
      kill(getpid(),SIGSTOP);
    case SIGCONT:
      break;			/* Restore internal tty? */

    default:
      die(2,"Received signal %d\n",signo);
    }
}


/*
 * Generic cleanup handler
 */
void cleanup(void)
{
  SOS_ENTRY("hello","cleanup", NULL);
  sos_tty_set(0, &ttysave, NULL);
  SOS_RETURN( );
}


/*
 * Generic exit function
 * Die and print error logs and current arguments
 */
void naim(int retcode)
{
  SOS_ENTRY("hello","naim", NULL);

  cleanup();			/* Clean up program state */
  exit(retcode);
}


/*
 * Generic die function
 * Die and print error logs and current arguments
 */
void die(int retcode, char *fmt, ...)
{
  SOS_ENTRY("hello","die","fmt: %s",fmt);
  va_list args;

  cleanup();			/* Clean up program state */

  fprintf(stderr,"\n\n----------------------------------------------------------------------\n");
  fprintf(stderr,"Program %s dying.  Error trace:\n\n--------------------------------------------------\n",program);
  sos_error_stdout(stderr);	/* Spew out error log */
  sos_error_soslog(SOSLOG_WARNING);	/* Spew out error log */
  sos_error_pop(0);

  fprintf(stderr,"--------------------------------------------------\n\n");
  if (fmt)
    {
      fprintf(stderr,"%s: die: ",program);
      va_start(args, fmt);
      vfprintf(stderr,fmt,args); /* Print what user wants */
      va_end(args);
      fprintf(stderr,"\n\n");
    }

  exit(retcode);
}


/*
 * Generic warning function
 * print error logs and current arguments
 */
void warn(char *fmt, ...)
{
  SOS_ENTRY("hello","warn",NULL);
  va_list args;

  fprintf(stderr,"\n\n----------------------------------------------------------------------\n");
  fprintf(stderr,"Program %s warning.  Error trace:\n\n--------------------------------------------------\n",program);
  sos_error_stdout(stderr);	/* Spew out error log */
  sos_error_pop(0);

  fprintf(stderr,"--------------------------------------------------\n\n");
  if (fmt)
    {
      fprintf(stderr,"%s: warn: ",program);
      va_start(args, fmt);
      vfprintf(stderr,fmt,args); /* Print what user wants */
      va_end(args);
      fprintf(stderr,"\n\n");
    }

  SOS_RETURN( );
}


/*
 * main program
 */
int run(void)
{
  SOS_ENTRY("hello","run",NULL);
  char buf[1024];

  while(fgets(buf, sizeof(buf), stdin))
    {
      sos_rip(buf);
      printf("Given: %s Soundex produces %s\n",buf,sos_soundex(buf));
    }

  SOS_RETURN(0);
}
