#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the new SKID3 protocol
 */

#include "sos.h"

int port=2332;

int client(char *,int namecount);
int server(int namecount);
void Usage(int argc,char **argv);

sos_config_t config;
char  *localname=NULL, *peername=NULL;

struct sos_protocol proto;
struct sos_skid_protocol skidInfo;
int run_state_engine=0;

main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int ret = -2;
  int clienti=0,serveri=0;
  int namecount=0;

  config = sos_config_read(SOS_ENV_GWD("BS_RMNT_CONF","/etc/bs.rmnt.conf"));
  
  while ((c = getopt(argc, argv, "vrt:p:l:f:sd:")) != -1)
    switch (c)
      {
      case 'r':
	serveri++;
	break;

      case 'd':
	sos_debug_set("sos_skid", atoi(optarg));
/*	sos_debug_set("sos_fun", 3); /* Set to 7 for exit tracing too */
	sos_debug_set("sos_error", 1);
	sos_debug_info(stderr,0);
	printf ("Setting debug level to: %d\n", atoi(optarg));
	break;

      case 's':
	run_state_engine++;
	break;

      case 't':
	clienti++;
	break;

      case 'p':
	port = atoi(optarg);
	break;       

      case 'v':	
	break;

      case 'l': 
	localname=strdup(optarg);
	namecount++;
	break;

      case 'f': 
	peername=strdup(optarg);
	namecount++;
	break;

      default :
	Usage(argc,argv);
	break;
      }

  if ( clienti && serveri || (namecount!=0 && namecount!=2) )
    {
      Usage(argc,argv);
    }

  if (run_state_engine)
    {
      proto.flags=0;
      proto.buf = NULL;
      proto.private_data = &skidInfo;
      SOS_PROT_SET_START(&proto);
      skidInfo.Key=NULL;
      skidInfo.Alice=NULL;
      skidInfo.Bob=NULL;
      skidInfo.allocated_names=0;
      
      if (namecount == 2 )
	{
	  skidInfo.Alice=sos_allocstr_buf(NULL,localname);
	  skidInfo.Bob=sos_allocstr_buf(NULL,peername);
	}
      else
	{
	  fprintf(stderr,"Err. Please supply both peer skid \"names\". Sorry..\n");
	  exit (1);
	}
    }
  
  
  if ( clienti )
    {
      ret = client(optarg,namecount);
    }
  else
    {
      ret = server(namecount);
    }

  if (ret == 0)
    printf("SKID LOST!!!\n");
  else if (ret == 1)
    printf("SKID WON!!!\n");
  else if (ret == -1)
    printf("SKID ERROR!!!\n");
  else
    printf("WHAT THE !$*%% IS GOING ON??? (%d)\n",ret);

  exit(0);
}

void
Usage(int argc,char **argv)
{

  printf("Usage: %s [-vsd] [-l localname -f foreignname ][-p <port>]  -r|-t server\n",argv[0]);
  exit(1);
}



int
client(char *server, int namecount)
{
  int s;			/* socket */
  struct sockaddr_in saddr;	/* Server addr */
  struct hostent *servhent;	/* Hostent */
  int ret_val;
  caddr_t key;			/* Key value */

  /* NO ERROR CHECKING !! :-) */
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  servhent = sos_gethbyfoo(server);

  memset ((char *)&saddr, (char)0, sizeof(saddr));
  saddr.sin_family = AF_INET;
  saddr.sin_port = htons (port);
  memcpy((caddr_t)&(saddr.sin_addr.s_addr),
	 (caddr_t)(servhent->h_addr_list[0]),
	 sizeof(servhent->h_addr_list[0]));

  if ((connect(s, (struct sockaddr *)&saddr, sizeof(saddr))) < 0)
    {
      perror("connect");
      exit(5);
    }

  key = sos_config_getnext(config, "authkey", SOS_CONFIG_FORWARD, SOS_CONFIG_STATIC); 

  if ( run_state_engine )
    {
      skidInfo.Key=key;
      ret_val = sos_BIO_skid_state(s, sosBIOread, sosBIOwrite, &proto);
    }
 
  else if (namecount == 2 )
    {
      ret_val = sos_skid_stringname(s,key  , sosBIOread, sosBIOwrite, localname, peername);
    }
  else
    {
      ret_val = sos_skid(s, key, sosBIOread, sosBIOwrite);
    }

  close(s);
  return ret_val;
}


int
server(int namecount)
{

  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */
  int ret_val;
  caddr_t key;
    
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  len = sizeof (sock);
  memset((char *)&sock, (char )0, sizeof(sock));
  sock.sin_family = AF_INET;
  sock.sin_port = htons (port);
  sock.sin_addr.s_addr = INADDR_ANY;

  if (bind (s, (struct sockaddr *)&sock, len) < 0)
    {
      perror("bind");
      exit(5);
    }

  if (listen(s, 5) < 0)
    {
      perror("bind");
      exit(5);
    }

  memset((char *)&sock, (char )0, sizeof(sock));
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("bind");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");
  close(s);

  
  key = sos_config_getnext(config, "authkey", SOS_CONFIG_FORWARD, SOS_CONFIG_STATIC);

  if ( run_state_engine )
    {
      skidInfo.Key=key;
      ret_val = sos_BIO_skid_state(child, sosBIOread, sosBIOwrite, &proto);
    }

  else if (namecount == 2 )
    {
      ret_val = sos_skid_stringname(child, key, sosBIOread, sosBIOwrite, localname, peername);
    }
  else
    {
      ret_val = sos_skid(child, key, sosBIOread, sosBIOwrite);
    }
  close (child);
  return ret_val;
}
