#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test XDR routines
 */

#include "sos.h"

int SOCKBUFSIZE=300;

int tint;
long tlong;
short tshort;
char *tstring;
sos_string tbuffer;
char tchar;
int tint1;
long tlong1;
short tshort1;
char *tstring1;
sos_string tbuffer1;
char tchar1;
char *port="2332";
char stupid[1024];
struct timeval sout = { 2, 0 };

void client(char *, int);
void server();
int ask_for_io = 0;


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int testappend=0;

  sos_error_create(64);

  sos_signal(SIGPIPE,SIG_IGN);
  
  while ((c = getopt(argc, argv, "As:a:rt:p:")) != -1)
    switch (c)
      {
      case 'A':
	ask_for_io = 1;
	break;
      case 'r':
	server();
	break;

      case 't':			/* This argument must go last! */
	client(optarg, testappend);
	break;

      case 'p':
	port = optarg;
	break;       

      case 's':
	SOCKBUFSIZE=atoi(optarg);
	break;

      case 'a': 
	testappend = atoi(optarg);
	break;

      default :
	printf("Usage: %s [-p port] [-a #appends] -r|-t server\n",argv[0]);
	exit(1);
	break;
      }
  exit(0);
}


void
client(char *server, int testappend)
{
  int s;			/* socket */
  struct sockaddr_in saddr;	/* Server addr */
  struct hostent *servhent;	/* Hostent */
  int i;			/* Dumb counter */
  sos_string buf;		/* For use in append mode */
  sos_string *tmpbuf;		
  int argcount=0;
  char *curloc;			/* Curent peek location */
  int error=0;
  sos_nbio_handle *snh;
  int tmp;
  fd_set writefds;
  int bytesout = 0;

  tint = 2323;
  tlong = -17;
  tshort = 124;
  tstring = strdup("This is a null terminated test string");
  tbuffer.len = 1024;
  tchar = '[';

#if 0
  srandom (getpid());
#endif
  tbuffer.str = (char *)malloc(tbuffer.len);
  for (i=1; i <= 1021; i++)
    tbuffer.str[i]=(char)((i%64)+64);
#if 0
    tbuffer.str[i]=(char)rint((double)random() / (double)MAXLONG * 256.0);
#endif
  tbuffer.str[0]='*';
  tbuffer.str[1021]='%';
  tbuffer.str[1022]='*';
  tbuffer.str[1023]='/';


  if ((s = sos_make_conn(server,port,0,0,stderr)) < 0)
    {
      perror("make_conn");
      exit(5);
    }
  if ((snh = sos_nbio_fdopen(s, sosRawWrite, O_WRONLY)) == NULL)
    {
      perror("nbio_fdopen");
      exit(5);
    }

  i = SOCKBUFSIZE;
  tmp = sizeof(i);
  if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&i, tmp) < 0)
    {
      perror("setsockopt");
      exit(5);
    }

  tmpbuf = sos_xdr_sencode("ilsScB", 
			   tint, 
			   tlong, 
			   tshort,
			   tstring, 
			   tchar,
			   &tbuffer);

  buf.len = tmpbuf->len;
  if ( (buf.str = (char *) malloc (buf.len)) == NULL )
    {
      perror("main(): sos string malloc");
      exit(1);
    }

  memcpy (buf.str, tmpbuf->str, buf.len);

  (void)sos_xdr_freebuf();	/* It's now safe since we copied */

  while (testappend-- > 0)
    {
      tint++;
      tlong++;
      tshort++;
      tstring = strdup("This is another null terminated test string");
      /* We'll keep the same buffer */
      tchar++;
      if ( sos_xdr_sappend(&buf, "ilsScB", 
			   tint, 
			   tlong, 
			   tshort,
			   tstring, 
			   tchar,
			   &tbuffer) == NULL )
	{
	  fprintf(stderr,"main(): Error in sappend: Exiting\n");
	  exit(1);
	}
    };

  FD_ZERO(&writefds);
  if ((tmp = sos_nbio_write(snh,&buf,0,&writefds, &bytesout)) < SOS_NBIO_NOPROGRESS)
    {
      sos_error_stdout(stderr);
      fprintf(stderr,"error: nbio_write returned %d\n",tmp);
      exit(2);
    }
  fprintf(stderr,"notice: nbio_write returned %d--wrote %d bytes\n",tmp,bytesout);
  bytesout=0;

  while (1)
    {
      if (FD_ISSET(s,&writefds))
	{
	  fprintf(stderr,"More stuff to write\n");
	}
      else
	{
	  fprintf(stderr,"Nothing more to write\n");
	  break;
	}

      select(s+1,NULL,&writefds,NULL,&sout);
      if (FD_ISSET(s,&writefds))
	{
	  fprintf(stderr,"Select claims to be able to write\n");
	}
      else
	{
	  fprintf(stderr,"Why did select return?\n");
	}

      if (ask_for_io)
	fgets(stupid,1024,stdin);

      if ((tmp = sos_nbio_write(snh,NULL,0,&writefds, &bytesout)) < SOS_NBIO_NOPROGRESS)
	{
	  sos_error_stdout(stderr);
	  fprintf(stderr,"error: nbio_write returned %d\n",tmp);
	  exit(2);
	}
      fprintf(stderr,"notice: nbio_write returned %d--wrote %d bytes\n",tmp,bytesout);
      bytesout=0;
    }
      
  sos_nbio_cleanup(snh);
  return;
}


void
server()
{

  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */
  int foo;
  int i;
  int tmp;
  sos_nbio_handle *snh;
  sos_string buf;
  char *xdrhndl = NULL;
    
  if ((s = sos_get_conn(NULL, sos_getsbyfoo(port), 0, NULL)) < 0)
    {
      perror("get_conn");
      exit(5);
    }

  len = sizeof(sock);
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("accept");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");

  if ((snh = sos_nbio_fdopen(child, sosRawRead, O_RDONLY)) == NULL)
    {
      perror("nbio_fdopen");
      exit(5);
    }

  i = SOCKBUFSIZE;
  tmp = sizeof(i);
  if (setsockopt(child, SOL_SOCKET, SO_RCVBUF, (char *)&i, tmp) < 0)
    {
      perror("setsockopt");
      exit(5);
    }

  while (1)
    {
      fd_set readfds;
      FD_ZERO(&readfds);
      FD_SET(child, &readfds);

      if (ask_for_io)
	fgets(stupid,1024,stdin);

      if ((tmp = sos_nbio_read(snh, &buf)) < SOS_NBIO_NOPROGRESS)
	{
	  sos_error_stdout(stderr);
	  fprintf(stderr,"nbio_read returned %d\n",tmp);
	  exit(1);
	}

      fprintf(stderr,"nbio_read returned %d\n",tmp);
      if (tmp == SOS_NBIO_BUFCOMPLETE)
	break;

      fprintf(stderr,"Selecting for data\n");
      select(child+1,&readfds,NULL,NULL,&sout);
      if (!FD_ISSET(child, &readfds))
	{
	  fprintf(stderr,"Why did select return?\n");
	}
      fprintf(stderr,"Select returned\n");
    }

  while (1)
    {
      if ((foo = sos_xdr_speek(&buf, &xdrhndl, "ilsScB",
			       &tint, 
			       &tlong, 
			       &tshort,
			       &tstring, 
			       &tchar,
			       &tbuffer
			       )) != 6 )
	{
	  if (foo == 0)
	    break;		/* Read last buffer */
	  fprintf(stderr,"server: sos_xdr_speek(%d) failed\n",foo);
	  return;
	}

      printf("*********** Server output *************\n");
      printf("Int: %d\nLong: %d\nShort: %d\nString: **%s**\nBuffer(%d): **%s**\nChar: %c\n",
	     tint, 
	     tlong, 
	     tshort,
	     tstring, 
	     tbuffer.len,
	     tbuffer.str,
	     tchar);
    }
  free(buf.str);
  (void)sos_xdr_freebuf();
  sos_nbio_cleanup(snh);
  return;
  
}
