#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 *
 * Test the SOS stat call
 *
 */


#include "sos.h"

main(int argc, char *argv[])

{
  struct sos_fsinfo t;

  if ( sos_statfs(argv[1], &t) < 0)
    {
      perror("sos_statfs()");
      exit(1);
    }

  printf("STATFS STRUCT on dir *%s*:\n\tfsize: %d\n\tblock: %d\n\tbfree: %d\n\tbavail: %d\n\tfiles: %d\n\tinodes: %d\n",
	 argv[1],
	 t.f_fsize,
	 t.f_blocks,
	 t.f_bfree,
	 t.f_bavail,
	 t.f_files,
	 t.f_ffree);

  exit(0);
}
