#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Routine to generate inital static authentication password value
 */


#include "sos.h"


char charset[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-";


main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  int echo=0;
  char password[80];
  unsigned char *salt;
  unsigned char staticsalt[4];


  while ((c = getopt(argc, argv, "e")) != -1)
    switch (c)
      {
      case 'e':
	echo++;
	break;
      }

  if (errflg || optind < argc - 1)
    {
      fprintf(stderr,"Usage: %s [-e] [salt]\n",argv[0]);
      exit(5);
    }


  sos_tty_echooff(0, NULL);
  fprintf(stderr,"Please enter password: ");
  fgets(password,80,stdin);
  sos_tty_echoon(0, NULL);
  fprintf(stderr,"\n");
  sos_rip(password);


  if (optind == argc - 1)
    {
      salt = argv[optind];
    }
  else
    {
      salt = staticsalt;
      sos_get_rand(salt,sizeof(staticsalt));

      staticsalt[0] = charset[staticsalt[0] & 0x3f];
      staticsalt[1] = charset[staticsalt[1] & 0x3f];
      staticsalt[2] = charset[staticsalt[2] & 0x3f];
      staticsalt[3] = charset[staticsalt[3] & 0x3f];
    }

  printf("Crypted value is %s\n",sos_statichash(salt,password));
  exit(0);
}
