#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the SecureNets databases
 */

#include "sos.h"

sos_config_t config;

char manyout[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";

main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int hex = 0;
  int bit = 0;
  int many = 0;
  int ret = -2;
  unsigned int numgen = 1024;
  int defsize = 4;
  unsigned char buf[1024];

  while ((c = getopt(argc, argv, "bc:mhfs:")) != -1)
    switch (c)
      {
      case 'b':
	bit = 1;
	break;
      case 'h':
	hex = 1;
	break;
      case 'm':
	many = 1;
	break;

      case 's':
	defsize = atoi(optarg);
	break;
      case 'c':
	numgen = atoi(optarg);
	break;
      default:
	printf("Usage: %s\n",argv[0]);
	exit(1);
	break;
      }

  if (bit)
    {
      if (defsize > 32)
	defsize=32;
    }

  for (;numgen;numgen--)
    {
      if (bit)
	{
	  char foo;
	  int bitp, bytep;
	  int tmp = defsize * 32;

	  sos_get_rand(buf, tmp);

	  for(bytep=0;bytep<defsize;bytep++)
	    {
	      foo = 0;
	      for(bitp=0;bitp<8;bitp++)
		foo |= (buf[bytep*32+bitp*4+3]&0x1) << bitp;
	      buf[bytep] = foo;
	    }
	}
      else {
	sos_get_rand(buf, defsize);
      }


      for(ret = 0; ret < defsize; ret++)
	{
	  if (many)
	    {
	      static char manybuf[3];
	      static char manynum = 0;
	      manybuf[manynum++] = buf[ret]&0xff;
	      if (manynum == 3)
		{
		  printf("%c%c%c%c",
			 manyout[(manybuf[0]>>2)&0x3f],
			 manyout[(((manybuf[0]<<4)&0x30) | (((manybuf[1]>>4)&0x0f) & 0x3f))],
			 manyout[(((manybuf[1]<<2)&0x3c) | (((manybuf[2]>>6)&0x02) & 0x3f))],
			 manyout[(manybuf[2]&0x3f)]);
		  manynum = 0;
		}
	    }
	  else
	    {
	      if (hex)
		printf("%02x",buf[ret]&0xff);
	      else
		printf("%c",buf[ret]&0xff);
	    }
	}
    }
  if (many || hex)
    printf("\n");
  exit(0);
}
