#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Retrieve/set system information
 */

#include "sos.h"



/*
 * Find the current fd table size
 */
int sos_getdtablesize(void)
{
  SOS_ENTRY("sos_sysinfo","sos_getdtablesize",NULL);

#ifdef _WIN32
  /*
   * NT has no concept of a maximum limit of open files per process,
   * and if they do, it is not controllable.
   * This code is very bugus, b/c there's no limit on number of sockets.
   * Whenever you see code that calls sos_getdtablesize, suggest you call
   * instead the SOSNT function sosnt_getdtablesize.
   */
  SOS_RETURN(NOFILE);
#else /* _WIN32 */

  struct rlimit rlimit;
  int tableSize;

  if (getrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      sos_error_printf("Could not getrlimit NOFILE: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }
  tableSize = rlimit.rlim_cur;

  SOS_RETURN(tableSize);
#endif /* !_WIN32 */
}


/*
 * Set the current fd table size (returns old value)
 *
 * if (New < 0) New == max;
 */
int sos_setdtablesize(int new)
{
  SOS_ENTRY("sos_sysinfo","sos_setdtablesize",NULL);
#ifdef _WIN32
  /*
   * NT has no concept of a maximum limit of open files per process,
   * and if they do, it is not controllable.
   */
  if (new == NOFILE || new < 0) /* only allow to change to max/same limit */
    SOS_RETURN(NOFILE);		/* return "old" limit */
  else
    SOS_RETURN(-1);		/* else failed */
#else /* _WIN32 */
  struct rlimit rlimit;
  int oldtableSize;
  int maxtableSize;

  if (getrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      sos_error_printf("Could not getrlimit NOFILE: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }
  oldtableSize = rlimit.rlim_cur;
  maxtableSize = rlimit.rlim_max;

  if (new < 0)
    {
      new = maxtableSize;

      /*
       * XXX - should this limitation be on even explicit sets???
       *
       * The problem is if you pass select getdtablesize where that
       * number is greater than FD_SETSIZE, select gets upset (not
       * unsurprisingly).  This is probably true of many things.
       */
#ifdef FD_SETSIZE
      new = MIN(new, FD_SETSIZE);
#endif /* FD_SETSIZE */
    }

  rlimit.rlim_cur = new;

  if (setrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      sos_error_printf("Could not setrlimit NOFILE: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(oldtableSize);
#endif /* !_WIN32 */
}
