#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Some string utilities (in both string and sos_string versions)
 *
 * Note: *tolower function seem to fail on some platforms
 * (BSDI 1.1) because tolower() does not work.  Go figure.
 *
 * Note that there is no fun or debugging in this file.  If
 * you ever really need it, go ahead and add it.
 */

#include <sos.h>



/*
 * Convert strings to lowercase
 */
void
sos_strtolower(register char *s)
{
  sos_string ss;

  if (!s)
    return;

  ss.str = s;
  ss.len = strlen(s);
  sos_sosstrtolower(&ss);
}



/*
 * Convert strings to lowercase using sos_strings
 */
void
sos_sosstrtolower(sos_string *buf)
{
  register char *p, *start = buf->str;

  if (!buf)
    return;

  for(p = buf->str+buf->len-1;p>=start;p--)
    {
      *p=tolower(*p);
    }

  return;
}



/*
 * Find location of s2 in s1 (slightly more efficient than BSD
 */
char *
sos_strstr(char *s1, char *s2)
{
  sos_string ss1, ss2;

  if (!s1 || !s2)
    return(NULL);

  ss1.str = s1;
  ss1.len = strlen(s1);
  ss2.str = s2;
  ss2.len = strlen(s2);

  return(sos_sosstrstr(&ss1,&ss2));
}



/*
 * strstr using sos_strings (does not need to be null terminated)
 */
char *
sos_sosstrstr(sos_string *s1, sos_string *s2)
{
  char *max = s1->str + s1->len - s2->len;
  register char *tmp;
  register char *dest = s2->str;
  register int dlen = s2->len;

  if (!s1 || !s2)
    return(NULL);

  for(tmp=s1->str;tmp<=max;tmp++)
    {
      if (!strncmp(tmp,dest,dlen))
	return(tmp);
    }

  return(NULL);
}
