#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * SOS interface to signal routines...
 */

#include "sos.h"



/*
 * Implement signal interface using sigaction behind the scenes
 *
 * Everything except SIGALRM will hopefully be restarted
 * SIGALRM will cause the routine to terminate with EINTR
 */
sos_sigfunc *sos_signal(int signo, sos_sigfunc *fun)
{
  SOS_ENTRY("sos_signal","sos_signal",NULL);
  struct sigaction act, oact;

  act.sa_handler = fun;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if (signo == SIGALRM)
    {
#ifdef SA_INTERRUPT
      act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif /* SA_INTERRUPT */
    }
  else
    {
#ifdef SA_RESTART
      act.sa_flags |= SA_RESTART; /* SVR4, 4.4BSD */
#endif /* SA_RESTART */
    }
  if (sigaction(signo, &act, &oact) < 0)
    SOS_RETURN(SIG_ERR);
  SOS_RETURN(oact.sa_handler);
}


/* 
 * Get the currrnet action associated with the named signal. 
 */
sos_sigfunc *sos_signal_get(int signo)
{
  SOS_ENTRY("sos_signal","sos_signal",NULL);
  struct sigaction oact;

  if (sigaction(signo, NULL, &oact) < 0)
    SOS_RETURN(SIG_ERR);
  SOS_RETURN(oact.sa_handler);
}



/*
 * Implement signal interface using sigaction behind the scenes
 *
 * All routines will interrupt
 */
sos_sigfunc *sos_signal_intr(int signo, sos_sigfunc *fun)
{
  SOS_ENTRY("sos_signal","sos_signal_intr",NULL);
  struct sigaction act, oact;

  act.sa_handler = fun;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;

#ifdef SA_INTERRUPT
  act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif /* SA_INTERRUPT */

  if (sigaction(signo, &act, &oact) < 0)
    SOS_RETURN(SIG_ERR);
  SOS_RETURN(oact.sa_handler);
}



/*
 * Implement signal interface using sigaction behind the scenes
 *
 * All routines will restart if possible
 */
sos_sigfunc *sos_signal_cont(int signo, sos_sigfunc *fun)
{
  SOS_ENTRY("sos_signal","sos_signal_cont",NULL);
  struct sigaction act, oact;

  act.sa_handler = fun;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;

#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART;	/* SVR4, 4.4BSD */
#endif /* SA_RESTART */

  if (sigaction(signo, &act, &oact) < 0)
    SOS_RETURN(SIG_ERR);
  SOS_RETURN(oact.sa_handler);
}


static int awakened;
static void sig_cont(int signo);
static void sig_cont(int signo)
{
  /* 
   * Our little dirty secret. We steal sig_tstp from the user and use it 
   * ourself. If the user doesn't want this to happen, he shoule consider 
   * using sos_signal_suspend()
   */
  awakened=1;
  return;
}


/* 
 * Suspend a process (job control assmed -- we cannot reliable check for it 
 * here, since the disposition of SIGTSTP may have been altered by the 
 * calling process. Save the signal actio, save the current terminal settings,
 * set (restore) any terminal settings the caller may desire, suspend, and,
 * finally, reset everything.
 * 
 * This routine might not be correctly named. 
 */
int sos_signal_suspend(int fd, struct termios *oldterm,int sig)
{
  SOS_ENTRY("sos_signal",__FUNCTION__,NULL);
  int ret=0;
  sos_sigfunc *cont;
  struct termios savedterm;
  
  if ( sig != SIGSTOP && sig != SIGTSTP && sig != 0 )
    {
      sos_error_printf("Illegal arguments\n");
      SOS_RETURN(-1);
    }

  if ( sig == 0 ) sig=SIGTSTP;

  /* Get and save current terminal setting, restoring oldterm if set. */
  if (fd >= 0 && sos_tty_set(fd, oldterm, &savedterm) != 1 )
    SOS_RETURN(-1);

  /* Steal SIGCONT (BAD, BAD thing for libraries to do). */
  cont = sos_signal(SIGCONT, sig_cont); 

  awakened=0;			/* XXXX -- NOT THREAD SAFE!!! */
  
  /* Kill yourself ( and on many archs your entire process group */
  if ( kill(0, sig) < 0 )
    {
      sos_error_printf("Failed to TSTP process: %s\n", strerror(errno));
    }

  /* 
   * This does *not* poll. This just *insures* that the commands following the 
   * poem cannot execute *before* the TSTP is delivered. Race condition 
   * pointed out by Seth Robinson (seth@soscorp.com).
   */
  while (!awakened ) sleep(1); 

  /* 
   * Rock a bye, process
   * in the sleep queue.
   * When SIGCONT arrives,
   * we'll get back to you.
   */

  /* restore current signal disposition */
  sos_signal(SIGCONT, cont);

  /* restore current terminal */
  if ( fd >=0 )
    sos_tty_set(fd, &savedterm, NULL);
  
  SOS_RETURN(ret);
}
