#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Retrieve/set file descriptor and socket options
 */

#include "sos.h"



/*
 * Add a socket option
 */
int sos_addsockopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_addsockopt",NULL);
  int one = 1;
  int onelen = sizeof(one);

  if (setsockopt(fd, SOL_SOCKET, option, (char *)&one, onelen) < 0)
    {
      sos_error_printf("Could not set socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Clear a socket option
 */
int sos_clrsockopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_clrsockopt",NULL);
  int zero = 0;
  int zerolen = sizeof(zero);

  if (setsockopt(fd, SOL_SOCKET, option, (char *)&zero, zerolen) < 0)
    {
      sos_error_printf("Could not clear socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Add a IP socket option
 */
int sos_addipopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_addipopt",NULL);
  int one = 1;
  int onelen = sizeof(one);
  struct protoent *p;

  if (!(p = getprotobyname("ip")))
    {
      sos_error_printf("Could not get protocol number for IP: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  if (setsockopt(fd, p->p_proto, option, (char *)&one, onelen) < 0)
    {
      sos_error_printf("Could not set IP socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Clear a IP option
 */
int sos_clripopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_clripopt",NULL);
  int zero = 0;
  int zerolen = sizeof(zero);
  struct protoent *p;

  if (!(p = getprotobyname("ip")))
    {
      sos_error_printf("Could not get protocol number for IP: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  if (setsockopt(fd, p->p_proto, option, (char *)&zero, zerolen) < 0)
    {
      sos_error_printf("Could not clear IP socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Add a TCP socket option
 */
int sos_addtcpopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_addtcpopt",NULL);
  int one = 1;
  int onelen = sizeof(one);
  struct protoent *p;

  if (!(p = getprotobyname("tcp")))
    {
      sos_error_printf("Could not get protocol number for TCP: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  if (setsockopt(fd, p->p_proto, option, (char *)&one, onelen) < 0)
    {
      sos_error_printf("Could not set TCP socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Clear a TCP option
 */
int sos_clrtcpopt(int fd, int option)
{
  SOS_ENTRY("sos_sfopts","sos_clrtcpopt",NULL);
  int zero = 0;
  int zerolen = sizeof(zero);
  struct protoent *p;

  if (!(p = getprotobyname("tcp")))
    {
      sos_error_printf("Could not get protocol number for TCP: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  if (setsockopt(fd, p->p_proto, option, (char *)&zero, zerolen) < 0)
    {
      sos_error_printf("Could not clear TCP socket option %d on fd %d: %s\n",option,fd,strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Add a FD status flag
 */
int sos_addfdflag(int fd, int flag)
{
  SOS_ENTRY("sos_sfopts","sos_addfdflag",NULL);
  int flags;

  if ((flags = fcntl(fd,F_GETFL,(FCNTL_ARG_T)NULL)) < 0)
    {
      sos_error_printf("Could not get current fd flags: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  flags |= flag;


  if ((flags = fcntl(fd,F_SETFL,(FCNTL_ARG_T)flags)) < 0)
    {
      sos_error_printf("Could not get current fd flags: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * Clear a FD status flag
 */
int sos_clrfdflag(int fd, int flag)
{
  SOS_ENTRY("sos_sfopts","sos_clrfdflag",NULL);
  int flags;

  if ((flags = fcntl(fd,F_GETFL,(FCNTL_ARG_T)NULL)) < 0)
    {
      sos_error_printf("Could not get current fd flags: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  flags &= (~flag);


  if ((flags = fcntl(fd,F_SETFL,(FCNTL_ARG_T)flags)) < 0)
    {
      sos_error_printf("Could not get current fd flags: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}
