#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Terminate string at first CR or LF found
 *
 * (e.g. RIP off EOL)
 */

#include "sos.h"

#define RIP_CHARS "\r\n"



/*
 * Turn first CR/LF found into a NULL
 */
char *sos_rip(char *x)
{
  SOS_ENTRY("sos_rip","sos_rip",NULL);
  char *ripped;

  if (!x)
    {
      sos_error_printf("No deposit no return--please supply a buffer to rip\n");
      SOS_RETURN(x);
    }

  if (!(ripped = strpbrk(x,RIP_CHARS)))
    SOS_RETURN(x);

  *ripped = '\0';
  SOS_RETURN(x);
}



/*
 * Turn CRLF sequences into NULL or CRNULL
 */
char *sos_fixcrnl(char *x, int stripnl)
{
  SOS_ENTRY("sos_rip","sos_fixcrnl",NULL);
  char *nl;

  if (!x)
    {
      sos_error_printf("No deposit no return--please supply a buffer to rip\n");
      SOS_RETURN(x);
    }

  for(nl = strchr(x,'\n');nl;nl = strchr(nl+1,'\n'))
    {
      if (nl > x && (*(nl-1) == '\r'))
	{
	  nl--;
	  if (!stripnl)
	    {
	      *(nl++) = '\n';
	    }
	  *(nl) = '\0';
	  break;
	}
    }

  SOS_RETURN(x);
}
