#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Set the process title via resetting the ARGV
 */

#include "sos.h"

#define MAXPROCLEN 2048

#ifndef MIN
# define	MIN(a, b) ((a) < (b) ? (a) : (b))
#endif /* MIN */

static char *ProcStart = NULL;
static char *MyProgram;
static int ProcLen;
static int UsableProcLen;
static char **origArgv;
static char **origEnvp;


/*
 * Initialize everything: make copies of the argv and environment for
 * the program to play with, and keep the process environment free
 * to mess with.
 */
int
sos_initProcTitle(int argc, char ***argv, char ***envp, char **program)
{
  SOS_ENTRY("sos_proctitle","sos_initProcTitle",NULL);
  int tmp;
  char **Argv;
  int envc;
  char **Envp;

  ProcStart = **argv;

  /* Some error checking */
  if (argc < 0 || !argv || !*argv || !envp || !*envp)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(-1);
    }

  /* Count number of environment entries */
  for(envc=0;(*envp)[envc];envc++) ;

  /* Get the new argv */
  if ((Argv = (char **)malloc(sizeof(char *) * (argc + 1))) == NULL)
    {
      sos_error_printf("Could not allocate %d bytes for new argv: %s\n",sizeof(char *) * (argc + 1),strerror(errno));
      SOS_RETURN(-1);
    }

  /* Get the new envp */
  if ((Envp = (char **)malloc(sizeof(char *) * (envc+1))) == NULL)
    {
      sos_error_printf("Could not allocate %d bytes for new envp: %s\n",sizeof(char *) * (envc+1),strerror(errno));
      SOS_RETURN(-1);
    }

  /* Get the orig argv */
  if ((origArgv = (char **)malloc(sizeof(char *) * (argc + 1))) == NULL)
    {
      sos_error_printf("Could not allocate %d bytes for preserved argv: %s\n",sizeof(char *) * (argc + 1),strerror(errno));
      SOS_RETURN(-1);
    }

  /* Get the orig envp */
  if ((origEnvp = (char **)malloc(sizeof(char *) * (envc+1))) == NULL)
    {
      sos_error_printf("Could not allocate %d bytes for preserved envp: %s\n",sizeof(char *) * (envc+1),strerror(errno));
      SOS_RETURN(-1);
    }

  /* Copy the argv */
  for(tmp = 0;tmp < argc; tmp++)
    {
      Argv[tmp] = strdup((*argv)[tmp]);
      if (!Argv[tmp])
	{
	  sos_error_printf("Could not strdup %s: %s\n",(*argv)[tmp],strerror(errno));
	  SOS_RETURN(-1);
	}
    }
  Argv[tmp] = NULL;

  /* Copy the Envp */
  for(tmp = 0;tmp < envc; tmp++)
    {
      /* XXX - should we censor anything */
      Envp[tmp] = strdup((*envp)[tmp]);
      if (!Envp[tmp])
	{
	  sos_error_printf("Could not strdup %s: %s\n",(*envp)[tmp],strerror(errno));
	  SOS_RETURN(-1);
	}
    }
  Envp[tmp] = NULL;

  /*
   * XXX - This seems very system dependent--does everyone lay the process
   * environment out in the same fashion?
   *
   * Note this is the true length.  Not all is usable.
   */
  ProcLen = ((*envp)[envc-1] + strlen((*envp)[envc-1])) - ProcStart;
  UsableProcLen = ProcLen - 2;


  /* Try to fool ps--but save the original pointers */
  (origArgv)[0] = (*argv)[0];
  for(tmp=1;tmp<=argc;tmp++)
    {
      (origArgv)[tmp] = (*argv)[tmp];
      (*argv)[tmp] = NULL;
    }
  for(tmp=0;tmp<=envc;tmp++)
    {
      (origEnvp)[tmp] = (*envp)[tmp];
      (*envp)[tmp] = NULL;
    }

  *argv = Argv;
  *envp = Envp;
  environ = Envp;

  /* Get program name without location information */
  MyProgram = strrchr(Argv[0], '/');
  if (!MyProgram)
    MyProgram = Argv[0];
  else
    MyProgram++;
  MyProgram = strdup(MyProgram);
  if (!MyProgram)
    {
      sos_error_printf("Could not strdup program name: %s\n",strerror(errno));
      SOS_RETURN(-1);
    }

  if (program)
    *program = MyProgram;

  SOS_RETURN(0);
}



/*
 * Set the process title (e.g. so that ps can see internal program state)
 */
int
sos_setProcTitle(char *fmt, ...)
{
  SOS_ENTRY("sos_proctitle","sos_setProcTitle",NULL);
  char buf[MAXPROCLEN];
  va_list args;
  int ret;
  char *t = buf;
  int ourlen;
  int prlen;
  int rem_buflen = MAXPROCLEN;

  if (UsableProcLen < 10)
    {
      /*
       * Should I sos_error here?  The obvious answer is yes, but if the upper
       * program chooses to not exit and runs this a few thousand times, we are
       * *really* wasting space
       */
      sos_error_printf("Buffer space too small\n");
      SOS_RETURN(-1);		/* Failsafe--if the available space is too small... */
    }

  prlen = snprintf(t, rem_buflen, "%s: ", MyProgram);
  t += strlen(t);

  if ((rem_buflen -= prlen) < 0)
    rem_buflen = 0;

  va_start(args, fmt);
  ret = vsnprintf(t, rem_buflen, fmt, args);
  va_end(args);

  /*
   * The following stupidity is because of ``bugs'' in Sun's (and
   * others?) method of getting argv and envp for ps and friends.
   * Basically, it cannot tell the difference between environment and
   * arguments and tries to figure it out by saying that the *last*
   * argv[] entry is one *previous* the last entry with a equal sign in
   * it.
   *
   * So, if you could do a ps of `echo x=y` while it was running,
   * you would only see `echo`.  You would have to request the
   * environment to see the x=y argument.  Stupid, no?
   *
   * The problem is that if the user is so foolish as to put
   * an equal sign in his proctitle, all hell breaks loose.
   * (for those still reading, the same would be true if you
   * named a program x=y and ran it without any arguments.)
   *
   * So what we do, is make an invisable argv[1] which consists of one
   * or more spaces.  These space allows the OS to figure out that we
   * are in the argv[] section of life and it will no longer treat
   * equal signs specially.
   *
   * Very intuitive, no?  This hardly took any time to debug... :-(
   *
   * Grr.
   */
  ourlen = MIN(UsableProcLen,strlen(buf));

  ProcStart[ProcLen] = '\0';
  memset(ProcStart, ' ', ProcLen);

  strncpy(ProcStart, buf, ourlen); /* Set the new argv[0] */
  ProcStart[ourlen] = '\0';	   /* Terminate the argv[0] */

  /* Note: Everything from ourlen to ProcLen is spaces */

  SOS_RETURN(ret);
}
