#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Stupid path name utilities. Why aren't these supported everwhere????
 */

#include "sos.h"



/*
 * Find the directory component--returns malloced space
 */
char *
sos_pathutils_dirname(char *lfilename)
{
  SOS_ENTRY("sos_pathutils", "sos_pathutils_dirname", "lfilename: %s", lfilename);

  char *dirname=NULL;
  char *eos=NULL;
  char *trailing=NULL;
  char *filename=NULL;
  int len;

  if ( !lfilename || (len=strlen(lfilename)) > MAXPATHLEN ) 
    {
      sos_error_printf("Invalid argument");
      SOS_RETURN(NULL);
    }

  if ( SOS_STREQ(lfilename,"/" ) )
      {
	SOS_RETURN ("/");
      }

  if ( len == 0 )
    {
      SOS_RETURN (".");
    }

  if (!(filename=strdup(lfilename)))  
    {
      sos_error_printf("strdup failed");
      SOS_RETURN (NULL);
    }

  /* Check for trailing slash */
  if ( filename[len-1] == '/' )
    {
      trailing = filename+len-1;
      *trailing = '\0';
    }

  if ( (eos=strrchr (filename, '/')) == NULL )
    dirname=strdup(".");
  else
    {
      *eos='\0';
      if (!(dirname=strdup(filename)))
	{
	  sos_error_printf("strdup failed");
	  free(filename);
	  SOS_RETURN (NULL);
	}
      *eos='/';
      if ( trailing ) *trailing='/';
    }

  free(filename);
  SOS_RETURN (dirname);
}



/*
 * Find the filename without directory information
 * Returns malloced space
 */
char *
sos_pathutils_basename(char *lfilename)
{
  SOS_ENTRY("sos_pathutils", "sos_pathutils_basename", "lfilename: %s", lfilename);

  char *basename=NULL;
  char *eos;
  char *trailing=NULL;
  char *filename;
  int len;

  if ( !lfilename || (len=strlen(lfilename)) > MAXPATHLEN )
    {
      sos_error_printf("Invalid argument\n");
      SOS_RETURN(NULL);
    }

  if ( SOS_STREQ(lfilename, "/") )
    {
      /* Return NULL of lfilename is simply "/" */
      SOS_RETURN ("");
    }

  if ( len == 0 )
    {
      SOS_RETURN ("");
    }


  if (!(filename=strdup(lfilename)))  
    {
      sos_error_printf("strdup failed");
      SOS_RETURN (NULL);
    }

  /* Check for trailing slash */
  if ( filename[len-1] == '/' )
    {
      trailing = filename+len-1;
      *trailing = '\0';
    }

  if ( (eos=strrchr (  filename, '/')) == NULL )
    {
      basename=strdup(filename);
    }
  else
    {
      *eos='\0';
      if (!(basename=strdup(eos+1)))
	{
	  sos_error_printf("strdup failed");
	  free(filename);
	  SOS_RETURN (NULL);
	}
      *eos='/';
      if ( trailing ) *trailing='/';
    }

  free(filename);
  SOS_RETURN (basename);
}
