#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Get a socket which can be accepted...
 */

#include "sos.h"



/*
 * Get a socket and bind to it
 */
int
sos_get_conn(struct in_addr *intf, int port, int socopts, struct sos_conninfo *info)
{
  SOS_ENTRY("sos_get_conn","sos_get_conn",NULL);
  struct sockaddr_in sinhim;
  int sock;
  int one=1;

  memset(&sinhim,0,sizeof(struct sockaddr_in));
  sinhim.sin_family = AF_INET;
#ifdef HAVE_SOCKADDR_LEN
  sinhim.sin_len = sizeof(struct sockaddr_in);
#endif

  /* Get a socket */
  if ((sock = socket(sinhim.sin_family, SOCK_STREAM, 0)) < 0)
    {
      sos_error_printf("Could not create socket: %s\n",strerror(errno));
      SOS_RETURN(sock);
    }
  /* Set options, if requested */
  if (socopts)
    if (setsockopt(sock, SOL_SOCKET, socopts, (char *)&one, sizeof(one)) < 0)
      {
	sos_error_printf("Could not set socket options (%d): %s\n",socopts,strerror(errno));
	close(sock);
	sock = -1;
	SOS_RETURN(sock);
      }

  /* Initialize the socket address */
  sinhim.sin_port = SOS_HTONS(port);
  if (intf)
    {				/* Bind to a specific interface */
      memcpy((void *)&(sinhim.sin_addr),(void *)intf,sizeof(struct in_addr));
    }
  else
    {				/* Bind to all interfaces */
      sinhim.sin_addr.s_addr = INADDR_ANY;
    }
  
  /* Bind the socket */
  if (bind(sock, (struct sockaddr *)&sinhim, sizeof(sinhim)) < 0)
    {
      sos_error_printf("Could not bind to socket: %s\n",strerror(errno));
      close(sock);
      sock = -1;
      SOS_RETURN(sock);
    }

  if (listen(sock, 9) < 0)
    {
      sos_error_printf("Could not listen to socket: %s\n",strerror(errno));
      close(sock);
      sock = -1;
      SOS_RETURN(sock);
    }

  if (info)
    {
      memset((void *)info,0,sizeof(struct sos_conninfo));
      info->port = port;
      info->fd = sock;
    }

  SOS_RETURN(sock);
}



/*
 * get_conn with service name lookups
 */
int
sos_get_conn_by_service(struct in_addr *intf, char *port, int socopts, struct sos_conninfo *info)
{
  SOS_ENTRY("sos_get_conn","sos_get_conn_by_service",NULL);
  int numport;

  if (!port)
    {
      sos_error_printf("Invalid argument\n");
      SOS_RETURN(-1);
    }

  if ((numport = sos_getsbyfoo(port)) < 1)
    {
      sos_error_printf("Unknown port (%s)\n",port);
      SOS_RETURN(-1);
    }

  SOS_RETURN(sos_get_conn(intf, numport, socopts, info));
}



/*
 * Get a socket and bind to it
 */
int
sos_get_uconn(struct in_addr *intf, int port, int socopts, struct sos_conninfo *info)
{
  SOS_ENTRY("sos_get_conn","sos_get_uconn",NULL);
  struct sockaddr_in sinhim;
  int sock;
  int one=1;

  memset((void *)&sinhim,0,sizeof(sinhim));
  sinhim.sin_family = AF_INET;

  /* Get a socket */
  if ((sock = socket(sinhim.sin_family, SOCK_DGRAM, 0)) < 0)
    {
      sos_error_printf("Could not create socket: %s\n",strerror(errno));
      SOS_RETURN(sock);
    }

  /* Set options, if requested */
  if (socopts)
    if (setsockopt(sock, SOL_SOCKET, socopts, (char *)&one, sizeof(one)) < 0)
      {
	sos_error_printf("Could not set socket options (%d): %s\n",socopts,strerror(errno));
	close(sock);
	sock = -1;
	SOS_RETURN(sock);
      }

  /* Initialize the socket address */
  sinhim.sin_port = SOS_HTONS(port);
  if (intf)
    {				/* Bind to a specific interface */
      memcpy((void *)&(sinhim.sin_addr),(void *)intf,sizeof(struct in_addr));
    }
  else
    {				/* Bind to all interfaces */
      sinhim.sin_addr.s_addr = INADDR_ANY;
    }

  /* Bind the socket */
  if (bind(sock, (struct sockaddr *)&sinhim, sizeof(sinhim)) < 0)
    {
      sos_error_printf("Could not bind to socket: %s\n",strerror(errno));
      close(sock);
      sock = -1;
      SOS_RETURN(sock);
    }

  if (info)
    {
      memset((void *)info,0,sizeof(struct sos_conninfo));
      info->port = port;
      info->fd = sock;
    }

  SOS_RETURN(sock);
}



/*
 * get_conn with service name lookups
 */
int
sos_get_uconn_by_service(struct in_addr *intf, char *port, int socopts, struct sos_conninfo *info)
{
  SOS_ENTRY("sos_get_conn","sos_get_uconn_by_service",NULL);
  int numport;

  if (!port)
    {
      sos_error_printf("Invalid argument\n");
      SOS_RETURN(-1);
    }

  if ((numport = sos_getusbyfoo(port)) < 1)
    {
      sos_error_printf("Unknown port (%s)\n",port);
      SOS_RETURN(-1);
    }

  SOS_RETURN(sos_get_uconn(intf, numport, socopts, info));
}



/*
 * Get a unix socket and bind to it
 */
int
sos_get_unixconn(char *filename, int socopts, struct sos_conninfo *info)
{
  SOS_ENTRY("sos_get_conn","sos_get_unixconn",NULL);
  struct sockaddr_un sinhim;
  int sock;
  int one=1;

  if (!filename)
    {
      sos_error_printf("Invalid argument\n");
      SOS_RETURN(-1);
    }

  memset((void *)&sinhim,0,sizeof(sinhim));
  sinhim.sun_family = AF_UNIX;

  /* Get a socket */
  if ((sock = socket(sinhim.sun_family, SOCK_STREAM, 0)) < 0)
    {
      sos_error_printf("Could not create socket: %s\n",strerror(errno));
      SOS_RETURN(sock);
    }

  /* Set options, if requested */
  if (socopts)
    if (setsockopt(sock, SOL_SOCKET, socopts, (char *)&one, sizeof(one)) < 0)
      {
	sos_error_printf("Could not set socket options (%d): %s\n",socopts,strerror(errno));
	close(sock);
	sock = -1;
	SOS_RETURN(sock);
      }

  /* Initialize the socket address */
  strncpy(sinhim.sun_path, filename, sizeof(sinhim.sun_path));

  /* Bind the socket */
  if (bind(sock, (struct sockaddr *)&sinhim, sizeof(sinhim)) < 0)
    {
      sos_error_printf("Could not bind to socket: %s\n",strerror(errno));
      close(sock);
      sock = -1;
      SOS_RETURN(sock);
    }

  if (listen(sock, 9) < 0)
    {
      sos_error_printf("Could not listen to socket: %s\n",strerror(errno));
      close(sock);
      sock = -1;
      SOS_RETURN(sock);
    }

  if (info)
    {
      memset((void *)info,0,sizeof(struct sos_conninfo));
      info->fd = sock;
    }

  SOS_RETURN(sock);
}
