#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Perform various exec-like functions
 */

#include "sos.h"

#define T_END 0
#define T_START 1
#define T_SINGLEQ 2
#define T_DOUBLEQ 3
#define T_BACKSLASH 4

#define INS(NAME) (NAME == state)
#define DOES(NAME) (NAME & flags)



/*
 * Fork-and-exec
 *
 * Parent gets PID of child or -1 for error
 *
 * XXX - not tested
 */
int sos_fork_execve(char *path, char *argv[], char *envp[], int fds[3])
{
  SOS_ENTRY("sos_exec","sos_fork_execve",NULL);
  int childpid;
  int i;

  switch (childpid = fork())
    {
    case -1:			/* Error */
      sos_error_printf("Could not fork: %s\n",strerror(errno));
      SOS_RETURN(-1);
      /*NOTREACHED*/
      break;

    case 0:			/* Child */
      if (dup2(fds[0], 0) < 0)
	;			/* Something dramatic (but what?) */
      if (dup2(fds[1], 1) < 0)
	;			/* Something dramatic (but what?) */
      if (dup2(fds[2], 2) < 0)
	;			/* Something dramatic (but what?) */

      for (i = 3; i < sos_getdtablesize(); i++)
	close(i);		/* also closes fds[] */

      execve(path,argv,envp);
      /* Something dramatic (but what?) */
      _exit(1);
      /*NOTREACHED*/
      break;

    default:			/* Parent */
      SOS_RETURN(childpid);
      /*NOTREACHED*/
      break;
    }

  sos_error_printf("Should never happen\n");
  SOS_RETURN(-1);		/* Something is wrong... */
}



/*
 * shell-exec
 *
 * Parse line with supplied IFS (NULL means SOS_WHITESPACE),
 * exec resulting program using PATH.
 */
int sos_shexecvp(char *cmd, char *IFS, int flags)
{
  SOS_ENTRY("sos_exec","sos_shexecvp",NULL);
  char *argv[_POSIX_ARG_MAX];
  char *cur;
  int x = 0;

  if (!IFS)
    IFS = SOS_WHITESPACE;

  if (!cmd)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(-1);
    }

  if (!flags)
    {
      for (cur = strtok(cmd,IFS); cur; cur = strtok(NULL,IFS))
	{
	  argv[x++] = cur;
	}
    }
  else
    {
      x = sos_shtokenize(cmd, IFS, flags, argv, _POSIX_ARG_MAX);
      argv[x] = NULL;
    }

  if (x <= 0)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(-1);
    }

  if ((x = execvp(argv[0],argv)) < 0)
    {
      sos_error_printf("Could not exec %s: %s\n",argv[0],strerror(errno));
      SOS_RETURN(-1);
    }

  SOS_RETURN(0);
}



/*
 * shell-like tokenize routines
 *
 * Handles: backslash quoting, double quotes, single quotes
 *
 * Does not handle: variable expansion, backtick commands
 */
int sos_shtokenize(char *line, char *IFS, int flags, char *argv[], int maxargc)
{
  SOS_ENTRY("sos_exec","sos_shtokenize",NULL);
  int curargc = 0;
  int curpos = 0;
  int state = T_START;
  char *cur = line;
  char TOKEN[512];

  if (!IFS)
    IFS = SOS_WHITESPACE;

  if (!line)
    {
      SOS_RETURN(0);		/* Nothing to do */
    }

  cur += strspn(cur, IFS); /* Skip over any leading IFS characters */
  
  while (state)
    {
      if (!*cur)
	{
	  if (!INS(T_START))
	    {
	      sos_error_printf("Ran out of line while inside quoting\n");
	      SOS_RETURN(-3);
	    }
	  if (curpos)
	    {
	      TOKEN[curpos++] = '\0';
	      if ((argv[curargc++] = strdup(TOKEN)) == NULL)
		{
		  sos_error_printf("Could not duplicate %s: %s\n",TOKEN,strerror(errno));
		  SOS_RETURN(-1);
		}
	      if (curargc > maxargc)
		{
		  sos_error_printf("Too many arguments found\n");
		  SOS_RETURN(-2);
		}
	    }
	  SOS_RETURN(curargc);
	}

      if (!INS(T_SINGLEQ) && DOES(SOS_SHTOK_BACKSLASH) && *cur == '\134')
	{
	  if (!(*++cur))
	    {			/* Cause error to occur */
	      state = T_BACKSLASH;
	      continue;
	    }

	  TOKEN[curpos++] = *cur;
	  cur++;
	  continue;
	}

      if (INS(T_START) && DOES(SOS_SHTOK_DOUBLEQ) && *cur == '"')
	{
	  state = T_DOUBLEQ;
	  cur++;
	  continue;
	}

      if (INS(T_DOUBLEQ) && *cur == '"')
	{
	  state = T_START;
	  cur++;
	  continue;
	}

      if (INS(T_START) && DOES(SOS_SHTOK_SINGLEQ) && *cur == '\047')
	{
	  state = T_SINGLEQ;
	  cur++;
	  continue;
	}

      if (INS(T_SINGLEQ) && *cur == '\047')
	{
	  state = T_START;
	  cur++;
	  continue;
	}

      if (INS(T_START) && strchr(IFS,*cur))
	{
	  TOKEN[curpos++] = '\0';
	  if ((argv[curargc++] = strdup(TOKEN)) == NULL)
	    {
	      sos_error_printf("Could not duplicate %s: %s\n",TOKEN,strerror(errno));
	      SOS_RETURN(-1);
	    }
	  if (curargc > maxargc)
	    {
	      sos_error_printf("Too many arguments found\n");
	      SOS_RETURN(-2);
	    }
	  curpos = 0;
	  cur += strspn(cur, IFS); /* Skip over all IFS characters */
	  continue;
	}

      TOKEN[curpos++] = *cur++;
    }
  SOS_RETURN(-1);
}
