#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * daemonize the current program
 */

#include "sos.h"


#define DEVNULL "/dev/null"
#define DEVTTY "/dev/tty"



/*
 * daemonize the current program
 *
 * Allow capability flags for various features
 */
int sos_daemon(int flags)
{
  SOS_ENTRY("sos_daemon","sos_daemon",NULL);
  int x, y;
  int tablesize = sos_getdtablesize();

  /* fork to nuke parent */
  if (flags & SOS_DAEMON_FORK)
    {
      switch(fork())
	{
	case -1:
	  sos_error_printf("Could not fork: %s\n",strerror(errno));
	  SOS_RETURN(-1);
	case 0:
	  break;
	default:
	  _exit(0);
	}
    }

  /* Close all fds */
  if (flags & SOS_DAEMON_CLOSEALL)
    {
      for(x=0;x < tablesize;x++)
	close(x);
    }
  else if (flags & SOS_DAEMON_CLOSEHIGH)
    {				/* Close all high fds */
      for(x=3;x < tablesize;x++)
	close(x);
    }

  /* Get rid of anything dealing with ttys */
  if (flags & SOS_DAEMON_NOTTY)
    {
      /* Close all TTY related file descriptors */
      for (x=0;x<tablesize;x++)
	{
	  if (isatty(x))
	    {
	      close(x);
	    }
	}
      /* Nuke TTY related job control signals */
#ifdef SIGTTOU
      if (sos_signal(SIGTTOU, SIG_IGN) == SIG_ERR)
	{
	  sos_error_printf("Could not turn off SIGTTOU\n");
	  SOS_RETURN(-1);
	}
#endif /* SIGTTOU */
#ifdef SIGTTIN
      if (sos_signal(SIGTTIN, SIG_IGN) == SIG_ERR)
	{
	  sos_error_printf("Could not turn off SIGTTIN\n");
	  SOS_RETURN(-1);
	}
#endif /* SIGTTIN */
#ifdef SIGTSTP
      if (sos_signal(SIGTSTP, SIG_IGN) == SIG_ERR)
	{
	  sos_error_printf("Could not turn off SIGTSTP\n");
	  SOS_RETURN(-1);
	}
#endif /* SIGTSTP */

#ifdef SUN_GOT_TIOCNOTTY_RIGHT
      /*
       * It is defined in the include files, but my friends with
       * Solaris source say it doesn't appear in the kernel--and when
       * I call it it gives me EINVAL.  Sigh.
       *
       * Hopefully setsid will take up the slack
       *
       * XXX - Why don't I do this for non-Solaris?  Hmm.
       */

      /* Bail on controlling tty */
#ifdef TIOCNOTTY
      if ((y = open(DEVTTY, O_RDWR)) < 0)
	{
	  sos_error_printf("Could not open %s: %s\n",DEVTTY,strerror(errno));
	  SOS_RETURN(-1);
	}
      if (ioctl(y,TIOCNOTTY, NULL) == -1)
	{
	  sos_error_printf("Could not ioctl TIOCNOTTY: %s\n",strerror(errno));
	  SOS_RETURN(-1);
	}
      close(y);
#endif /* TIOCNOTTY */
#endif /* SUN_GOT_TIOCNOTTY_RIGHT */
    }

  /* Make self session and process group leader */
  if (flags & SOS_DAEMON_SID)
    {
      if (setsid() == -1)
	{
	  sos_error_printf("Could not setsid: %s\n",strerror(errno));
	  SOS_RETURN(-1);
	}
    }

  /* Bail on normal keyboard-generated signals */
  if (flags & SOS_DAEMON_SIGNAL)
    {
#ifdef SIGHUP
      if (sos_signal(SIGHUP, SIG_IGN) == SIG_ERR)
	{
	  sos_error_printf("Could not turn off SIGHUP: %s\n",strerror(errno));
	  SOS_RETURN(-1);
	}
#endif /* SIGHUP */
#ifdef SIGQUIT
      if (sos_signal(SIGQUIT, SIG_IGN) == SIG_ERR)
	{
	  sos_error_printf("Could not turn off SIGQUIT: %s\n",strerror(errno));
	  SOS_RETURN(-1);
	}
#endif /* SIGQUIT */
    }

  /* Get off possibly mounted FS */
  if (flags & SOS_DAEMON_CHDIR)
    {
      if (chdir("/") == -1)
	{
	  sos_error_printf("Could not chdir(/): %s\n",strerror(errno));
	  SOS_RETURN(-1);
	}
    }

  /* No inherited umask */
  if (flags & SOS_DAEMON_UMASK)
    {
      umask(0);
    }

  /* Make sure the standard file descriptors are open, if only to /dev/null */
  if (flags & SOS_DAEMON_STDFDOPEN)
    {
      for(x=0;x<3;x++)
	{
	  if (fcntl(x,F_GETFL,(FCNTL_ARG_T)NULL) == -1)
	    {
	      if (errno == EBADF)
		{
		  if ((y = open(DEVNULL,O_RDWR)) == -1)
		    {
		      sos_error_printf("Could not open %s: %s\n",DEVNULL,strerror(errno));
		      SOS_RETURN(-1);
		    }
		  if (y != x)
		    {		/* Should not happen */
		      if (dup2(y,x) == -1)
			{
			  sos_error_printf("Could not dup2(%d,%d): %s\n",y,x,strerror(errno));
			  SOS_RETURN(-1);
			}
		      close(y);
		    }
		}
	    }
	}
    }

  if (flags & SOS_DAEMON_NUKEENV)
    {
      environ = NULL;
    }
  SOS_RETURN(0);
}
