#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Memory allocation stuff for sos_strings
 */

#include "sos.h"



/*
 * Allocate space inside sos_string and possibly the sos_string itself
 */
sos_string *sos_allocstr(sos_string *buf, int size)
{
  SOS_ENTRY("sos_alloc","sos_allocstr","(%x,%d)",buf,size);

  if (size < 1)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(NULL);
    }

  if (!buf && !(buf = (sos_string *)malloc(sizeof(sos_string))))
    {
      sos_error_printf("Could not allocate sos_string (%d bytes): %s\n",sizeof(sos_string),strerror(errno));
      SOS_RETURN(NULL);
    }

  buf->len = size;
  if (!(buf->str = (char *)malloc(size)))
    {
      sos_error_printf("Could not allocate buffer (%d bytes): %s\n",size,strerror(errno));
      SOS_RETURN(NULL);
    }

  SOS_RETURN(buf);
}


/*
 * Allocate a and return a new sos_string which strdups the argument into
 * the str field. If buf is supplied this buffer is used instead of a new
 * one allocated. buf is assumed to be a NULL terminated string. 
 */
sos_string *sos_allocstr_buf(sos_string *sosbuf, char *strbuf)
{
  SOS_ENTRY("sos_alloc",__FUNCTION__,NULL);
  int len;

  if ( !strbuf )
    {
      sos_error_printf("Invalid arguments");
      SOS_RETURN(NULL);
    }

  len = strlen(strbuf)+1;	/* Don't forget the NULL */

  if (!sosbuf && !(sosbuf = (sos_string *)malloc(sizeof(sos_string))))
    {
      sos_error_printf("Could not allocate sos_string (%d bytes): %s\n",sizeof(sos_string),strerror(errno));
      SOS_RETURN(NULL);
    }


  
  if ( (sosbuf->str=malloc(len)) == NULL )
    {
      sos_error_printf("strdup failed allocating for %s: %s", strbuf, 
		       strerror(errno));
      SOS_RETURN(NULL);
      free(sosbuf);
    }

  memcpy(sosbuf->str, strbuf, len);
  sosbuf->len = len;
  SOS_RETURN(sosbuf);
}



/*
 * Free the allocated string
 * XXX - note will NOT free the actual sos_string
 * even though we might have created it above
 */
void sos_freestr(sos_string *buf)
{
  SOS_ENTRY("sos_alloc","sos_freestr","(%x)",buf);

  if (buf->str)
    {
      free(buf->str);
    }

  buf->len = 0;
  buf->str = NULL;

  SOS_VRETURN();
}
