/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Unix declarations
 *
 * Standard include files plus definitions the OS did not see fit to include
 */

#ifndef _bs_unix_decl_h
#define _bs_unix_decl_h

#ifdef _WIN32
# include <sosnt.h>
# include <sys/fcntl.h>
# include <io.h>
#endif /* _WIN32 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <fcntl.h>
#include <math.h>
#include <memory.h>
#include <termios.h>

#if defined(__sun__) && defined(__svr4__)
#undef __P					/* Stupid Solaris defines this in math.h */
#endif /* SOLARIS */

#ifndef _WIN32
# include <netdb.h>
#endif /* !_WIN32 */

#ifndef _WIN32
# include <sys/socket.h>
# include <sys/file.h>
#endif /* !_WIN32 */

#include <sys/wait.h>
#include <sys/un.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <limits.h>

#ifndef _WIN32
# if defined(SOS_BSDI1) || defined(__linux__)
#  include <sys/ioctl.h>
# else /* SOS_BSDI1 || __linux__ */
#  include <sys/filio.h>
# endif /* SOS_BSDI1 || __linux__ */
#endif /* !_WIN32 */

#ifndef _WIN32
# include <netinet/in.h>
# include <netinet/tcp.h>
# include <arpa/inet.h>
#endif /* !_WIN32 */

/* CLC routines */
#include "dict.h"
#include "bst.h"
#include "dll.h"
#include "ht.h"
#include "pq.h"


/*********************************************************************
 *				 Endianess			     *
 *********************************************************************/

#if defined ( __i386__ )
#define SOS_BYTE_ORDER = SOS_LITTLE_ENDIAN

#define SOS_HTONQ(f) ((f>>56)&0xffLL|			\
		      (f>>40)&0xff00LL|			\
		      (f>>24)&0xff0000LL|		\
		      (f>>8)&0xff000000LL|		\
		      (f<<8)&0xff00000000LL|		\
		      (f<<24)&0xff0000000000LL|		\
		      (f<<40)&0xff000000000000LL|	\
		      (f<<56)&0xff00000000000000LL )
#define SOS_NTOHQ SOS_HTONQ
#else
#define SOS_BYTE_ORDER = SOS_BIG_ENDIAN
#define SOS_HTONQ(f) (f)
#define SOS_NTOHQ SOS_HTONQ
#endif /* Endianess */

/*
 * Well, there is no int conversion, so make a level of indirection
 * and we need to define these here so that we can appropriately define
 * SOS_QUAD_IS_LONG. Besides they could be useful for routines yet to be
 * written
 */
#define SOS_HTONL htonl
#define SOS_HTONI (int)htonl
#define SOS_HTONS htons
#define SOS_NTOHL ntohl
#define SOS_NTOHI (int)ntohl
#define SOS_NTOHS ntohs


/* Set this up as memmove by default. Overide if necessary */
#define SOS_OVERLAPPING_MOVE(d,s,l) memmove(d,s,l);

/*
 * type of the third argument to
 *		fcntl(int fd, int cmd, int arg, ...)
 * sometimes it's int and sometimes it's void *
 */
#define FCNTL_ARG_T	int

/*********************************************************************
 *		    Constants they really should define		     *
 *********************************************************************/
     
/* 
 * These MACROS *assume* a great deal about the structure of integers 
 * Caveat Emptor
 */
#define SOS_HIBITC ( 1 << ((8 * sizeof(char))-1))
#define SOS_MAXCHAR ((int)(~SOS_HIBITC))
#define SOS_MINCHAR SOS_HIBITC
#define SOS_MAXUCHAR ((u_int)(SOS_HIBITC | SOS_MAXCHAR))

#define SOS_HIBITS ( 1 << ((8 * sizeof(short))-1))
#define SOS_MAXSHORT ((short)(~SOS_HIBITS))
#define SOS_MINSHORT SOS_HIBITS
#define SOS_MAXUSHORT ((u_short)(SOS_HIBITS | SOS_MAXSHORT))

#define SOS_HIBITI ( 1 << ((8 * sizeof(int))-1))
#define SOS_MAXINT ((int)(~SOS_HIBITI))
#define SOS_MININT SOS_HIBITI
#define SOS_MAXUINT ((u_int)(SOS_HIBITI | SOS_MAXINT))

#define SOS_HIBITL ( 1 << ((8 * sizeof(long))-1))
#define SOS_MAXLONG ((long)(~SOS_HIBITL))
#define SOS_MINLONG SOS_HIBITL
#define SOS_MAXULONG ((u_long)(SOS_HIBITL | SOS_MAXLONG))


/* This is true for most archs. Modify in the arch-specific section if not */
#define SOS_MAXTIME SOS_MAXLONG

/*********************************************************************
 *                              SunOS                                *
 *********************************************************************/
#if defined(__sun__) && !defined(__svr4__)

#include <malloc.h>
#include <sys/vfs.h>

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *rindex(char *s, char c);
extern char *memalign(unsigned alignment, unsigned size);
extern char *crypt(const char *, const char *);
extern char *strerror(int errno);
extern int getpeername(int, struct sockaddr *, int *);
extern int getsockname(int, struct sockaddr *, int *);

/* SunOS doesn't have memmove but memcpy seems to do the RightThing(tm) */
#undef SOS_OVERLAPPING_MOVE
#define SOS_OVERLAPPING_MOVE(d,s,l) bcopy(s,d,l);

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs		/* Actual text for call */
#define SOS_FSTATFS fstatfs		/* Actual text for call */
#define SOS_FSIZE(s) ((s).f_bsize)	/* Fundamental block size */
#define SOS_FINODE(s) ((s).f_ffree)	/* Free inodes (non-super if filled) */

#endif /* SUNOS */


/*********************************************************************
 *                             Solaris                               *
 *********************************************************************/
#if defined(__sun__) && defined(__svr4__)

#include <sys/sysmacros.h>
#include <sys/statvfs.h> /* Use statvfs as statfs is a compat header */

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *crypt(const char *, const char *);

/* STATFS stuff */
typedef ulong sos_fslong_t;
typedef struct statvfs sos_tmpstatfs;
#define SOS_STATFS statvfs
#define SOS_FSTATFS fstatvfs
#define SOS_FSIZE(s) ((s).f_frsize)
#define SOS_FINODE(s) ((s).f_favail)

#endif /*SOLARIS*/


/*********************************************************************
 *                               HPUX                                *
 *********************************************************************/
#if defined(__hpux__)

#define memalign(x,y) malloc(y)

extern char **environ;

/*
 * There is no way to fix this correctly unfortunately.
 * HPUX 9.01 declares fd_set and such in header files, but the select()
 * system call seems to want an int, according to the man page select(2).
 * Furthermore, the header files for HPUX-9.01 don't even prototype the
 * syscall, but set it as "extern int select()".  HP's fault.
 */
extern int select();

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs
#define SOS_FSTATFS fstatfs
#define SOS_FSIZE(s) ((s).f_bsize)
#define SOS_FINODE(s) ((s).f_ffree)

#endif /*HPUX*/


/*********************************************************************
 *                               BSDI                                *
 *********************************************************************/
#if defined(__bsdi__)

#include <sys/mount.h>

#define memalign(x,y) malloc(y)

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern time_t timelocal(struct tm * const tmp);

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs
#define SOS_FSTATFS fstatfs
#define SOS_FINODE(s) ((s).f_ffree)

#if defined(SOS_BSDI1)
#define SOS_FSIZE(s) ((s).f_fsize)
#endif /* SOS_BSDI1 */

#if defined(SOS_BSDI2)
#define SOS_FSIZE(s) ((s).f_bsize) /* BSDI 2.0 */
#endif /* SOS_BSDI2 */

#define SOS_ANTIRAW (IGNBRK|BRKINT|IGNPAR|PARMRK|INPCK|ISTRIP|INLCR|IGNCR|ICRNL|IXON|IXOFF)

#endif /* BSDI */


/*********************************************************************
 *                               IRIX                                *
 *********************************************************************/
#if defined(__sgi__)

#include <sys/statvfs.h> /* Use statvfs as statfs is a compat header */

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *crypt(const char *, const char *);

/* STATFS stuff -- Perhaps this should be moved to sgi&&svr4?  */
typedef ulong_t sos_fslong_t;
typedef struct statvfs sos_tmpstatfs;
#define SOS_STATFS statvfs
#define SOS_FSTATFS fstatvfs
#define SOS_FSIZE(s) ((s).f_frsize)
#define SOS_FINODE(s) ((s).f_favail)

#endif /* IRIX */


/*********************************************************************
 *                              Linux                                *
 *********************************************************************/
#if defined(__linux__)

#include <asm/statfs.h>
#include <sys/vfs.h>
#ifdef _BSD_SOURCE
#undef _BSD_SOURCE
#endif /* _BSD_SOURCE */
#include <bsd/bsd.h>

typedef u_long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;

/* #define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) { sa_handler, sa_mask, sa_flags } */
#define SOS_STATFS statfs
#define SOS_FSTATFS fstatfs
#define SOS_FSIZE(s) ((s).f_bsize)
#define SOS_FINODE(s) ((s).f_ffree)

/* linux does not have SIGEMT and SIGSYS, so fake numbers as signals */
#define SIGEMT 200
#define SIGSYS 201

#endif /* linux */


/*********************************************************************
 *                            Windows NT                             *
 *********************************************************************/
#if defined(_WIN32)

#ifdef __GNUC__

#include <sys/statfs.h>
/*
 * Definitions for UNIX IPC domain.
 * This is a hack.  NT does not appear to support unix domain sockets.
 */
struct sockaddr_un {
	short sun_family;	/* AF_UNIX */
	char sun_path[108];	/* path name (gag) */
};
/* to get some socket definitions */
#define __INSIDE_CYGWIN_NET__
/* additional error numbers (from GNU's <mywinsock.h>) */
/*
 * All Windows Sockets error constants are biased by WSABASEERR from
 * the "normal"
 */
#define WSABASEERR              10000
/*
 * Windows Sockets definitions of regular Berkeley error constants
 */
#define WSAEINPROGRESS          (WSABASEERR+36)
#define WSAEALREADY             (WSABASEERR+37)
/*
 * Windows Sockets errors redefined as regular Berkeley error constants
 */
#define EINPROGRESS             WSAEINPROGRESS
#define EALREADY                WSAEALREADY
/* stat() definitions */
#define SOS_STATFS statfs
typedef struct statfs sos_tmpstatfs;
typedef u_long sos_fslong_t;

#else /* __GNUC__ */
/****************************************************************************/
/* externals */
extern char **environ;

/* stat()/statfs() definitions */
#include <sys/statfs.h>
#define SOS_STATFS	statfs
#define SOS_FSTATFS	fstatfs
#define SOS_FSIZE(s)	((s).f_fsize)
#define SOS_FINODE(s)	((s).f_ffree)
typedef struct statfs	sos_tmpstatfs;
typedef u_long		sos_fslong_t;

/* only gcc knows about __FUNCTION__, so default to file name */
#define __FUNCTION__	__FILE__

/* I'll define quads and other sizes myself here */
#define SOS_HAVE_QUAD
typedef quad_t		sos_quad_t;
typedef uquad_t		sos_uquad_t;
#define __SIZE_TYPE__	size_t
typedef u_long		sos_fslong_t;

#undef SOS_HTONS
#define SOS_HTONS(x) htons((u_short)(x))

/*
 * This is so the line "sysconf(_SC_CLK_TCK)" in getrand.c will succeeed.
 */
#define sysconf(x)	(0)

/*
 * Type of 3rd argument to fcntl()
 */
#undef	FCNTL_ARG_T
#define FCNTL_ARG_T	void *
/*
 * let's hope this works, or else I have to do fcntl() for sockets
 * correctly, and implement F_GETFL as getsockopt() and friends.
 */
#define SOLARIS_GOT_FIONBIO_RIGHT

/*
 * NT barely has any kind of TTY support (it's all GUI),
 * so assume they always succeed.
 */
#define tcgetattr(fd, old)		(0)
#define tcsetattr(fd, arg, old)		(0)

/* DEBUGGING */
#if 1
# undef EZKDBG
# define EZKDBG	fprintf(stderr, "%s:%d\n", __FILE__, __LINE__)
#endif


/****************************************************************************/
#endif /* !__GNUC__ */

#endif /* _WIN32 */


/*********************************************************************
 *                               MISC                                *
 *********************************************************************/
#ifndef _INTERRUPT_SYSCALLS_
#define _INTERRUPT_SYSCALLS_ 0
#endif /* _INTERRUPT_SYSCALLS_ */


/*
 * Some stupid systems (e.g. Solaris) define this in the wrong
 * place and installing a sane resolver (e.g. BIND) causes
 * this to go south.  **sigh**
 */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif /*!MAXHOSTNAMELEN*/

#ifndef _POSIX_ARG_MAX
#define _POSIX_ARG_MAX 4096
#endif /*!_POSIX_ARG_MAX*/

#ifndef SOS_ANTIRAW
#define SOS_ANTIRAW (IGNBRK|BRKINT|IGNPAR|PARMRK|INPCK|ISTRIP|INLCR|IGNCR|ICRNL|IXON|IXOFF|IUCLC)
#endif /* SOS_ANTIRAW */


#if defined(__sgi__) || defined(__svr4__)
# define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) \
	{ sa_flags, sa_handler, sa_mask }
#endif /* __sgi__ || __svr4__ */
#if defined(__linux__)
# define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) \
	{ (__sighandler_t) sa_handler, sa_mask, sa_flags, NULL }
#endif /* __linux__ */
#if defined(_WIN32)
# define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) \
	{ (void (*)(int)) sa_handler, sa_mask, sa_flags }
#endif /* _WIN32 */

/* default if none else defined */
#ifndef SIGACTIONDEFINE
#define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) { sa_handler, sa_mask, sa_flags }
#endif /* !SIGACTIONDEFINE */


/* Quad types
 * These are defined here so that we can simply set quad defines in the
 * platform specifications and have everything work
 */
#if !defined(SOS_NOQUAD) && !defined(SOS_HAVE_QUAD)
#ifdef SOS_QUAD_IS_LONG
typedef long sos_quad_t;
typedef unsigned long sos_uquad_t;
#define SOS_MAXQUAD SOS_MAXLONG
#define SOS_MINQUAD SOS_MINLONG
#undef SOS_HTONQ
#define SOS_HTONQ SOS_HTONL
#undef SOS_NTOHQ
#define SOS_NTOHQ SOS_NTOHL
#else
typedef long long int sos_quad_t;
typedef unsigned long long int sos_uquad_t;
#define SOS_HIBITQ ( 1 << ((8 * sizeof(sos_quad_t))-1))
#define SOS_MAXQUAD ((sos_quad_t)(~SOS_HIBITI))
#define SOS_MAXUQUAD ((sos_uquad_t)(SOS_HIBITI | SOS_MAXINT))
#define SOS_MINQUAD SOS_HIBITQ
#endif /* SOS_QUAD_IS_LONG */
#endif /* !SOS_NOQUAD && !SOS_HAVE_QUAD*/

#endif				/*!_bs_unix_decl_h */
