/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/github/ajalt/colormath/LAB;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "l", "", "a", "b", "(DDD)V", "getA", "()D", "getB", "getL", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toLAB", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/XYZ;", "colorconversion"})
public final class LAB
implements ConvertibleColor {
    private final double l;
    private final double a;
    private final double b;

    @Override
    @NotNull
    public RGB toRGB() {
        double d = this.l;
        return d == 0.0 ? new RGB(0, 0, 0) : this.toXYZ().toRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        if (this.l == 0.0) {
            return new XYZ(0.0, 0.0, 0.0);
        }
        double d = 0.20689655172413793;
        Function1<Double, Double> f$ = new Function1<Double, Double>(d){
            final /* synthetic */ double $d;

            public final double invoke(double t) {
                double d;
                if (t > this.$d) {
                    double d2 = t;
                    int n = 3;
                    d = Math.pow(d2, n);
                } else {
                    double d3 = this.$d;
                    int n = 2;
                    double d4 = 3;
                    double d5 = Math.pow(d3, n);
                    d = d4 * d5 * (t - 0.13793103448275862);
                }
                return d;
            }
            {
                this.$d = d;
                super(1);
            }
        };
        double lp = (this.l + (double)16) / (double)116;
        double x = 0.95047 * f$.invoke(lp + this.a / (double)500);
        double y = f$.invoke(lp);
        double z = 1.08883 * f$.invoke(lp - this.b / (double)200);
        return new XYZ(x * (double)100, y * (double)100, z * (double)100);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this;
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public LAB(double l, double a, double b) {
        boolean bl;
        this.l = l;
        this.a = a;
        this.b = b;
        double d = this.l;
        boolean bl2 = bl = d >= 0.0 && d <= 100.0;
        if (!bl) {
            String string = "l must be in interval [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return ConvertibleColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return ConvertibleColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return ConvertibleColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return ConvertibleColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    @NotNull
    public final LAB copy(double l, double a, double b) {
        return new LAB(l, a, b);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LAB copy$default(LAB lAB, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = lAB.l;
        }
        if ((n & 2) != 0) {
            d2 = lAB.a;
        }
        if ((n & 4) != 0) {
            d3 = lAB.b;
        }
        return lAB.copy(d, d2, d3);
    }

    public String toString() {
        return "LAB(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.l);
        long l2 = Double.doubleToLongBits(this.a);
        long l3 = Double.doubleToLongBits(this.b);
        return ((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LAB)) break block3;
                LAB lAB = (LAB)object;
                if (Double.compare(this.l, lAB.l) != 0 || Double.compare(this.a, lAB.a) != 0 || Double.compare(this.b, lAB.b) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

