/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangedPsiRangeUtil {
    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result2 = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result2;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result2;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text2, boolean fromStart) {
        if (treeElement == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(1);
        }
        int patternIndex = fromStart ? 0 : text2.length() - 1;
        int finalPatternIndex = fromStart ? text2.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result2 = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = ChangedPsiRangeUtil.getLeafMatchingLength(chars, text2, patternIndex, finalPatternIndex, direction);
                result2 += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result2;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file2, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file2 == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(2);
        }
        if (treeElement == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(3);
        }
        if (newDocumentText == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(4);
        }
        int psiLength = treeElement.getTextLength();
        if (!file2.getViewProvider().supportsIncrementalReparse(file2.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = ChangedPsiRangeUtil.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(ChangedPsiRangeUtil.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    @Nullable
    static ProperTextRange getChangedPsiRange(@NotNull PsiFile file2, @NotNull Document document, @NotNull CharSequence oldDocumentText, @NotNull CharSequence newDocumentText) {
        if (file2 == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(6);
        }
        if (oldDocumentText == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(7);
        }
        if (newDocumentText == null) {
            ChangedPsiRangeUtil.$$$reportNull$$$0(8);
        }
        int psiLength = oldDocumentText.length();
        if (!file2.getViewProvider().supportsIncrementalReparse(file2.getLanguage())) {
            return new ProperTextRange(0, psiLength);
        }
        List<DocumentEvent> events = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file2.getProject())).getEventsSinceCommit(document);
        int prefix = Integer.MAX_VALUE;
        int suffix = Integer.MAX_VALUE;
        int lengthBeforeEvent = psiLength;
        for (DocumentEvent event : events) {
            prefix = Math.min(prefix, event.getOffset());
            suffix = Math.min(suffix, lengthBeforeEvent - event.getOffset() - event.getOldLength());
            lengthBeforeEvent = lengthBeforeEvent - event.getOldLength() + event.getNewLength();
        }
        if ((prefix == psiLength || suffix == psiLength) && newDocumentText.length() == psiLength) {
            return null;
        }
        int shortestLength = Math.min(psiLength, newDocumentText.length());
        while (prefix < shortestLength && oldDocumentText.charAt(prefix) == newDocumentText.charAt(prefix)) {
            ++prefix;
        }
        while (suffix < shortestLength - prefix && oldDocumentText.charAt(psiLength - suffix - 1) == newDocumentText.charAt(newDocumentText.length() - suffix - 1)) {
            ++suffix;
        }
        int end = Math.max(prefix, psiLength - suffix);
        if (end == prefix && newDocumentText.length() == oldDocumentText.length()) {
            return null;
        }
        return ProperTextRange.create(prefix, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDocumentText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDocumentText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/ChangedPsiRangeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchingLength";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangedPsiRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

