/*
 * Decompiled with CFR 0.152.
 */
package org.kathrynhuxtable.maven.wagon.gitsite.git;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitSiteCheckOutCommand
extends AbstractCheckOutCommand
implements GitCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (!fileSet.getBasedir().exists()) {
            if (!fileSet.getBasedir().mkdir()) {
                return new CheckOutScmResult("make directory", "The directory create failed.", "", false);
            }
        } else {
            try {
                FileUtils.cleanDirectory((File)fileSet.getBasedir());
            }
            catch (IOException e) {
                return new CheckOutScmResult("clean directory", "The directory cleanup failed.", e.getMessage(), false);
            }
        }
        Commandline cl = null;
        cl = this.createInitCommand(fileSet.getBasedir());
        int exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0 || !new File(fileSet.getBasedir(), ".git").exists()) {
            return new CheckOutScmResult(cl.toString(), "The git-init command failed.", stderr.getOutput(), false);
        }
        cl = this.createRemoteAddOriginCommand(fileSet.getBasedir(), repository);
        exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The git-remote command failed.", stderr.getOutput(), false);
        }
        cl = this.createPullCommand(fileSet.getBasedir(), version);
        exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The git-pull command failed.", stderr.getOutput(), false);
        }
        GitListConsumer listConsumer = new GitListConsumer(this.getLogger(), fileSet.getBasedir(), ScmFileStatus.CHECKED_IN);
        cl = GitListCommand.createCommandLine((GitScmProviderRepository)repository, (File)fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)listConsumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), listConsumer.getListedFiles());
    }

    private Commandline createInitCommand(File workingDirectory) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"init");
        return cl;
    }

    private Commandline createRemoteAddOriginCommand(File workingDirectory, GitScmProviderRepository repository) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"remote");
        cl.createArg().setValue("add");
        cl.createArg().setValue("origin");
        cl.createArg().setValue(repository.getFetchUrl());
        return cl;
    }

    private Commandline createPullCommand(File workingDirectory, ScmVersion version) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"pull");
        cl.createArg().setValue("origin");
        cl.createArg().setValue("refs/heads/" + version.getName());
        return cl;
    }
}

