/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;

public class FileCopier {
    private static final int VERSION = 0;
    private final Log log;

    public FileCopier(Log log) {
        this.log = log;
    }

    public void syncDirs(@NotNull File from, @NotNull File to, @NotNull File snapshotsStorageFile) {
        try {
            this.syncDirsImpl(from, to, snapshotsStorageFile);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Could not copy Kotlin files from " + from + " to " + to), (Throwable)e);
        }
    }

    private void syncDirsImpl(@NotNull File sourceBaseFile, @NotNull File targetBaseFile, @NotNull File snapshotsStorageFile) throws IOException {
        Map<String, FileSnapshot> previousSnapshots = this.readFileSnapshots(snapshotsStorageFile);
        Path sourceBase = Paths.get(sourceBaseFile.getPath(), new String[0]).normalize();
        Path targetBase = Paths.get(targetBaseFile.getPath(), new String[0]).normalize();
        HashMap<String, FileSnapshot> newSnapshots = new HashMap<String, FileSnapshot>();
        for (Path path : Files.walk(sourceBase, new FileVisitOption[0]).collect(Collectors.toList())) {
            FileSnapshot prevSnapshot;
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            String relativePath = sourceBase.relativize(path).toString();
            File file = path.toFile();
            FileSnapshot snapshot = new FileSnapshot(file.lastModified(), file.length());
            if (!snapshot.equals(prevSnapshot = previousSnapshots.remove(relativePath))) {
                Path target = targetBase.resolve(relativePath);
                if (!Files.isDirectory(target, new LinkOption[0])) {
                    Files.deleteIfExists(target);
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(path, target, new CopyOption[0]);
                }
                this.log.debug((CharSequence)("Copied " + path + " to " + target));
            }
            newSnapshots.put(relativePath, snapshot);
        }
        for (String removedPath : previousSnapshots.keySet()) {
            Path target = targetBase.resolve(removedPath);
            this.log.debug((CharSequence)("Deleted " + target + " as it is no longer present in " + sourceBase));
            if (!Files.isRegularFile(target, new LinkOption[0])) continue;
            Files.delete(target);
        }
        this.writeFileSnapshots(newSnapshots, snapshotsStorageFile);
    }

    private void writeFileSnapshots(@NotNull Map<String, FileSnapshot> snapshots, @NotNull File outputFile) {
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));){
            output.writeInt(0);
            output.writeInt(snapshots.size());
            for (Map.Entry<String, FileSnapshot> entry : snapshots.entrySet()) {
                String path = entry.getKey();
                output.writeUTF(path);
                FileSnapshot snapshot = entry.getValue();
                output.writeLong(snapshot.lastModified);
                output.writeLong(snapshot.size);
            }
        }
        catch (Exception e) {
            this.log.debug((CharSequence)("Couldn't write copied files list to " + outputFile), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<String, FileSnapshot> readFileSnapshots(@NotNull File inputFile) {
        HashMap<String, FileSnapshot> snapshots = new HashMap<String, FileSnapshot>();
        if (!inputFile.isFile()) {
            return snapshots;
        }
        try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(inputFile)));){
            int version = input.readInt();
            if (version != 0) {
                HashMap<String, FileSnapshot> hashMap = snapshots;
                return hashMap;
            }
            int size = input.readInt();
            int i = 0;
            while (i < size) {
                String path = input.readUTF();
                long lastModified = input.readLong();
                long fileSize = input.readLong();
                snapshots.put(path, new FileSnapshot(lastModified, fileSize));
                ++i;
            }
            return snapshots;
        }
        catch (Exception e) {
            this.log.debug((CharSequence)("Couldn't read copied files list from " + inputFile), (Throwable)e);
        }
        return snapshots;
    }

    private static class FileSnapshot {
        final long lastModified;
        final long size;

        private FileSnapshot(long lastModified, long size) {
            this.lastModified = lastModified;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSnapshot that = (FileSnapshot)o;
            if (this.lastModified != that.lastModified) {
                return false;
            }
            return this.size == that.size;
        }

        public int hashCode() {
            int result = (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }
    }
}

