/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.grizzly;

import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.glassfish.jersey.test.spi.TestHelper;

public class GrizzlyTestContainerFactory
implements TestContainerFactory {
    public TestContainer create(URI baseUri, DeploymentContext context) {
        return new GrizzlyTestContainer(baseUri, context);
    }

    private static class GrizzlyTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyTestContainer.class.getName());
        private URI baseUri;
        private final HttpServer server;

        private GrizzlyTestContainer(URI baseUri, DeploymentContext context) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).build(new Object[0]);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Creating GrizzlyTestContainer configured at the base URI " + TestHelper.zeroPortToAvailablePort((URI)baseUri));
            }
            if (context.getSslContext().isPresent() && context.getSslParameters().isPresent()) {
                SSLParameters sslParameters = (SSLParameters)context.getSslParameters().get();
                this.server = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)context.getResourceConfig(), (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator((SSLContext)context.getSslContext().get(), false, sslParameters.getNeedClientAuth(), sslParameters.getWantClientAuth()), (boolean)false);
                return;
            }
            this.server = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)context.getResourceConfig(), (boolean)false);
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.WARNING, "Ignoring start request - GrizzlyTestContainer is already started.");
            } else {
                LOGGER.log(Level.FINE, "Starting GrizzlyTestContainer...");
                try {
                    this.server.start();
                    if (this.baseUri.getPort() == 0) {
                        this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(this.server.getListener("grizzly").getPort()).build(new Object[0]);
                        LOGGER.log(Level.INFO, "Started GrizzlyTestContainer at the base URI " + this.baseUri);
                    }
                }
                catch (IOException ioe) {
                    throw new TestContainerException((Throwable)ioe);
                }
            }
        }

        public void stop() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.FINE, "Stopping GrizzlyTestContainer...");
                this.server.shutdownNow();
            } else {
                LOGGER.log(Level.WARNING, "Ignoring stop request - GrizzlyTestContainer is already stopped.");
            }
        }
    }
}

