/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.StagingActionMessages;

public class Parameters {
    private final String pluginGav;
    private final File deferredDirectoryRoot;
    private final File stagingDirectoryRoot;
    private String nexusUrl;
    private String serverId;
    private boolean keepStagingRepositoryOnCloseRuleFailure;
    private boolean keepStagingRepositoryOnFailure;
    private boolean skipStagingRepositoryClose;
    private boolean autoReleaseAfterClose;
    private boolean autoDropAfterRelease;
    private String stagingProfileId;
    private String stagingRepositoryId;
    private StagingActionMessages stagingActionMessages;
    private Map<String, String> tags;
    private int stagingProgressTimeoutMinutes;
    private int stagingProgressPauseDurationSeconds;
    private boolean sslInsecure;
    private boolean sslAllowAll;

    public Parameters(String pluginGav, File deferredDirectoryRoot, File stagingDirectoryRoot) {
        this.pluginGav = (String)Preconditions.checkNotNull((Object)pluginGav, (Object)"Plugin GAV is null");
        this.deferredDirectoryRoot = (File)Preconditions.checkNotNull((Object)deferredDirectoryRoot, (Object)"Deferred directory root is null");
        this.stagingDirectoryRoot = (File)Preconditions.checkNotNull((Object)stagingDirectoryRoot, (Object)"Staging directory root is null");
    }

    public void validateBasic() {
    }

    public void validateRemoting() {
        this.validateBasic();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.nexusUrl) ? 1 : 0) != 0, (Object)"Mandatory plugin parameter 'nexusUrl' is missing");
        Preconditions.checkArgument((this.nexusUrl.toLowerCase(Locale.ENGLISH).startsWith("https") || this.nexusUrl.toLowerCase(Locale.ENGLISH).startsWith("http") ? 1 : 0) != 0, (Object)"Mandatory plugin parameter 'nexusUrl' must start with http or https");
        Preconditions.checkArgument((!this.nexusUrl.contains("/service/local/") && !this.nexusUrl.contains("/content/repositories/") ? 1 : 0) != 0, (Object)"Mandatory plugin parameter 'nexusUrl' should be your Nexus base URL only - for example http://localhost:8081/nexus");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.serverId) ? 1 : 0) != 0, (Object)"Mandatory plugin parameter 'serverId' is missing");
    }

    public void validateStaging() {
        this.validateRemoting();
        Preconditions.checkNotNull((Object)this.stagingActionMessages, (Object)"Staging action messages is null");
    }

    public String getPluginGav() {
        return this.pluginGav;
    }

    public File getDeferredDirectoryRoot() {
        return this.deferredDirectoryRoot;
    }

    public File getStagingDirectoryRoot() {
        return this.stagingDirectoryRoot;
    }

    public String getActionDescription(StagingAction action) {
        return this.stagingActionMessages.getMessageForAction(action);
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public boolean isKeepStagingRepositoryOnCloseRuleFailure() {
        return this.keepStagingRepositoryOnCloseRuleFailure;
    }

    public void setKeepStagingRepositoryOnCloseRuleFailure(boolean keepStagingRepositoryOnCloseRuleFailure) {
        this.keepStagingRepositoryOnCloseRuleFailure = keepStagingRepositoryOnCloseRuleFailure;
    }

    public boolean isKeepStagingRepositoryOnFailure() {
        return this.keepStagingRepositoryOnFailure;
    }

    public void setKeepStagingRepositoryOnFailure(boolean keepStagingRepositoryOnFailure) {
        this.keepStagingRepositoryOnFailure = keepStagingRepositoryOnFailure;
    }

    public boolean isSkipStagingRepositoryClose() {
        return this.skipStagingRepositoryClose;
    }

    public void setSkipStagingRepositoryClose(boolean skipStagingRepositoryClose) {
        this.skipStagingRepositoryClose = skipStagingRepositoryClose;
    }

    public boolean isAutoReleaseAfterClose() {
        return this.autoReleaseAfterClose;
    }

    public void setAutoReleaseAfterClose(boolean autoReleaseAfterClose) {
        this.autoReleaseAfterClose = autoReleaseAfterClose;
    }

    public boolean isAutoDropAfterRelease() {
        return this.autoDropAfterRelease;
    }

    public void setAutoDropAfterRelease(boolean autoDropAfterRelease) {
        this.autoDropAfterRelease = autoDropAfterRelease;
    }

    public String getStagingProfileId() {
        return this.stagingProfileId;
    }

    public void setStagingProfileId(String stagingProfileId) {
        this.stagingProfileId = stagingProfileId;
    }

    public String getStagingRepositoryId() {
        return this.stagingRepositoryId;
    }

    public void setStagingRepositoryId(String stagingRepositoryId) {
        this.stagingRepositoryId = stagingRepositoryId;
    }

    public StagingActionMessages getStagingActionMessages() {
        return this.stagingActionMessages;
    }

    public void setStagingActionMessages(StagingActionMessages stagingActionMessages) {
        this.stagingActionMessages = stagingActionMessages;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public int getStagingProgressTimeoutMinutes() {
        return this.stagingProgressTimeoutMinutes;
    }

    public void setStagingProgressTimeoutMinutes(int stagingProgressTimeoutMinutes) {
        this.stagingProgressTimeoutMinutes = stagingProgressTimeoutMinutes;
    }

    public int getStagingProgressPauseDurationSeconds() {
        return this.stagingProgressPauseDurationSeconds;
    }

    public void setStagingProgressPauseDurationSeconds(int stagingProgressPauseDurationSeconds) {
        this.stagingProgressPauseDurationSeconds = stagingProgressPauseDurationSeconds;
    }

    public boolean isSslInsecure() {
        return this.sslInsecure;
    }

    public void setSslInsecure(boolean sslInsecure) {
        this.sslInsecure = sslInsecure;
    }

    public boolean isSslAllowAll() {
        return this.sslAllowAll;
    }

    public void setSslAllowAll(boolean sslAllowAll) {
        this.sslAllowAll = sslAllowAll;
    }

    public String toString() {
        return "Parameters{pluginGav='" + this.pluginGav + '\'' + ", deferredDirectoryRoot=" + this.deferredDirectoryRoot + ", stagingDirectoryRoot=" + this.stagingDirectoryRoot + ", nexusUrl='" + this.nexusUrl + '\'' + ", serverId='" + this.serverId + '\'' + ", keepStagingRepositoryOnCloseRuleFailure=" + this.keepStagingRepositoryOnCloseRuleFailure + ", keepStagingRepositoryOnFailure=" + this.keepStagingRepositoryOnFailure + ", skipStagingRepositoryClose=" + this.skipStagingRepositoryClose + ", autoReleaseAfterClose=" + this.autoReleaseAfterClose + ", autoDropAfterRelease=" + this.autoDropAfterRelease + ", stagingProfileId='" + this.stagingProfileId + '\'' + ", stagingRepositoryId='" + this.stagingRepositoryId + '\'' + ", stagingActionMessages=" + this.stagingActionMessages + ", tags=" + this.tags + ", stagingProgressTimeoutMinutes=" + this.stagingProgressTimeoutMinutes + ", stagingProgressPauseDurationSeconds=" + this.stagingProgressPauseDurationSeconds + ", sslInsecure=" + this.sslInsecure + ", sslAllowAll=" + this.sslAllowAll + '}';
    }
}

