/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.StagingActionMessages;
import org.sonatype.nexus.maven.staging.remote.Parameters;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public abstract class AbstractStagingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${plugin.groupId}", readonly=true, required=true)
    private String pluginGroupId;
    @Parameter(defaultValue="${plugin.artifactId}", readonly=true, required=true)
    private String pluginArtifactId;
    @Parameter(defaultValue="${plugin.version}", readonly=true, required=true)
    private String pluginVersion;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${settings.offline}", readonly=true, required=true)
    private boolean offline;
    @Component
    private SecDispatcher secDispatcher;
    @Parameter(property="altStagingDirectory")
    private File altStagingDirectory;
    @Parameter(property="nexusUrl")
    private String nexusUrl;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="stagingDescription")
    private String stagingDescription;
    @Parameter
    private Map<String, String> stagingDescriptions;
    @Parameter(property="keepStagingRepositoryOnCloseRuleFailure")
    private boolean keepStagingRepositoryOnCloseRuleFailure;
    @Parameter(property="autoReleaseAfterClose", defaultValue="false")
    private boolean autoReleaseAfterClose;
    @Parameter(property="autoDropAfterRelease", defaultValue="true")
    private boolean autoDropAfterRelease;
    @Parameter(property="stagingProgressTimeoutMinutes", defaultValue="5")
    private int stagingProgressTimeoutMinutes = 5;
    @Parameter(property="stagingProgressPauseDurationSeconds", defaultValue="3")
    private int stagingProgressPauseDurationSeconds = 3;
    @Parameter(property="detectBuildFailures", defaultValue="true")
    private boolean detectBuildFailures;
    @Parameter(property="maven.wagon.http.ssl.insecure", defaultValue="false")
    private boolean sslInsecure;
    @Parameter(property="maven.wagon.http.ssl.allowall", defaultValue="false")
    private boolean sslAllowAll;

    protected String getNexusUrl() {
        return this.nexusUrl;
    }

    protected String getServerId() {
        return this.serverId;
    }

    protected StagingActionMessages getStagingActionMessages() throws MojoExecutionException {
        HashMap<StagingAction, String> messages = new HashMap<StagingAction, String>();
        if (this.stagingDescriptions != null) {
            for (Map.Entry<String, String> entry : this.stagingDescriptions.entrySet()) {
                try {
                    messages.put(StagingAction.valueOf(entry.getKey().toUpperCase()), entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("stagingDescriptions map contains unmappable key: " + entry.getKey());
                }
            }
        }
        return new StagingActionMessages(this.stagingDescription, messages, this.getRootProjectGav());
    }

    public boolean isKeepStagingRepositoryOnCloseRuleFailure() {
        return this.keepStagingRepositoryOnCloseRuleFailure;
    }

    public boolean isAutoReleaseAfterClose() {
        return this.autoReleaseAfterClose;
    }

    public boolean isAutoDropAfterRelease() {
        return this.autoDropAfterRelease;
    }

    protected MavenSession getMavenSession() {
        return this.mavenSession;
    }

    protected SecDispatcher getSecDispatcher() {
        return this.secDispatcher;
    }

    protected String getPluginGav() {
        return this.pluginGroupId + ":" + this.pluginArtifactId + ":" + this.pluginVersion;
    }

    protected String getRootProjectGav() {
        MavenProject rootProject = this.getFirstProjectWithThisPluginDefined();
        if (rootProject != null) {
            return rootProject.getGroupId() + ":" + rootProject.getArtifactId() + ":" + rootProject.getVersion();
        }
        return "unknown";
    }

    protected int getStagingProgressTimeoutMinutes() {
        return this.stagingProgressTimeoutMinutes;
    }

    protected int getStagingProgressPauseDurationSeconds() {
        return this.stagingProgressPauseDurationSeconds;
    }

    protected boolean isSslInsecure() {
        return this.sslInsecure;
    }

    protected boolean isSslAllowAll() {
        return this.sslAllowAll;
    }

    protected void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot use Staging features in Offline mode, as REST Requests are needed to be made against Nexus even while locally staging only.");
        }
    }

    protected MavenProject getFirstProjectWithThisPluginDefined() {
        return org.sonatype.maven.mojo.execution.MojoExecution.getFirstProjectWithMojoInExecution((MavenSession)this.mavenSession, (String)this.pluginGroupId, (String)this.pluginArtifactId, null);
    }

    protected boolean isThisLastProjectWithThisMojoInExecution() {
        boolean result = "default-cli".equals(this.mojoExecution.getExecutionId()) ? org.sonatype.maven.mojo.execution.MojoExecution.isCurrentTheLastProjectInExecution((MavenSession)this.mavenSession) : org.sonatype.maven.mojo.execution.MojoExecution.isCurrentTheLastProjectWithMojoInExecution((MavenSession)this.mavenSession, (String)this.pluginGroupId, (String)this.pluginArtifactId, (String)this.mojoExecution.getMojoDescriptor().getGoal());
        if (result) {
            try {
                if (this.mavenSession.isParallel()) {
                    this.waitForOtherProjectsIfNeeded();
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            try {
                if (this.getMavenSession().getResult().hasExceptions()) {
                    if (this.detectBuildFailures) {
                        this.getLog().info((CharSequence)"Earlier build failures detected. Staging will not continue.");
                        return false;
                    }
                    if (!this.detectBuildFailures) {
                        this.getLog().warn((CharSequence)"Earlier build failures detected. Staging is configured to not detect build failures, continuing...");
                    }
                }
                return true;
            }
            catch (NoSuchMethodError e) {
                this.getLog().info((CharSequence)"Unable to detect build failures with Maven 2, continuing...");
                return true;
            }
        }
        this.getLog().info((CharSequence)"Execution skipped to the last project...");
        return false;
    }

    protected void waitForOtherProjectsIfNeeded() {
        MavenProject currentProject = this.getMavenSession().getCurrentProject();
        while (true) {
            boolean done = true;
            for (MavenProject project : this.getMavenSession().getProjects()) {
                if (currentProject != project && this.getMavenSession().getResult().getBuildSummary(project) == null) {
                    done = false;
                    break;
                }
                if (currentProject != project) continue;
                break;
            }
            if (done) break;
            this.getLog().info((CharSequence)"Waiting for other projects build to finish...");
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected File getWorkDirectoryRoot() {
        if (this.altStagingDirectory != null) {
            return this.altStagingDirectory;
        }
        MavenProject firstWithThisMojo = this.getFirstProjectWithThisPluginDefined();
        if (firstWithThisMojo != null) {
            File firstWithThisMojoBuildDir = firstWithThisMojo.getBuild() != null && firstWithThisMojo.getBuild().getDirectory() != null ? new File(firstWithThisMojo.getBuild().getDirectory()).getAbsoluteFile() : new File(firstWithThisMojo.getBasedir().getAbsoluteFile(), "target");
            return new File(firstWithThisMojoBuildDir, "nexus-staging");
        }
        return new File(this.getMavenSession().getExecutionRootDirectory() + "/target/nexus-staging");
    }

    protected File getStagingDirectoryRoot() {
        return new File(this.getWorkDirectoryRoot(), "staging");
    }

    protected File getDeferredDirectoryRoot() {
        return new File(this.getWorkDirectoryRoot(), "deferred");
    }

    protected Parameters buildParameters() throws MojoExecutionException {
        try {
            Parameters parameters = new Parameters(this.getPluginGav(), this.getDeferredDirectoryRoot(), this.getStagingDirectoryRoot());
            parameters.setNexusUrl(this.getNexusUrl());
            parameters.setServerId(this.getServerId());
            parameters.setKeepStagingRepositoryOnCloseRuleFailure(this.isKeepStagingRepositoryOnCloseRuleFailure());
            parameters.setAutoReleaseAfterClose(this.isAutoReleaseAfterClose());
            parameters.setAutoDropAfterRelease(this.isAutoDropAfterRelease());
            parameters.setStagingActionMessages(this.getStagingActionMessages());
            parameters.setStagingProgressTimeoutMinutes(this.getStagingProgressTimeoutMinutes());
            parameters.setStagingProgressPauseDurationSeconds(this.getStagingProgressPauseDurationSeconds());
            parameters.setSslInsecure(this.isSslInsecure());
            parameters.setSslAllowAll(this.isSslAllowAll());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)parameters.toString());
            }
            return parameters;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Bad configuration:" + e.getMessage(), e);
        }
    }
}

